<?php
	//
	// Video Post Type related functions.
	//
	add_action( 'init', 'ci_create_cpt_video' );
	add_action( 'admin_init', 'ci_add_cpt_video_meta' );
	add_action( 'save_post', 'ci_update_cpt_video_meta' );

	function ci_create_cpt_video() {
		$labels = array(
			'name'               => _x( 'Videos', 'post type general name', 'ci_theme' ),
			'singular_name'      => _x( 'Video', 'post type singular name', 'ci_theme' ),
			'add_new'            => __( 'Add New', 'ci_theme' ),
			'add_new_item'       => __( 'Add New Video', 'ci_theme' ),
			'edit_item'          => __( 'Edit Video', 'ci_theme' ),
			'new_item'           => __( 'New Video', 'ci_theme' ),
			'view_item'          => __( 'View Video', 'ci_theme' ),
			'search_items'       => __( 'Search Videos', 'ci_theme' ),
			'not_found'          => __( 'No Videos found', 'ci_theme' ),
			'not_found_in_trash' => __( 'No Videos found in the trash', 'ci_theme' ),
			'parent_item_colon'  => __( 'Parent Video:', 'ci_theme' )
		);
	
		$args = array(
			'labels'          => $labels,
			'singular_label'  => __( 'Video', 'ci_theme' ),
			'public'          => true,
			'show_ui'         => true,
			'capability_type' => 'post',
			'hierarchical'    => false,
			'has_archive'     => false,
			'rewrite'         => array( 'slug' => _x( 'video', 'post type slug', 'ci_theme' ) ),
			'menu_position'   => 5,
			'supports'        => array( 'title' ),
			'menu_icon'       => 'dashicons-format-video'
		);
	
		register_post_type( 'cpt_video' , $args );
	
	}
	
	function ci_add_cpt_video_meta() {
		add_meta_box( 'ci-videos-box', __( 'Video Settings', 'ci_theme' ), 'ci_add_cpt_video_meta_box', 'cpt_video', 'normal', 'high' );
	}

	function ci_update_cpt_video_meta( $post_id ) {
		if ( ! ci_can_save_meta( 'cpt_video' ) ) return;

		update_post_meta( $post_id, 'video_url', esc_url_raw( $_POST['video_url'] ) );
	
	}

	function ci_add_cpt_video_meta_box( $object, $box ) {
		ci_prepare_metabox( 'cpt_video' );
	
		?><div class="ci-cf-wrap"><?php
			ci_metabox_open_tab( '' );
			ci_metabox_guide( sprintf( __( 'Just paste the URL of your video here. <a href="%s">WordPress supports a wide range of video services.</a>', 'ci_theme' ), 'https://codex.wordpress.org/Embeds' ) );
			ci_metabox_input( 'video_url', __( 'Video url:', 'ci_theme' ), array( 'esc_func' => 'esc_url' ) );
			ci_metabox_close_tab();
		?></div><?php
	
	}
