<?php
add_action( 'widgets_init', 'ci_widgets_init' );
if ( !function_exists('ci_widgets_init') ) :
function ci_widgets_init() {

	register_sidebar( array(
		'name'          => esc_html_x( 'Blog', 'widget area', 'ci_theme' ),
		'id'            => 'blog',
		'description'   => __('This is the main sidebar.', 'ci_theme'),
		'before_widget' => '<aside id="%1$s" class="widget group %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => esc_html_x( 'Header Right', 'widget area', 'ci_theme' ),
		'id'            => 'head-right',
		'description'   => __( 'Widgets placed here will appear at the top right section of the website\'s header. Suggested widgets are the Socials Ignited and the WPML Language Selector widget.', 'ci_theme' ),
		'before_widget' => '<aside id="%1$s" class="widget group %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>'
	) );

	register_sidebar( array(
		'name'          => __( 'Homepage', 'ci_theme' ),
		'id'            => 'home',
		'description'   => __( 'Widget area of the homepage.', 'ci_theme' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="section-title">',
		'after_title'   => '</h2>'
	) );

	register_sidebar( array(
		'name'          => esc_html_x( 'Pages', 'widget area', 'ci_theme' ),
		'id'            => 'page',
		'description'   => __( 'Widgets placed in this sidebar will appear in the static pages.', 'ci_theme' ),
		'before_widget' => '<aside id="%1$s" class="widget group %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>'
	) );

	register_sidebar( array(
		'name'          => esc_html_x( 'Rooms - Left', 'widget area', 'ci_theme' ),
		'id'            => 'room-left',
		'description'   => __( 'Widgets placed in this sidebar will appear in the room pages.', 'ci_theme' ),
		'before_widget' => '<aside id="%1$s" class="widget group %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>'
	) );

	register_sidebar( array(
		'name'          => esc_html_x( 'Rooms - Right', 'widget area', 'ci_theme' ),
		'id'            => 'room-right',
		'description'   => __( 'Widgets placed in this sidebar will appear in the room pages.', 'ci_theme' ),
		'before_widget' => '<aside id="%1$s" class="widget group %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>'
	) );

	register_sidebar( array(
		'name'          => esc_html_x( 'Attractions', 'widget area', 'ci_theme' ),
		'id'            => 'attraction',
		'description'   => __( 'Widgets placed in this sidebar will appear in the attraction pages.', 'ci_theme' ),
		'before_widget' => '<aside id="%1$s" class="widget group %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>'
	) );

	register_sidebar( array(
		'name'          => esc_html_x( 'Services', 'widget area', 'ci_theme' ),
		'id'            => 'service',
		'description'   => __( 'Widgets placed in this sidebar will appear in the service pages.', 'ci_theme' ),
		'before_widget' => '<aside id="%1$s" class="widget group %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>'
	) );

	register_sidebar( array(
		'name'          => __( 'Inner Widgets', 'ci_theme' ),
		'id'            => 'bottom-widgets',
		'description'   => __( 'Full width widget area which will appear before the footer in every page, except from the homepage.', 'ci_theme' ),
		'before_widget' => '<section id="%1$s" class="widget group %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="section-title">',
		'after_title'   => '</h2>'
	) );

	register_sidebar( array(
		'name'          => esc_html_x( 'Footer', 'widget area', 'ci_theme' ),
		'id'            => 'footer',
		'description'   => __( 'Footer widgets appear across the whole website.', 'ci_theme' ),
		'before_widget' => '<aside id="%1$s" class="widget group %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

}
endif;
