<?php
class CI_Book_Room extends WP_Widget {

	function __construct() {
		$widget_ops  = array( 'description' => __( 'Displays a Booking call to action, for the currently viewed room. Only displayed in single room pages.', 'ci_theme' ) );
		$control_ops = array(/*'width' => 300, 'height' => 400*/ );
		parent::__construct( 'ci-book-room', $name = __( '-= Book Room =-', 'ci_theme' ), $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {

		if( ! is_singular( 'cpt_room' ) ) {
			return;
		}

		extract( $args );

		$price  = get_post_meta( get_the_id(), 'price', true );
		$text1  = str_replace( '%s', $price, $instance['text1'] );
		$text2  = str_replace( '%s', $price, $instance['text2'] );
		$text3  = str_replace( '%s', $price, $instance['text3'] );
		$button = $instance['button'];

		echo $before_widget;

		$price_text = array();

		if ( ! empty( $text1 ) ) {
			$price_text[] = '<b>' . $text1 . '</b>';
		}

		if ( ! empty( $text2 ) ) {
			$price_text[] = $text2;
		}

		if ( ! empty( $text3 ) ) {
			$price_text[] = '<span>' . $text3 . '</span>';
		}

		$price_text = implode( ' ', $price_text );

		?>
		<div class="book-widget-inner">
			<?php if ( ! empty( $price ) && ! empty( $price_text ) ): ?>
				<p class="book-now-price"><?php echo str_replace( '%s', $price, $price_text ); ?></p>
			<?php endif; ?>
			<p class="book-now-action">
				<a href="<?php echo esc_url( add_query_arg( 'room_select', get_the_ID(), get_permalink( intval( ci_setting( 'booking_form_page' ) ) ) ) ); ?>" class="btn"><?php echo $button; ?></a>
			</p>
		</div>
		<?php

		echo $after_widget;

	} // widget

	function update( $new_instance, $old_instance ) {
		$instance = array();

		$instance['button'] = sanitize_text_field( $new_instance['button'] );
		$instance['text1']  = sanitize_text_field( $new_instance['text1'] );
		$instance['text2']  = sanitize_text_field( $new_instance['text2'] );
		$instance['text3']  = sanitize_text_field( $new_instance['text3'] );

		return $instance;
	} // save

	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array(
			'button' => __( 'Book this room', 'ci_theme' ),
			'text1'  => 'From',
			'text2'  => '%s',
			'text3'  => '/ day',
		) );

		$button = $instance['button'];
		$text1  = $instance['text1'];
		$text2  = $instance['text2'];
		$text3  = $instance['text3'];

		?>
		<p><?php _e( 'This widget will display a booking button, using the price set in the Room Details of each room. If no price is set, only the button will be shown.', 'ci_theme' ); ?></p>
		<p><label for="<?php echo $this->get_field_id( 'button' ); ?>"><?php _e( 'Button text:', 'ci_theme' ); ?></label><input id="<?php echo $this->get_field_id( 'button' ); ?>" name="<?php echo $this->get_field_name( 'button' ); ?>" type="text" value="<?php echo esc_attr( $button ); ?>" class="widefat" /></p>
		<p><?php _e( 'You can change the price-related texts displayed this widget. Each piece of text is displayed with a distinct formatting. Use <strong>%s</strong> instead of the price.', 'ci_theme' ); ?></p>
		<p><label for="<?php echo $this->get_field_id( 'text1' ); ?>"><?php _e( 'Price text 1:', 'ci_theme' ); ?></label><input id="<?php echo $this->get_field_id( 'text1' ); ?>" name="<?php echo $this->get_field_name( 'text1' ); ?>" type="text" value="<?php echo esc_attr( $text1 ); ?>" class="widefat" /></p>
		<p><label for="<?php echo $this->get_field_id( 'text2' ); ?>"><?php _e( 'Price text 2:', 'ci_theme' ); ?></label><input id="<?php echo $this->get_field_id( 'text2' ); ?>" name="<?php echo $this->get_field_name( 'text2' ); ?>" type="text" value="<?php echo esc_attr( $text2 ); ?>" class="widefat" /></p>
		<p><label for="<?php echo $this->get_field_id( 'text3' ); ?>"><?php _e( 'Price text 3:', 'ci_theme' ); ?></label><input id="<?php echo $this->get_field_id( 'text3' ); ?>" name="<?php echo $this->get_field_name( 'text3' ); ?>" type="text" value="<?php echo esc_attr( $text3 ); ?>" class="widefat" /></p>
		<?php

	} // form

} // class

register_widget( 'CI_Book_Room' );
