<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php do_action( 'after_open_body_tag' ); ?>
<div id="page">
	<div id="mobile-bar">
		<a class="menu-trigger" href="#mobilemenu"><i class="fa fa-bars"></i></a>
		<p class="mob-title"><?php bloginfo( 'name' ); ?></p>
	</div>

	<?php
		if( ci_setting( 'header_style' ) == 'alt' ) {
			get_template_part( 'part-header-alt' );
		} else {
			get_template_part( 'part-header' );
		}
	?>

	<?php
		if( ! is_page_template( 'template-homepage.php' ) ) {
			get_template_part( 'part-hero' );
		}
	?>