( function( $ ) {
	'use strict';

	/* -----------------------------------------
	Responsive Menus Init with mmenu
	----------------------------------------- */
	var $mainNav   = $( '.navigation' );
	var $mobileNav = $( '#mobilemenu' );
	var $mobileNavList = $mobileNav.find( 'ul' );

	$mainNav.each( function() {
		$mobileNavList.append( $( this ).html() );
	} );

	$mobileNav.find( 'li' ).removeAttr( 'id' );

	$mobileNav.mmenu({
		offCanvas: {
			position: 'top',
			zposition: 'front'
		},
		"autoHeight": true,
		"navbars": [
			{
				"position": "top",
				"content": [
					"prev",
					"title",
					"close"
				]
			}
		]
	});

	/* -----------------------------------------
	Main Navigation Init
	----------------------------------------- */
	$mainNav.superfish({
		delay: 300,
		animation: { opacity: 'show', height: 'show' },
		speed: 'fast',
		dropShadows: false
	});

	/* -----------------------------------------
	Responsive Videos with fitVids
	----------------------------------------- */
	$( 'body' ).fitVids();

	/* -----------------------------------------
	Image Lightbox
	----------------------------------------- */
	$( '.ci-lightbox' ).magnificPopup({
		type: 'image',
		mainClass: 'mfp-with-zoom',
		gallery: {
			enabled: true
		},
		zoom: {
			enabled: true
		}
	});

	/* -----------------------------------------
	Item Hover Effect
	----------------------------------------- */
	var $item = $( '.item' );
	$item.on( 'mouseover', function(e) {
		var $that = $(this);
		$that.parents('.item-list').find('.item').not($(this)).addClass('transparent');
	}).on( 'mouseout', function(e) {
		var $that = $(this);
		$that.parents('.item-list').find('.item').removeClass('transparent');
	} );

	/* -----------------------------------------
	Weather Code
	----------------------------------------- */
	var $weather = $( '.resort-weather' );
	if ( $weather.length ) {
		var weather_woeid = $weather.data( 'woeid' );
		var weather_unit = $weather.data( 'unit' );

		var wq = "SELECT * FROM weather.forecast WHERE woeid='" + weather_woeid + "' AND u='" + weather_unit + "'";
		var cb = Math.floor((new Date().getTime()) / 1200 / 1000);
		var wu = 'http://query.yahooapis.com/v1/public/yql?q=' + encodeURIComponent(wq) + '&format=json&_nocache=' + cb;

		window['ywcb'] = function( data ) {
			var info    = data.query.results.channel.item.condition;
			var city    = data.query.results.channel.location.city;
			var country = data.query.results.channel.location.country;
			var unit    = data.query.results.channel.units.temperature;
			$( '.ywicon' ).addClass( 'wi-yw-' + info['code'] );
			$( '.resort-location' ).html( city + ',' + country );
			$( '.resort-temperature' ).html( info.temp + '<sup>' + '&deg;' + unit + '</sup>' );
		};

		$.ajax({
			url: wu,
			dataType: 'jsonp',
			cache: true,
			jsonpCallback: 'ywcb'
		});
	}

	/* -----------------------------------------
	Datepickers
	----------------------------------------- */
	// The datepickers must output the format yy/mm/dd otherwise PHP's checkdate() fails.
	// Makes sure arrival date is not after departure date, and vice versa.
	$( ".datepicker[name='arrive']" ).datepicker({
		showOn: 'both',
		buttonText: '<i class="fa fa-calendar"></i>',
		dateFormat: 'yy/mm/dd',
		minDate: new Date(),
		onSelect: function(dateText, dateObj){
			var minDate = new Date( dateObj.selectedYear, dateObj.selectedMonth, dateObj.selectedDay );
			minDate.setDate(minDate.getDate()+1);
			$( ".datepicker[name='depart']" ).datepicker("option", "minDate", minDate );
		}
	});

	$( ".datepicker[name='depart']" ).datepicker({
		showOn: 'both',
		buttonText: '<i class="fa fa-calendar"></i>',
		dateFormat: 'yy/mm/dd',
		minDate: new Date(),
		onSelect: function(dateText, dateObj) {
			//var maxDate = new Date(dateText);
			var maxDate = new Date( dateObj.selectedYear, dateObj.selectedMonth, dateObj.selectedDay );
			maxDate.setDate(maxDate.getDate()-1);
			$( ".datepicker[name='arrive']" ).datepicker("option", "maxDate", maxDate );
		}
	});

	/* -----------------------------------------
	Parallax
	----------------------------------------- */
	$( '.parallax' ).each(function() {
		var that = $( this );
		that.parallax( '50%', that.data( 'speed' ) );
	});

	/* -----------------------------------------
	Map Init
	----------------------------------------- */

	function map_init(lat, lng, zoom, tipText, titleText, map_id) {
		if ( typeof google === 'object' && typeof google.maps === 'object' ) {
			var myLatlng = new google.maps.LatLng( lat, lng );
			var mapOptions = {
				zoom: zoom, center: myLatlng, mapTypeId: google.maps.MapTypeId.ROADMAP
			};

			var map = new google.maps.Map( document.getElementById( map_id ), mapOptions );

			var contentString = '<div class="tip-content">' + tipText + '</div>';

			var infowindow = new google.maps.InfoWindow( {
				content: contentString
			} );

			var marker = new google.maps.Marker( {
				position: myLatlng, map: map, title: titleText
			} );

			google.maps.event.addListener( marker, 'click', function() {
				infowindow.open( map, marker );
			} );
		}
	}

	var $cmap = $(".ci-map");
	if ( $cmap.length ) {
		$cmap.each(function() {
			var that = $ (this ),
					lat = that.data( 'lat'),
					lng = that.data( 'lng' ),
					zoom = that.data( 'zoom' ),
					tipText = that.data( 'tooltip-txt' ),
					titleText = that.attr( 'title' ),
					mapid = that.attr( 'id' );

			map_init( lat, lng, zoom, tipText, titleText, mapid );
		})

	}

	/* -----------------------------------------
	Custom Selects
	----------------------------------------- */
	$( '.dk' ).dropkick();

	$( window ).on( 'load', function() {

		/* -----------------------------------------
		FlexSlider Init
		----------------------------------------- */
		var homeSlider = $( '.home-slider' );

		if ( homeSlider.length ) {
			var animation      = homeSlider.data( 'animation' ),
					direction      = homeSlider.data( 'direction' ),
					slideshow      = homeSlider.data( 'slideshow' ),
					slideshowSpeed = homeSlider.data( 'slideshowspeed' ),
					animationSpeed = homeSlider.data( 'animationspeed' );

			homeSlider.flexslider({
				animation     : animation,
				direction     : direction,
				slideshow     : slideshow,
				slideshowSpeed: slideshowSpeed,
				animationSpeed: animationSpeed,
				directionNav: false,
				namespace: 'ci-',
				prevText: '',
				nextText: '',
				start: function( slider ) {
					slider.removeClass( 'loading' );
				}
			});
		}

		var roomSlider = $( '.room-slider' );

		function changeSliderCaption( slider ) {
			var currentSlideCaption = slider.slides.eq(slider.currentSlide).find( 'img' ).data( 'caption' );

			if ( currentSlideCaption ) {
				$imageCaption.html( '<span>' + currentSlideCaption + '</span>' ).css( 'max-width', '320px' );
			} else {
				$imageCaption.css( 'max-width', 0 );
			}
		}

		if ( roomSlider.length ) {
			var $imageCaption = $( '.image-caption' );

			roomSlider.flexslider({
				directionNav: false,
				controlNav: false,
				namespace: 'ci-',
				prevText: '',
				nextText: '',
				after: function( slider ) {
					changeSliderCaption( slider );
				},
				start: function( slider ) {
					slider.removeClass( 'loading' );
					changeSliderCaption( slider );
				}
			});

			$( '.room-control-prev').on( 'click', function(e) {
				e.preventDefault();
				roomSlider.flexslider( 'prev' );
			});

			$( '.room-control-next').on( 'click', function(e) {
				e.preventDefault();
				roomSlider.flexslider( 'next' );
			});
		}

		var testimonialSlider = $( '.slider-testimonials' );

		if ( testimonialSlider.length ) {
			testimonialSlider.flexslider({
				directionNav: false,
				namespace: 'ci-',
				prevText: '',
				nextText: ''
			});
		}

		/* -----------------------------------------
		Isotope Init
		----------------------------------------- */
		var $isotopeContainer = $( '.listing-isotope' ),
				$isotopeFilters   = $( '.filters-nav' );

		if ( $isotopeFilters.length ) {
			$isotopeContainer.isotope();

			var $filterLinks = $isotopeFilters.find( 'a' );

			$filterLinks.on( 'click', function( e ) {
				var $that = $( this ),
						selector = $that.attr( 'data-filter' );

				$filterLinks.removeClass( 'selected' );
				$that.addClass( 'selected' );

				$isotopeContainer.isotope({
					filter: selector,
					animationOptions: {
						duration: 750,
						easing  : 'linear',
						queue   : false
					}
				});
				e.preventDefault();
			});
		}
	});

})( jQuery );
