<?php get_header(); ?>

<main class="main">
	<div class="container">
		<div class="row">
			<?php while ( have_posts() ): the_post(); ?>
				<?php $set = ci_featgal_get_attachments(); ?>
				<?php if ( $set->have_posts() ): ?>
					<div class="col-xs-12">
						<div class="room-slider ci-slider loading">
							<ul class="slides">
								<?php while( $set->have_posts() ): $set->the_post(); ?>
									<?php $details = wp_prepare_attachment_for_js( get_the_ID() ); ?>
									<li>
										<a href="<?php echo esc_url( ci_get_image_src( get_the_ID(), 'large' ) ); ?>" class="ci-lightbox" title="<?php echo esc_attr( $details['caption'] ); ?>">
											<img src="<?php echo esc_url( ci_get_image_src( get_the_ID(), 'ci_room_slider' ) ); ?>" alt="<?php echo esc_attr( $details['alt'] ); ?>" />
										</a>
									</li>
								<?php endwhile; wp_reset_postdata(); ?>
							</ul>

							<div class="room-slider-controls">
								<p class="image-caption"><span></span></p>
								<a class="room-control-prev" href="#"><i class="fa fa-angle-left"></i></a>
								<a class="room-control-next" href="#"><i class="fa fa-angle-right"></i></a>
							</div>
						</div>
					</div>
				<?php endif; ?>

				<div class="col-md-8 col-sm-7">
					<div class="entry-content">
						<?php the_content(); ?>
					</div>
				</div>

				<div class="col-md-4 col-sm-5">
					<?php get_sidebar(); ?>
				</div>
			<?php endwhile; ?>
		</div>
	</div>
</main>

<?php get_footer(); ?>
