<?php get_header(); ?>

<main class="main">
	<div class="container">
		<div class="row">
			<div class="col-xs-12">
				<?php while ( have_posts() ): the_post(); ?>
					<div class="entry-content">
						<?php the_content(); ?>
					</div>

					<?php
						$set            = ci_featgal_get_attachments();
						$columns        = get_post_meta( get_the_ID(), 'columns', true );
						$column_classes = ci_theme_get_columns_classes( $columns );
					?>
					<?php if( $set->have_posts() ): ?>
						<div class="row row-joined item-list">
							<?php while ( $set->have_posts() ) : $set->the_post(); ?>
								<?php $details = wp_prepare_attachment_for_js( get_the_ID() ); ?>

								<div class="<?php echo esc_attr( $column_classes ); ?>">
									<div class="item cpt_gallery">
										<a href="<?php echo esc_url( ci_get_image_src( get_the_ID(), 'large' ) ); ?>" class="ci-lightbox ci-zoom" title="<?php echo esc_attr( $details['caption'] ); ?>">
											<img src="<?php echo esc_url( ci_get_image_src( get_the_ID(), 'ci_gallery' ) ); ?>" alt="<?php echo esc_attr( $details['alt'] ); ?>" />

											<?php if ( ! empty( $details['caption'] ) ): ?>
												<div class="item-details">
													<p class="item-title"><?php echo $details['caption']; ?></p>
												</div>
											<?php endif; ?>
										</a>
									</div>
								</div>
							<?php endwhile; wp_reset_postdata(); ?>
						</div>
					<?php endif; ?>

				<?php endwhile; ?>
			</div>
		</div>
	</div>
</main>

<?php get_footer(); ?>