<?php
/*
* Template Name: Page with Map
*/
?>

<?php get_header(); ?>

<main class="main">
	<div class="container">
		<div class="row">
			<?php while ( have_posts() ): the_post(); ?>
				<?php
					$lat         = get_post_meta( get_the_ID(), 'location_map_lat', true );
					$lon         = get_post_meta( get_the_ID(), 'location_map_lon', true );
					$zoom        = get_post_meta( get_the_ID(), 'location_map_zoom', true );
					$map_title   = get_post_meta( get_the_ID(), 'location_map_title', true );
					$map_tooltip = get_post_meta( get_the_ID(), 'location_map_tooltip', true );
				?>

				<?php if ( ! empty( $lat ) && ! empty( $lon ) ): ?>
					<div class="col-xs-12">
						<div class="map-wrap">
							<div id="ci-map" class="ci-map" data-lat="<?php echo esc_attr( $lat ); ?>" data-lng="<?php echo esc_attr( $lon ); ?>" data-zoom="<?php echo esc_attr( $zoom ); ?>" data-tooltip-txt="<?php echo esc_attr( $map_tooltip ); ?>" title="<?php echo esc_attr( $map_title ); ?>"></div>
						</div>
					</div>
				<?php endif; ?>

				<div class="col-md-8 col-sm-7">
					<article id="entry-<?php the_ID(); ?>" <?php post_class( 'entry' ); ?>>
						<?php if( has_post_thumbnail() ): ?>
							<figure class="entry-thumb">
								<a href="<?php echo ci_get_featured_image_src( 'large' ); ?>" class="ci-lightbox">
									<?php the_post_thumbnail(); ?>
								</a>
							</figure>
						<?php endif; ?>

						<div class="entry-content">
							<?php the_content(); ?>
							<?php wp_link_pages(); ?>
						</div>
					</article>

					<?php comments_template(); ?>
				</div>
			<?php endwhile; ?>

			<div class="col-md-4 col-sm-5">
				<?php get_sidebar(); ?>
			</div>
		</div>
	</div>
</main>

<?php get_footer(); ?>
