<?php
	//
	// Gallery Post Type related functions.
	//
	add_action( 'init', 'ci_create_cpt_gallery' );
	add_action( 'admin_init', 'ci_add_cpt_gallery_meta' );
	add_action( 'save_post', 'ci_update_cpt_gallery_meta' );

	function ci_create_cpt_gallery() {
		$labels = array(
			'name'               => _x( 'Galleries', 'post type general name', 'ci_theme' ),
			'singular_name'      => _x( 'Gallery', 'post type singular name', 'ci_theme' ),
			'add_new'            => __( 'Add New', 'ci_theme' ),
			'add_new_item'       => __( 'Add New Gallery', 'ci_theme' ),
			'edit_item'          => __( 'Edit Gallery', 'ci_theme' ),
			'new_item'           => __( 'New Gallery', 'ci_theme' ),
			'view_item'          => __( 'View Gallery', 'ci_theme' ),
			'search_items'       => __( 'Search Galleries', 'ci_theme' ),
			'not_found'          => __( 'No Galleries found', 'ci_theme' ),
			'not_found_in_trash' => __( 'No Galleries found in the trash', 'ci_theme' ),
			'parent_item_colon'  => __( 'Parent Gallery:', 'ci_theme' )
		);
	
		$args = array(
			'labels'          => $labels,
			'singular_label'  => __( 'Gallery', 'ci_theme' ),
			'public'          => true,
			'show_ui'         => true,
			'capability_type' => 'post',
			'hierarchical'    => false,
			'has_archive'     => false,
			'rewrite'         => array( 'slug' => _x( 'gallery', 'post type slug', 'ci_theme' ) ),
			'menu_position'   => 5,
			'supports'        => array( 'title', 'editor', 'thumbnail' ),
			'menu_icon'       => 'dashicons-format-gallery'
		);
	
		register_post_type( 'cpt_gallery' , $args );
	
	}
	
	function ci_add_cpt_gallery_meta() {
		add_meta_box( 'ci-gallery-box', __( 'Gallery Settings', 'ci_theme' ), 'ci_add_cpt_gallery_meta_box', 'cpt_gallery', 'normal', 'high' );
		add_meta_box( 'ci-header-bg-box', __( 'Header background', 'ci_theme' ), 'ci_add_cpt_header_bg_meta_box', 'cpt_gallery', 'normal', 'high' );
	}
	
	function ci_update_cpt_gallery_meta( $post_id ) {
		if ( ! ci_can_save_meta( 'cpt_gallery' ) ) return;

		update_post_meta( $post_id, 'header_image', esc_url_raw( $_POST['header_image'] ) );
		update_post_meta( $post_id, 'header_image_id', intval( $_POST['header_image_id'] ) );

		update_post_meta( $post_id, 'columns', intval( $_POST['columns'] ) );
		ci_metabox_gallery_save( $_POST );
	}


	function ci_add_cpt_gallery_meta_box( $object, $box ) {
		ci_prepare_metabox( 'cpt_gallery' );
	
		?><div class="ci-cf-wrap"><?php
			ci_metabox_open_tab( '' );
				ci_metabox_guide( __( "You can create a gallery by pressing the <em>Add Images</em> button below. You should also set a featured image that will be used as this Gallery's cover.", 'ci_theme' ) );
				ci_metabox_gallery();
	
				$options = array();
				for ( $i = 2; $i <= 4; $i ++ ) {
					$options[ $i ] = sprintf( _n( '1 Column', '%s Columns', $i, 'ci_theme' ), $i );
				}
				ci_metabox_dropdown( 'columns', $options, __( 'Number of columns to display this gallery in:', 'ci_theme' ), array( 'default' => 3 ) );

			ci_metabox_close_tab();
		?></div><?php
	}
	
