<?php
	//
	// Testimonials Post Type related functions.
	//
	add_action( 'init', 'ci_create_cpt_testimonial' );
	add_action( 'admin_init', 'ci_add_cpt_testimonial_meta' );
	add_action( 'save_post', 'ci_update_cpt_testimonial_meta' );

	function ci_create_cpt_testimonial() {
		$labels = array(
			'name'               => _x( 'Testimonials', 'post type general name', 'ci_theme' ),
			'singular_name'      => _x( 'Testimonial', 'post type singular name', 'ci_theme' ),
			'add_new'            => __( 'New Testimonial', 'ci_theme' ),
			'add_new_item'       => __( 'Add New Testimonial', 'ci_theme' ),
			'edit_item'          => __( 'Edit Testimonial', 'ci_theme' ),
			'new_item'           => __( 'New Testimonial', 'ci_theme' ),
			'view_item'          => __( 'View Testimonial', 'ci_theme' ),
			'search_items'       => __( 'Search Testimonials', 'ci_theme' ),
			'not_found'          => __( 'No Testimonials found', 'ci_theme' ),
			'not_found_in_trash' => __( 'No Testimonials found in the trash', 'ci_theme' ),
			'parent_item_colon'  => __( 'Parent Testimonial:', 'ci_theme' ),
		);

		$args = array(
			'labels'          => $labels,
			'singular_label'  => __( 'Testimonial', 'ci_theme' ),
			'public'          => false,
			'show_ui'         => true,
			'capability_type' => 'post',
			'hierarchical'    => false,
			'has_archive'     => false,
			'rewrite'         => array( 'slug' => _x( 'testimonial', 'post type slug', 'ci_theme' ) ),
			'menu_position'   => 5,
			'supports'        => array( 'title', 'editor' ),
			'menu_icon'       => 'dashicons-format-quote'
		);

		register_post_type( 'cpt_testimonial' , $args );
	}

	function ci_add_cpt_testimonial_meta() {
		add_meta_box( 'ci-testimonial-box', __( 'Testimonial by...', 'ci_theme' ), 'ci_add_cpt_testimonial_meta_box', 'cpt_testimonial', 'normal', 'high' );
	}

	function ci_update_cpt_testimonial_meta( $post_id ) {
		if ( ! ci_can_save_meta( 'cpt_testimonial' ) ) return;

	}

	function ci_add_cpt_testimonial_meta_box(){

		?><div class="ci-cf-wrap"><?php
			ci_metabox_open_tab( '' );
			ci_metabox_guide( __( 'Use the main title, to denote who made the testimonial.', 'ci_theme' ) );
			ci_metabox_close_tab();
		?></div><?php

	}
