<?php global $ci, $ci_defaults, $load_defaults; ?>
<?php if ($load_defaults===TRUE): ?>
<?php
	add_filter('ci_panel_tabs', 'ci_add_tab_color_options', 20);
	if( !function_exists('ci_add_tab_color_options') ):
		function ci_add_tab_color_options($tabs)
		{
			$tabs[sanitize_key(basename(__FILE__, '.php'))] = __('Appearance Options', 'ci_theme');
			return $tabs;
		}
	endif;

	// Default values for options go here.
	// $ci_defaults['option_name'] = 'default_value';
	// or
	// load_panel_snippet( 'snippet_name' );

	load_panel_snippet( 'custom_background' );
	load_panel_snippet( 'color_scheme' );

	$ci_defaults['weather_woeid']        = '957831';
	$ci_defaults['weather_unit']         = 'c';
	$ci_defaults['header_style']         = '';
	$ci_defaults['default_header_bg']    = ''; // Holds the URL of the image file to use as header background
	$ci_defaults['default_header_color'] = '479ce5'; // Holds the color to use as header background

?>
<?php else: ?>

	<fieldset class="set">
		<legend><?php _e( 'Weather Settings', 'ci_theme' ); ?></legend>

		<p class="guide"><?php echo sprintf( __( 'You can display the weather temperature for your location. Leaving the weather code empty, disables the weather display in the front end. Use the following box to search for your location. If the search didn\'t work for you, <a href="%s" target="_blank">go to this website</a>, enter your location and press search. Copy and paste in the following field the code. For example for Grenoble, France the code is <strong>593720</strong>.', 'ci_theme' ), 'http://woeid.rosselliot.co.nz' ); ?></p>
		<fieldset class="mb10">
			<label for="ci-select2-weather-city-lookup"><?php _e( 'City lookup:', 'ci_theme' ); ?></label>
			<select id="ci-select2-weather-city-lookup" class="ci-select2-weather-city-lookup">
				<option><?php _e( 'Type a place to search...', 'ci_theme' ); ?></option>
			</select>
		</fieldset>
		<?php ci_panel_input( 'weather_woeid', __( 'Weather Code', 'ci_theme' ) ); ?>
		<?php
			$weather_unit_options = array(
				'c' => __( 'Celsius', 'ci_theme' ),
				'f' => __( 'Fahrenheit', 'ci_theme' )
			);
			ci_panel_dropdown( 'weather_unit', $weather_unit_options, __( 'Temperature Unit.', 'ci_theme' ) );
		?>
	</fieldset>

	<fieldset class="set">
		<legend><?php _e( 'Header', 'ci_theme' ); ?></legend>

		<p class="guide"><?php _e( 'This theme comes with 2 header styles. The default, displays the logo in the middle of the page. The alternative, displays the logo on the left-hand side.', 'ci_theme' ); ?></p>
		<?php
			$options = array(
				''    => __( 'Default', 'ci_theme' ),
				'alt' => __( 'Alternative', 'ci_theme' )
			);
			ci_panel_dropdown( 'header_style', $options, __( 'Header style:', 'ci_theme' ) );
		?>
	</fieldset>

	<?php load_panel_snippet( 'color_scheme' ); ?>

	<fieldset class="set">
		<legend><?php _e( 'Header Display', 'ci_theme' ); ?></legend>

		<p class="guide">
			<?php
				$image_sizes = ci_get_image_sizes();
				$size = $image_sizes['ci_header']['width'] . 'x' . $image_sizes['ci_header']['height'];
				_e( 'Upload or select an image to be used as the default header background on your header. This will be displayed in all your inner pages except from the frontpage template with the slider. This is entirely optional.', 'ci_theme' );
				echo sprintf( __( 'For best results, use a high resolution image, at least %s pixels in size.', 'ci_theme' ), $size );
				_e( 'You may additionally set a background color (useful for having solid backgrounds or transparent images).', 'ci_theme' );
			?>
		</p>
		<?php
			ci_panel_upload_image( 'default_header_bg', __( 'Upload an image:', 'ci_theme' ) );
			ci_panel_input( 'default_header_color', __( 'Color:', 'ci_theme' ), array( 'input_class' => 'colorpckr' ) );
		?>
	</fieldset>

	<?php load_panel_snippet( 'custom_background' ); ?>

<?php endif; ?>