<?php global $ci, $ci_defaults, $load_defaults, $content_width; ?>
<?php if ($load_defaults===TRUE): ?>
<?php
	add_filter('ci_panel_tabs', 'ci_add_tab_titles_options', 70);
	if( !function_exists('ci_add_tab_titles_options') ):
		function ci_add_tab_titles_options($tabs)
		{
			$tabs[sanitize_key(basename(__FILE__, '.php'))] = __('Section titles', 'ci_theme');
			return $tabs;
		}
	endif;

	// Default values for options go here.
	// $ci_defaults['option_name'] = 'default_value';
	// or
	// load_panel_snippet( 'snippet_name' );
	$ci_defaults['title_blog'] = _x( 'From the blog', 'section title', 'ci_theme' );

	/* translators: %s is a price, including currency symbol. Example output: From $99 / day */
	$ci_defaults['room_price_format'] = __( 'From %s / day', 'ci_theme' );
	$ci_defaults['room_offer_text']   = __( 'Special Offer', 'ci_theme' );

?>
<?php else: ?>

	<fieldset class="set">
		<legend><?php _e( 'Section titles', 'ci_theme' ); ?></legend>

		<p class="guide"><?php _e( 'Set the title for the blog section of your website. This title appears on top of listing pages and/or single posts.', 'ci_theme' ); ?></p>
		<?php ci_panel_input( 'title_blog', __( 'Blog section title:', 'ci_theme' ) ); ?>
	</fieldset>

	<fieldset class="set">
		<legend><?php _e( 'Rooms', 'ci_theme' ); ?></legend>

		<p class="guide"><?php _e( "This text appears wherever the room price is displayed. Type <strong>%s</strong> to replace it with the actual room's price. E.g. <strong>From €%s per night</strong> or <strong>From %s AUD / day</strong>", 'ci_theme' ); ?></p>
		<?php ci_panel_input( 'room_price_format', __( 'Room price format:', 'ci_theme' ) ); ?>

		<p class="guide"><?php _e( 'This text appears when a room is marked as "On offer".', 'ci_theme' ); ?></p>
		<?php ci_panel_input( 'room_offer_text', __( 'Room offer text:', 'ci_theme' ) ); ?>
	</fieldset>

<?php endif; ?>