<?php
	global $columns;
	$thumb_size = $columns == 2 ? 'ci_gallery' : 'ci_square';
	$price      = get_post_meta( get_the_ID(), 'price', true );
	$on_offer   = get_post_meta( get_the_ID(), 'on_offer', true );
?>

<div <?php post_class( 'item' ); ?>>
	<a href="<?php the_permalink(); ?>">
		<?php the_post_thumbnail( $thumb_size ); ?>

		<div class="item-details">
			<p class="item-title"><?php the_title(); ?></p>

			<p class="item-subtitle">
				<?php
					if ( ! empty( $price ) ) {
						echo sprintf( ci_setting( 'room_price_format' ), $price );
					}
				?>
			</p>
		</div>

		<?php if ( ! empty( $on_offer ) ): ?>
			<span class="item-offer-badge"><?php ci_e_setting( 'room_offer_text' ); ?></span>
		<?php endif; ?>
	</a>
</div>
