jQuery(document ).ready(function($){
	"use strict";

	// Panel weather lookup.
	var woeid_lookup = $( ".ci-select2-weather-city-lookup" );
	woeid_lookup.select2( {
		width             : '100%',
		ajax              : {
			url           : "http://query.yahooapis.com/v1/public/yql",
			dataType      : 'json',
			delay         : 250,
			data          : function( params ) {
				return {
					q     : 'select * from geo.places(10) where text ="' + params.term + '"', // search term
					format: 'json',
					_nocache: Math.floor( ( new Date().getTime() ) / 1200 / 1000 )
				};
			},
			processResults: function( data, page ) {
				// parse the results into the format expected by Select2.
				// since we are using custom formatting functions we do not need to
				// alter the remote JSON data
				var $results = [];
				var remote_results;

				if( data.query.count != undefined ) {
					if( data.query.count == 1 ) {
						remote_results = data.query.results;
					} else if(data.query.count > 1) {
						remote_results = data.query.results.place;
					}
					$.each(remote_results, function(key, val){
						var $text = val.name;
						if( typeof val.admin1 == 'object' && val.admin1 !== null ) {
							$text = $text + ', ' + val.admin1.content;
						}
						if( typeof val.admin2 == 'object' && val.admin2 !== null ) {
							$text = $text + ', ' + val.admin2.content;
						}
						if( typeof val.admin3 == 'object' && val.admin3 !== null ) {
							$text = $text + ', ' + val.admin3.content;
						}
						$results.push( {
							id: val.woeid, text: $text
						} );
					});

				}

				return {
					results: $results
				};
			},
			cache         : true
		}, escapeMarkup   : function( markup ) {
			return markup;
		},
		minimumInputLength: 3,
	} );

	woeid_lookup.on( 'change', function( e ) {
		$('#weather_woeid').val($(this).val());
	} );


});
