<?php $slideshow = ci_theme_get_slides( false, get_queried_object_id() ); ?>

<?php if ( $slideshow->have_posts() ) : ?>
	<?php
		$attributes = sprintf( 'data-animation="%s" data-direction="%s" data-slideshow="%s" data-slideshowspeed="%s" data-animationspeed="%s"',
			esc_attr( ci_setting( 'slider_effect' ) ),
			esc_attr( ci_setting( 'slider_direction' ) ),
			esc_attr( ci_setting( 'slider_autoslide' ) == 'enabled' ? '1' : '0' ),
			esc_attr( (string) ci_setting( 'slider_speed' ) ),
			esc_attr( (string) ci_setting( 'slider_duration' ) )
		);
	?>
	<div class="home-slider ci-slider loading" <?php echo $attributes; ?>>
		<ul class="slides">
			<?php while ( $slideshow->have_posts() ) : $slideshow->the_post(); ?>
				<?php
					$url         = get_post_meta( get_the_ID(), 'link_url', true );
					$subtitle    = get_post_meta( get_the_ID(), 'subtitle', true );
					$button_text = get_post_meta( get_the_ID(), 'button_text', true );
					$url         = ! empty( $url ) ? $url : get_permalink();
					$img         = ci_get_featured_image_src( 'ci_full_page' );
				?>
				<li style="background-image: url('<?php echo esc_url( $img ); ?>');">

					<div class="slide-content">
						<?php if ( ! empty( $subtitle ) ) : ?>
							<p class="slide-subtitle"><?php echo esc_html( $subtitle ); ?></p>
						<?php endif; ?>
						<p class="slide-title"><?php the_title(); ?></p>

						<?php if ( ! empty( $button_text ) ) : ?>
							<a class="btn btn-white btn-lg" href="<?php echo esc_url( $url ); ?>"><?php echo esc_html( $button_text ); ?></a>
						<?php endif; ?>
					</div>
				</li>
			<?php endwhile; ?>
		</ul>
	</div> <!-- #slider -->

<?php else : ?>
	<?php get_template_part( 'part', 'hero' ); ?>
<?php endif; wp_reset_postdata(); ?>
