<?php get_header(); ?>

<main class="main">
	<div class="container">
		<div class="row">
			<?php while ( have_posts() ): the_post(); ?>
				<?php $set = ci_featgal_get_attachments(); ?>
				<?php if( $set->have_posts() ): ?>
					<div class="col-xs-12">
						<div class="room-slider ci-slider loading">
							<ul class="slides">
								<?php while( $set->have_posts() ): $set->the_post(); ?>
									<?php $details = wp_prepare_attachment_for_js( get_the_ID() ); ?>
									<li>
										<a href="<?php echo esc_url( ci_get_image_src( get_the_ID(), 'large' ) ); ?>" class="ci-lightbox" title="<?php echo esc_attr( $details['caption'] ); ?>">
											<img src="<?php echo esc_url( ci_get_image_src( get_the_ID(), 'ci_room_slider' ) ); ?>" alt="<?php echo esc_attr( $details['alt'] ); ?>" />
										</a>
									</li>
								<?php endwhile; wp_reset_postdata(); ?>
							</ul>

							<div class="room-slider-controls">
								<p class="image-caption"><span></span></p>
								<a class="room-control-prev" href="#"><i class="fa fa-angle-left"></i></a>
								<a class="room-control-next" href="#"><i class="fa fa-angle-right"></i></a>
							</div>
						</div>
					</div>
				<?php endif; ?>

				<div class="col-md-2 col-sm-6 col-xs-12">
					<div class="sidebar">
						<?php
							$amenities       = get_post_meta( get_the_ID(), 'amenities', true );
							$amenities_title = get_post_meta( get_the_ID(), 'amenities_title', true );
						?>
						<?php if ( ! empty( $amenities ) ): ?>
							<aside class="widget">
								<?php if ( ! empty( $amenities_title ) ): ?>
									<h3 class="widget-title"><?php echo $amenities_title; ?></h3>
								<?php endif; ?>
								<ul class="list-amenities">
									<?php foreach( $amenities as $amenity ): ?>
										<li><?php echo $amenity['title']; ?></li>
									<?php endforeach; ?>
								</ul>
							</aside>
						<?php endif; ?>

						<?php dynamic_sidebar( 'room-left' ); ?>
					</div>
				</div>

				<div class="col-md-3 col-md-push-7 col-sm-6 col-xs-12">
					<div class="sidebar">
						<?php dynamic_sidebar( 'room-right' ); ?>
					</div>
				</div>

				<div class="col-md-7 col-md-pull-3 col-sm-12 col-xs-12">
					<div class="entry-content">
						<?php the_content(); ?>
					</div>
				</div>
			<?php endwhile; ?>
		</div>
	</div>
</main>

<?php get_footer(); ?>
