<?php
/*
Template Name: Left Sidebar
*/
?>

<?php get_header(); ?>

<main class="main">
	<div class="container">
		<div class="row">
			<div class="col-md-8 col-md-push-4 col-sm-7 col-sm-push-5">
				<?php while ( have_posts() ): the_post(); ?>
					<article id="entry-<?php the_ID(); ?>" <?php post_class( 'entry' ); ?>>
						<?php if( has_post_thumbnail() ): ?>
							<figure class="entry-thumb">
								<a href="<?php echo ci_get_featured_image_src( 'large' ); ?>" class="ci-lightbox">
									<?php the_post_thumbnail(); ?>
								</a>
							</figure>
						<?php endif; ?>

						<div class="entry-content">
							<?php the_content(); ?>
							<?php wp_link_pages(); ?>
						</div>
					</article>

					<?php comments_template(); ?>
				<?php endwhile; ?>
			</div>

			<div class="col-md-4 col-md-pull-8 col-sm-5 col-sm-pull-7">
				<?php get_sidebar(); ?>
			</div>
		</div>
	</div>
</main>

<?php get_footer(); ?>