jQuery(document).ready(function($) {
	$( '#the-list #gallery-bank-plugin-disable-link' ).click(function(e) {
		e.preventDefault();

		var reason = $( '#gallery-bank-feedback-content .gallery-bank-reason' ),
			deactivateLink = $( this ).attr( 'href' );

	    $( "#gallery-bank-feedback-content" ).dialog({
	    	title: 'Quick Feedback Form',
	    	dialogClass: 'gallery-bank-feedback-form',
	      	resizable: false,
	      	minWidth: 430,
	      	minHeight: 300,
	      	modal: true,
	      	buttons: {      		
	      		'go' : {
		        	text: 'Continue',
        			icons: { primary: "dashicons dashicons-update" },        	
		        	id: 'gallery-bank-feedback-dialog-continue',
					class: 'button',
		        	click: function() {
		        		var dialog = $(this),
		        			go = $('#gallery-bank-feedback-dialog-continue'),
		          			form = dialog.find('form').serializeArray(),
							result = {};
						$.each( form, function() {
							if ( '' !== this.value )
						    	result[ this.name ] = this.value;										
						});
						if ( ! jQuery.isEmptyObject( result ) ) {
							result.action = 'post_user_feedback_gallery_bank';
						    $.ajax({
						        url: post_feedback.admin_ajax,
						        type: 'POST',
						        data: result,
						        error: function(){},
						        success: function(msg){},
						        beforeSend: function() { 
						        	go.addClass('gallery-bank-ajax-progress'); 
						        },
						        complete: function() { 
						        	go.removeClass('gallery-bank-ajax-progress'); 
						            dialog.dialog( "close" );
						            location.href = deactivateLink;						        	
						        }						        
						    });		
						}
		        	},				      			
	      		},
	      		'cancel' : {
		        	text: 'Cancel',
		        	id: 'gallery-bank-feedback-cancel',
		        	class: 'button button-primary',
		        	click: function() {
		          		$( this ).dialog( "close" );
		        	}				      			
	      		},
	      		'skip' : {
		        	text: 'Skip',
		        	id: 'gallery-bank-feedback-dialog-skip',
		        	click: function() {
		          		$( this ).dialog( "close" );
		          		location.href = deactivateLink;
		        	}				      			
	      		},		      		
	      	}
	    });
	});
});