<?php
/**
  file is used for translating strings.

 * @author   Tech Banker
 * @package  gallery-bank/includes
 * @version  4.0.0
 */
if (!defined("ABSPATH")) {
   exit;
} // Exit if accessed directly
if (!is_user_logged_in()) {
   return;
} else {
   $access_granted = false;
   foreach ($user_role_permission as $permission) {
      if (current_user_can($permission)) {
         $access_granted = true;
         break;
      }
   }
   if (!$access_granted) {
      return;
   } else {
      //Menus
      $gallery_bank = __("Gallery Bank", "gallery-bank");
      $gb_galleries = __("Galleries", "gallery-bank");
      $gb_add_gallery = __("Add Gallery", "gallery-bank");
      $gb_manage_galleries = __("Manage Galleries", "gallery-bank");
      $gb_sort_galleries = __("Sort Galleries", "gallery-bank");
      $gb_albums = __("Albums", "gallery-bank");
      $gb_add_album = __("Add Album", "gallery-bank");
      $gb_manage_albums = __("Manage Albums", "gallery-bank");
      $gb_sort_albums = __("Sort Albums", "gallery-bank");
      $gb_update_album = __("Edit Album", "gallery-bank");
      $gb_tags = __("Tags", "gallery-bank");
      $gb_add_tag = __("Add Tag", "gallery-bank");
      $gb_manage_tags = __("Manage Tags", "gallery-bank");
      $gb_update_tag = __("Edit Tag", "gallery-bank");
      $gb_layout_settings = __("Layout Settings", "gallery-bank");
      $gb_thumbnail_layout = __("Thumbnail Layout", "gallery-bank");
      $gb_masonry_layout = __("Masonry Layout", "gallery-bank");
      $gb_slideshow_layout = __("Slideshow Layout", "gallery-bank");
      $gb_image_browser_layout = __("Image Browser Layout", "gallery-bank");
      $gb_justified_grid_layout = __("Justified Grid Layout", "gallery-bank");
      $gb_blog_style_layout = __("Blog Style Layout", "gallery-bank");
      $gb_lightboxes = __("LightBoxes", "gallery-bank");
      $gb_fancy_box = __("Fancy Box", "gallery-bank");
      $gb_color_box = __("Color Box", "gallery-bank");
      $gb_foo_box_free_edition = __("Foo Box Free Edition", "gallery-bank");
      $gb_foo_box_premium = __("Foo Box Premium", "gallery-bank");
      $gb_nivo_lightbox = __("Nivo LightBox", "gallery-bank");
      $gb_lightcase = __("Lightcase", "gallery-bank");
      $gb_general_settings = __("General Settings", "gallery-bank");
      $gb_global_options = __("Global Options", "gallery-bank");
      $gb_page_navigation = __("Page Navigation", "gallery-bank");
      $gb_watermark_settings = __("Watermark Settings", "gallery-bank");
      $gb_advertisement = __("Advertisement", "gallery-bank");
      $gb_shortcode_generator = __("Shortcodes", "gallery-bank");
      $gb_other_setting = __("Other Settings", "gallery-bank");
      $gb_roles_and_capabilities = __("Roles and Capabilities", "gallery-bank");
      $gb_feature_requests = __("Ask For Help", "gallery-bank");
      $gb_system_information = __("System Information", "gallery-bank");
      $gb_licensing_page = __("Licensing", "gallery-bank");
      $gb_filters = __("Filters", "gallery-bank");
      $gb_filter_settings = __("Filters Settings", "gallery-bank");
      $gb_update_filter_settings = __("Filter Settings have been updated Successfully", "gallery-bank");
      $gb_update_searchbox_settings = __("Search box Settings have been updated Successfully", "gallery-bank");
      $gb_update_lazyload_settings = __("Lazy Load Settings have been updated Successfully", "gallery-bank");
      $gb_update_orderby_settings = __("Order By Settings have been updated Successfully", "gallery-bank");
      $gb_lazy_load_settings = __("Lazy Load Settings", "gallery-bank");
      $gb_search_box_settings = __("Search Box Settings", "gallery-bank");
      $gb_order_by_settings = __("Order By Settings", "gallery-bank");
      $gb_pricing_plans = __("Premium Editions", "gallery-bank");

      //Common
      $gb_tags = __("Tags", "gallery-bank");
      $gb_message_premium_edition = __("This feature is available only in Premium Editions! <br> Kindly Purchase to unlock it!", "gallery-bank");
      $gb_pro_label = __(" Pro ", "gallery-bank");
      $gb_premium_edition = __(" Premium Edition ", "gallery-bank");
      $gb_documentation = __("Full Features", "gallery-bank");
      $gb_read_and_check = __(" or check our ", "gallery-bank");
      $gb_demos_section = __("Online Demos", "gallery-bank");
      $gb_upgrade_need_help = __("Know about ", "gallery-bank");
      $gb_untitled = __("Untitled Gallery", "gallery-bank");
      $gb_enable = __("Enable", "gallery-bank");
      $gb_disable = __("Disable", "gallery-bank");
      $gb_save_changes = __("Save Changes", "gallery-bank");
      $gb_margin_title = __("Margin (px)", "gallery-bank");
      $gb_right = "Right";
      $gb_justify = "Justify";
      $gb_bottom = "Bottom";
      $gb_left = "Left";
      $gb_padding_title = __("Padding (px)", "gallery-bank");
      $gb_border_style_title = __("Border Style (Width,Thickness,Color)", "gallery-bank");
      $gb_width_placeholder = __("Width (px)", "gallery-bank");
      $gb_width_layout_placeholder = __("Please provide Width (px)", "gallery-bank");
      $gb_none = "None";
      $gb_alignment_title = __("Alignment", "gallery-bank");
      $gb_center = "Center";
      $gb_max_width_placeholder = __("Please provide Max Width (px)", "gallery-bank");
      $gb_max_height_placeholder = __("Please provide Max Height (px)", "gallery-bank");
      $gb_text = __("Text", "gallery-bank");
      $gb_image = __("Image", "gallery-bank");
      $gb_user_access_message = __("You do not have Sufficient Access to this Page. Kindly contact the Administrator for more Privileges", "gallery-bank");
      $gb_apply = __("Apply", "gallery-bank");
      $gb_delete_all_galleries = __("Delete All Galleries", "gallery-bank");
      $gb_purge_galleries = __("Purge Galleries", "gallery-bank");
      $gb_delete = __("Delete", "gallery-bank");
      $gb_bulk_action = __("Bulk Action", "gallery-bank");
      $gb_action = __("Action", "gallery-bank");
      $gb_height_placeholder = __("Please provide Height (px)", "gallery-bank");
      $gb_sort_images_title = __("Sort Images By", "gallery-bank");
      $gb_sort_images_tooltip = __("In this field, you would need to choose a specific sorting order according to which you would like to display Images", "gallery-bank");
      $gb_title = __("Title", "gallery-bank");
      $gb_date = __("Date", "gallery-bank");
      $gb_filename = __("Filename", "gallery-bank");
      $gb_type = __("Type", "gallery-bank");
      $gb_custom_order = __("Custom Order", "gallery-bank");
      $gb_random_order = __("Random Order", "gallery-bank");
      $gb_ascending = __("Ascending", "gallery-bank");
      $gb_descending = __("Descending", "gallery-bank");
      $gb_order_by_title = __("Order Images By", "gallery-bank");
      $gb_order_by_tooltip = __("In this field, you would need to choose a particular Order for Images. It could be ascending or descending", "gallery-bank");
      $gb_lightbox_type_title = __("LightBox Type", "gallery-bank");
      $gb_lightbox_type_tooltip = __("In this field, you would need to choose LightBox Type for Gallery", "gallery-bank");
      $gb_no_light_box = __("No LightBox", "gallery-bank");
      $gb_no_of_image_per_page_title = __("No. of Images Per Page", "gallery-bank");
      $gb_no_of_image_per_page_tooltip = __("In this field, you would need to provide number of Images which you  would like to display Per Page", "gallery-bank");
      $gb_no_of_image_per_page_placeholder = __("Please provide No. of Images Per Page", "gallery-bank");
      $gb_gallery_title_tooltip = __("In this field, you would need to choose Show to display Gallery Title", "gallery-bank");
      $gb_show = "Show";
      $gb_hide = "Hide";
      $gb_gallery_description_tooltip = __("In this field, you would need to choose Show to display Gallery Description", "gallery-bank");
      $gb_thumbnail_tooltip = __("In this field, you would need to choose Show to display Thumbnail Title", "gallery-bank");
      $gb_thumbnail_description_tooltip = __("In this field, you would need to choose Show to display Thumbnail Description", "gallery-bank");
      $gb_animation_effect_title = __("Animation Effects", "gallery-bank");
      $gb_animation_effect_tooltip = __("In this field, you would need to choose Animation Effects for Gallery", "gallery-bank");
      $gb_special_effect_title = __("Special Effects", "gallery-bank");
      $gb_special_effect_tooltip = __("In this field, you would need to choose Special Effects for Gallery", "gallery-bank");
      $gb_reset_shortcode = __("Reset", "gallery-bank");
      $gb_shortcode_title = __("Shortcode", "gallery-bank");
      $gb_general_title = __("Thumbnails", "gallery-bank");
      $gb_gallery_title = __("Gallery Title", "gallery-bank");
      $gb_gallery_description_title = __("Gallery Description", "gallery-bank");
      $gb_thumbnail_title = __("Thumbnail Title", "gallery-bank");
      $gb_thumbnail_description_title = __("Thumbnail Description", "gallery-bank");
      $gb_shortcode_tooltip = __("This field shows your generated Shortcode. Kindly paste it to your page/post where you would like to implement", "gallery-bank");
      $gb_thumbnail_width_title = __("Thumbnail Width (px)", "gallery-bank");
      $gb_thumbnail_width_tooltip = __("In this field, you would need to provide Width for Masonry Layout", "gallery-bank");
      $gb_autoplay_title = __("Auto Play", "gallery-bank");
      $gb_autoplay_tooltip = __("In this field, you would need to choose Yes to automatically play Carousel", "gallery-bank");
      $gb_yes = "Yes";
      $gb_no = "No";
      $gb_add = __("Add >>", "gallery-bank");
      $gb_edit_tooltip = __("Edit", "gallery-bank");
      $meta_information = __("Meta Information", "gallery-bank");
      $created_by = __("Created By", "gallery-bank");
      $created_on = __("Date Of Creation", "gallery-bank");
      $gb_status = __("Status", "gallery-bank");
      $gb_used = __("Used", "gallery-bank");
      $gb_unused = __("Unused", "gallery-bank");
      $gb_file_name = __("File Name", "gallery-bank");
      $gb_html_tag = __("HTML Tag", "gallery-bank");
      $gb_blur = "Blur";
      $gb_sepia = "Sepia";
      $gb_brightness = "Brightness";
      $gb_contrast = "Contrast";
      $gb_invert = "Invert";
      $gb_saturate = "Saturate";
      $gb_grayscale = "GrayScale";
      $gb_hue_rotate = "Hue Rotate";
      $gb_time_interval_title = __("Time Interval", "gallery-bank");
      $gb_time_interval_tooltip = __("In this field, you would need to provide Time Interval for Auto Play", "gallery-bank");
      $gb_time_interval_placeholder = __("Please provide Time Interval", "gallery-bank");
      $gb_no_of_columns_title = __("Maximum Columns", "gallery-bank");
      $gb_no_of_columns_tooltip = __("In this field, you would need to provide Maximum Columns", "gallery-bank");
      $gb_no_of_columns_placeholder = __("Please provide Maximum Columns", "gallery-bank");
      $gb_copy_to_clipboard = __("Copy Shortcode", "gallery-bank");
      $gb_custom_css = __("Custom CSS", "gallery-bank");
      $gb_custom_css_placeholder = __("Please provide Custom CSS", "gallery-bank");
      $gb_custom_css_tooltip = __("In this field, you would need to provide CSS code manually to add extra styling to the above mentioned fields", "gallery-bank");
      $gb_success = __("Success!", "gallery-bank");
      $gb_autoplay_slideshow = __("Autoplay Slideshow", "gallery-bank");
      $gb_shortcode_thumbnail_dimension_exceed_msg = __("Thumbnail Dimensions must be smaller than Image Dimensions respectively", "gallery-bank");
      $gb_choose_gallery = __("Please choose atleast one Gallery to Display ", "gallery-bank");
      $gb_choose_gallery_message = __("Please choose atleast one Gallery to generate shortcode!", "gallery-bank");
      $gb_choose_album_title = __("Choose Album", "gallery-bank");
      $gb_choose_type = __("Source Type", "gallery-bank");
      $gb_choose_gallery_title = __("Choose Gallery", "gallery-bank");
      $gb_album = __("Album", "gallery-bank");
      $gb_gallery = __("Gallery", "gallery-bank");
      $gb_choose_gallery_tooltip = __("In this field, you would need to choose a Gallery for which you would like to generate shortcode", "gallery-bank");
      $gb_choose_type_tooltip = __("In this field, you would need to choose Source Type for which you would like to generate shortcode", "gallery-bank");
      $gb_choose_album_tooltip = __("In this field, you would need to choose a Album for which you would like to generate shortcode", "gallery-bank");
      $gb_album_title_tooltip = __("In this field you would need to choose Show to display Album Title", "gallery-bank");
      $gb_album_description_tooltip = __("In this field you would need to choose Show to display Album Description", "gallery-bank");
      $gb_line_height = __("Line Height", "gallery-bank");
      $gb_line_height_tooltip = __("In this field you would need to provide line height", "gallery-bank");
      $gb_line_height_placeholder = __("Please provide Line Height", "gallery-bank");
      $gb_buttons = __("Buttons", "gallery-bank");
      $gb_button_text = __("Button Text", "gallery-bank");
      $gb_button_text_placeholder = __("Please provide Button name", "gallery-bank");
      $gb_button_text_tooltip = __("In this field you would need to provide text that will be displayed on Button", "gallery-bank");
      $gb_button_text_alignment = __(" Button Text Alignment", "gallery-bank");
      $gb_button_text_alignment_tooltip = __("In this field, you would need to choose Alignment for Button. It could be either Left, Center, Right or Justify", "gallery-bank");
      $gb_button_color = __("Button Color", "gallery-bank");
      $gb_button_color_tooltip = __("In this field you would need to provide Background color for Button", "gallery-bank");
      $gb_button_margin_tooltip = __("In this field, you would need to provide Margin for Button", "gallery-bank");
      $gb_button_padding_tooltip = __("In this field, you would need to provide Padding for Button", "gallery-bank");
      $gb_button_border_style_tooltip = __("In this field, you would need to provide Width,Thickness and Color for Button", "gallery-bank");
      $gb_button_font_family_tooltip = __("In this field, you would need to choose Font Family for Button", "gallery-bank");
      $gb_button_border_radius_tooltip = __("In this field, you would need to provide Border radius for Button", "gallery-bank");
      $gb_button_border_hover = __("Border Hover Color", "gallery-bank");
      $gb_button_hover_color = __("Button Hover Color", "gallery-bank");
      $gb_button_border_hover_tooltip = __("In this fied you would need to provide Border Hover color for Button", "gallery-bank");
      $gb_button_font_hover_color = __("Font Hover Color", "gallery-bank");
      $gb_button_font_hover_placeholder = __("Please provide Font Hover Color", "gallery-bank");
      $gb_button_font_hover_tooltip = __("In this fied you would need to provide Font Hover color for Button", "gallery-bank");
      $gb_album_button_color_placeholder = __("Please provide Button Background Color ", "gallery-bank");
      $gb_album_button_hover_color_placeholder = __("Please provide Button Hover Color ", "gallery-bank");
      $gb_layout_settings_alignment_tooltip = __("In this field, you would need to choose Alignment. It could be either Left, Center, Right or Justify", "gallery-bank");
      $gb_shortcode_for_grid_style_thumbnail_layout = __("Shortcode for Grid Style Layout ", "gallery-bank");
      $gb_shortcode_for_grid_style_masonry_layout = __("Shortcode for Masonry Style Layout", "gallery-bank");
      $gb_position_top_left = "Top Left";
      $gb_position_top_center = "Top Center";
      $gb_position_top_right = "Top Right";
      $gb_position_middle_left = "Middle Left";
      $gb_position_middle_center = "Middle Center";
      $gb_position_middle_right = "Middle Right";
      $gb_position_bottom_left = "Bottom Left";
      $gb_position_bottom_center = "Bottom Center";
      $gb_position_bottom_right = "Bottom Right";
      $gb_url_placeholder = __("Please add Image", "gallery-bank");
      $gb_url_add_image = __("Add Image", "gallery-bank");
      $gb_url_message = __("Your WordPress version does not support Wp Media. Kindly update to latest version of WordPress", "gallery-bank");
      $gb_background_color_transparency = __("Background Color & Transparency (%)", "gallery-bank");
      $gb_background_color_transparency_tooltips = __("In this field, you would need to choose Background Color & provide Transparency(%) for selected Background Color. Transparency should be between 1 to 100", "gallery-bank");
      $gb_shadow = __("Shadow  (H. Length, V. Length, Blur Radius, Spread Radius)", "gallery-bank");
      $gb_shadow_color = __("Shadow Color", "gallery-bank");
      $gb_shadow_color_placeholder = __("Please choose Shadow Color", "gallery-bank");
      $gb_shadow_color_tooltip = __("In this field, you would need to choose Shadow Color for Images", "gallery-bank");
      $gb_hover_effect_value_title = __("Hover Effect & Value", "gallery-bank");
      $gb_hover_effect_value_tooltip = __("In this field, you would need to choose Hover Effect and provide specific value for selected Hover Effect", "gallery-bank");
      $gb_rotate = "Rotate";
      $gb_scale = "Scale";
      $gb_skew = "Skew";
      $gb_transition_title = __("Transition (secs)", "gallery-bank");
      $gb_transition_tooltip = __("In this field, you would need to provide Transition time to complete Effects. It should be from 1 to 9", "gallery-bank");
      $gb_transition_time_placeholder = __("Please provide Transition Time (secs)", "gallery-bank");
      $gb_horizontal_length_placeholder = __("H. Length", "gallery-bank");
      $gb_vertical_length_placeholder = __("V. Length", "gallery-bank");
      $gb_blur_radius_placeholder = __("Blur Radius", "gallery-bank");
      $gb_spread_radius_placeholder = __("Spread Radius", "gallery-bank");
      $gb_thumbnail_dimensions_title = __("Thumbnail Dimensions (px)", "gallery-bank");
      $gb_thumbnail_layout_thumbnail_dimension_tooltip = __("In this field, you would need to provide Width & Height for Thumbnail Images which you would like to display", "gallery-bank");
      $gb_global_thumbnail_dimension_exceed_msg = __("Thumbnail Dimensions must be smaller or equal to the Global Options Thumbnail Dimensions", "gallery-bank");
      $gb_margin_thumbnail_title_tooltip = __("In this field, you would need to provide Margin for Thumbnail Title", "gallery-bank");
      $gb_margin_thumbnail_description_tooltip = __("In this field, you would need to provide Margin for Thumbnail Description", "gallery-bank");
      $gb_padding_thumbnail_title_tooltip = __("In this field, you would need to provide Padding for Thumbnail Title", "gallery-bank");
      $gb_padding_thumbnail_description_tooltip = __("In this field, you would need to provide Padding for Thumbnail Description", "gallery-bank");
      $gb_hover_effect_value_placeholder = __("Hover Value", "gallery-bank");
      $gb_buttons_hover_color_title = __("Buttons Hover Color", "gallery-bank");
      $gb_buttons_hover_color_tooltip = __("In this field, you would need to choose Hover Color for Buttons", "gallery-bank");
      $gb_buttons_hover_color_placeholder = __("Please choose Buttons Hover Color", "gallery-bank");
      $gb_buttons_border_style_title = __("Buttons Border Style (Width,Thickness,Color)", "gallery-bank");
      $gb_buttons_border_style_tooltip = __("In this field, you would need to provide Width,Thickness and Color for Buttons", "gallery-bank");
      $gb_buttons_transparency_placeholder = __("Please provide Buttons Background Transparency", "gallery-bank");
      $gb_buttons_font_style_title = __("Buttons Font Style", "gallery-bank");
      $gb_buttons_font_style_tooltip = __("In this field, you would need to provide Font Size and Color for Buttons", "gallery-bank");
      $gb_buttons_font_family_title = __("Buttons Font Family", "gallery-bank");
      $gb_buttons_font_family_tooltip = __("In this field, you would need to choose Font Family for Buttons", "gallery-bank");
      $gb_buttons_border_radius_layout_tooltip = __("In this field, you would need to provide Border Radius for Buttons", "gallery-bank");
      $gb_general_background_color_tooltip = __("In this field, you would need to choose Background Color", "gallery-bank");
      $gb_buttons_transparency_tooltip = __("In this field, you would need to provide Background Transparency for Buttons. It should be between 1 to 100", "gallery-bank");

      // Manage Galleries
      $gb_manage_galleries_delete_gallery = __("Delete Galleries", "gallery-bank");
      $gb_manage_galleries_duplicate_gallery = __("Duplicate Galleries", "gallery-bank");
      $gb_manage_galleries_cover_image = __("Gallery Cover Image", "gallery-bank");
      $gb_manage_galleries_overview = __("Gallery Overview", "gallery-bank");
      $gb_manage_galleries_details = __("Gallery Details", "gallery-bank");
      $gb_manage_galleries_total_images = __("Total Images", "gallery-bank");
      $gb_manage_galleries_edited_by = __("Last Edited By", "gallery-bank");
      $gb_manage_galleries_edited_on = __("Last Edited On", "gallery-bank");
      $gb_manage_galleries_no_gallery_found = __("No Gallery Found", "gallery-bank");
      $gb_selected_gallery_in_album_delete_data = __("Selected Galleries have been already used in Albums", "gallery-bank");

      //Add Gallery
      $gb_add_gallery_embed_video = __("Embed Video", "gallery-bank");
      $gb_add_gallery_video_title = __("Video Title", "gallery-bank");
      $gb_add_gallery_video_tooltip = __("In this field, you would need to provide Video Title", "gallery-bank");
      $gb_add_gallery_video_placeholder = __("Please provide Video Title", "gallery-bank");
      $gb_add_gallery_video_alt_text_title = __("Video Alt Text", "gallery-bank");
      $gb_add_gallery_video_alt_text_tooltip = __("In this field, you would need to provide alternative tags for Video to make it visible for search engines and show in case of slower connections", "gallery-bank");
      $gb_add_gallery_video_alt_text_placeholder = __("Please provide Alt Text for Video", "gallery-bank");
      $gb_add_gallery_video_description_title = __("Video Description", "gallery-bank");
      $gb_add_gallery_video_description_tooltip = __("In this field, you would need to provide Description for Video", "gallery-bank");
      $gb_add_gallery_video_description_placeholder = __("Please provide Video Description", "gallery-bank");
      $gb_add_gallery_title_tooltip = __("In this field, you would need to provide Gallery Title", "gallery-bank");
      $gb_add_gallery_title_placeholder = __("Please provide Gallery Title", "gallery-bank");
      $gb_add_gallery_description_placeholder = __("Please provide Gallery Description", "gallery-bank");
      $gb_add_gallery_description_tooltip = __("In this field, you would need to provide Gallery Description. It would be displayed when using shortcode", "gallery-bank");
      $gb_add_gallery_local_system = __("Upload  From Local System", "gallery-bank");
      $gb_add_gallery_wp_media_manager = __(" Upload  From  Media Manager", "gallery-bank");
      $gb_add_gallery_local_system_notification = __("Your browser does not have Flash, Silverlight or HTML5 Support. Kindly check and try again", "gallery-bank");
      $gb_add_gallery_wp_media_guide_title = __("To import your Media Gallery, click on the button given below", "gallery-bank");
      $gb_add_gallery_upload_thumbnail = __("Upload Thumbnails", "gallery-bank");
      $gb_add_gallery_wp_media_notification = __("Your WordPress Version does not support Wp Media. Kindly update to latest Version of WordPress", "gallery-bank");
      $gb_add_gallery_option_delete_images = __("Delete Images", "gallery-bank");
      $gb_add_gallery_option_copy_images = __("Copy Images", "gallery-bank");
      $gb_add_gallery_option_move_images = __("Move Images", "gallery-bank");
      $gb_add_gallery_option_rotate_clockwise_images = __("Rotate Clockwise", "gallery-bank");
      $gb_add_gallery_option_rotate_anti_clockwise_images = __("Rotate Anti-Clockwise", "gallery-bank");
      $gb_add_gallery_option_flip_images_vertically = __("Flip Images Vertically", "gallery-bank");
      $gb_add_gallery_option_flip_images_horizontally = __("Flip Images Horizontally", "gallery-bank");
      $gb_add_gallery_option_restore_image = __("Restore Images", "gallery-bank");
      $gb_add_gallery_restore_image_title = __("Restore Image", "gallery-bank");
      $gb_add_gallery_table_thumbnail = __("Thumbnail", "gallery-bank");
      $gb_add_gallery_table_file_details = __("File Details", "gallery-bank");
      $gb_add_gallery_cover_image_title = __("Set As Cover Image", "gallery-bank");
      $gb_add_gallery_exclude_title = __("Exclude?", "gallery-bank");
      $gb_add_gallery_edit_tooltip = __("If you would like to Edit this Gallery then you would need to click on Edit button which is located at the bottom of Gallery Cover Image", "gallery-bank");
      $gb_add_gallery_delete_tooltip = __("If you would like to Delete this Gallery then you would need to click on Delete button which is located at the bottom of Gallery Cover Image", "gallery-bank");
      $gb_add_gallery_image_title = __("Image Title", "gallery-bank");
      $gb_add_gallery_image_tooltip = __("In this field, you would need to provide Title for Image", "gallery-bank");
      $gb_add_gallery_image_placeholder = __("Please provide Image Title", "gallery-bank");
      $gb_add_gallery_image_alt_text_title = __("Image Alt Text", "gallery-bank");
      $gb_add_gallery_image_alt_text_tooltip = __("In this field, you would need to provide alternative tags for Image to make it visible for search engines and show in case of slower connections", "gallery-bank");
      $gb_add_gallery_image_alt_text_placeholder = __("Please provide Alt Text for Image", "gallery-bank");
      $gb_add_gallery_image_description_title = __("Image Description", "gallery-bank");
      $gb_add_gallery_image_description_tooltip = __("In this field, you would need to provide Description for Image. This would be displayed with Image", "gallery-bank");
      $gb_add_gallery_image_description_placeholder = __("Please provide Image Description", "gallery-bank");
      $gb_add_gallery_tag_tooltip = __("In this field, you would need to choose Tags for particular Image", "gallery-bank");
      $gb_add_gallery_enable_url_title = __("Enable Url Redirect on click of Image", "gallery-bank");
      $gb_add_gallery_enable_url_video_title = __("Enable Url Redirect on click of Video", "gallery-bank");
      $gb_add_gallery_enable_url_tooltip = __("If you would like to redirect user to a specific location when clicking on an Image then you would need to choose Enable from dropdown or vice-versa", "gallery-bank");
      $gb_add_gallery_url_link_title = __("Url Link", "gallery-bank");
      $gb_add_gallery_url_link_tooltip = __("This option becomes visible when Enable option is being selected from Enable Url Redirect on click of Image. Now you would need to provide the URL link of location where would you like to redirect user when clicking on this Image", "gallery-bank");
      $gb_add_gallery_url_link_placeholder = __("Enter URL link to Redirect", "gallery-bank");
      $gb_add_gallery_modal_title = __("Copy Selected Images to Destination Gallery", "gallery-bank");
      $gb_add_gallery_modal_destination_gallery_title = __("Destination Gallery", "gallery-bank");
      $gb_add_gallery_modal_destination_gallery_tooltip = __("In this field, you would need to choose Destination Gallery", "gallery-bank");
      $gb_add_gallery_modal_gallery_dropdown_value = __("Select Destination Gallery", "gallery-bank");
      $gb_add_gallery_modal_image_attribute_tooltip = __("In this field, you would need to choose an option which you would like to copy", "gallery-bank");
      $gb_add_gallery_modal_image_attribute_option_alt_text = __("Alt Text", "gallery-bank");
      $gb_add_gallery_modal_image_attribute_option_url_redirect = __("URL to Redirect", "gallery-bank");
      $gb_add_gallery_edit_close = __("Close Media Panel", "gallery-bank");
      $gb_add_gallery_previous_item = __("Edit Previous Media Item", "gallery-bank");
      $gb_add_gallery_next_item = __("Edit Next Media Item", "gallery-bank");
      $gb_add_gallery_attachement_detail = __("Attachment Details", "gallery-bank");
      $gb_add_gallery_file_type = __("File type", "gallery-bank");
      $gb_add_gallery_scale_image = __("SCALE IMAGE", "gallery-bank");
      $gb_add_gallery_original_dimensions = __("Original Dimension", "gallery-bank");
      $gb_add_gallery_image_crop = __("IMAGE CROP", "gallery-bank");
      $gb_add_gallery_aspect_ratio = __("Aspect ratio:", "gallery-bank");
      $gb_add_gallery_restore_message = __("Image restored Successfully", "gallery-bank");
      $gb_add_gallery_save_message = __("Image Saved", "gallery-bank");
      $gb_add_gallery_option_apply_watermark = __("Watermark", "gallery-bank");
      $gb_add_gallery_crop_image = __("Thumbnails croppped and saved Successfully", "gallery-bank");
      $gb_add_gallery_brightness_title = "Brightness";
      $gb_add_gallery_contrast_title = "Contrast";
      $gb_add_gallery_image_effect_grayscale = "Grayscale";
      $gb_add_gallery_image_effect_negative = "Negative";
      $gb_add_gallery_image_effect_removal = "Removal";
      $gb_add_gallery_image_effect_sepia = "Sepia";
      $gb_add_gallery_image_effect_slate = "Slate";
      $gb_add_gallery_image_effect_saturate = "Saturate";
      $gb_add_gallery_image_effect_crop = "Crop";
      $gb_add_gallery_help_toggle_scale = __("You can proportionally scale original Image. For best results, scaling should be done before you crop, flip, or rotate. Images can only be scaled down, not up", "gallery-bank");
      $gb_add_gallery_help_toggle_crop_title = __("Crop Aspect Ratio", "gallery-bank");
      $gb_add_gallery_help_toggle_crop_scale_description = __("The aspect ratio is the relationship between the width and height. You can preserve the aspect ratio by holding down the shift key while resizing your selection. Use the input box to specify the aspect ratio, e.g. 1:1 (square), 4:3, 16:9, etc", "gallery-bank");
      $gb_flip_images = __("Selected Images have been flipped Successfully", "gallery-bank");
      $gb_restore_images = __("Selected Images have been restored Successfully", "gallery-bank");
      $gb_save_gallery_data = __("Gallery has been saved Successfully", "gallery-bank");
      $gb_update_gallery_data = __("Gallery has been updated Successfully", "gallery-bank");
      $gb_validate_url = __("Please provide valid URL", "gallery-bank");
      $gb_rotate_images = __("Selected Images have been rotated Successfully", "gallery-bank");
      $gb_move_images = __("Selected Gallery Item has been moved Successfully", "gallery-bank");
      $gb_confirm_move = __("Are you sure you want to move these Images ?", "gallery-bank");
      $gb_confirm_copy = __("Are you sure you want to copy these Images ?", "gallery-bank");
      $gb_delete_data = __("Are you sure you want to delete ?", "gallery-bank");
      $gb_bulk_delete_data = __("Please choose an Action !", "gallery-bank");
      $gb_bulk_delete_data_message = __("Please choose at least 1 record to delete", "gallery-bank");
      $gb_select_image = __("Please choose at least one Image to display", "gallery-bank");
      $gb_modal_portlet_copy_title = __("Copy Selected Images to Destination Gallery", "gallery-bank");
      $gb_modal_portlet_move_title = __("Move Selected Images to Destination Gallery", "gallery-bank");
      $gb_modal_label_destination_tooltip = __("In this field, you would need to choose Destination Gallery to copy Selected Galleries", "gallery-bank");
      $gb_model_label_copy_title = __("Copy Image With", "gallery-bank");
      $gb_model_label_move_title = __("Move Image With", "gallery-bank");
      $gb_watermark_images = __("Watermark has been applied to selected Images Successfully", "gallery-bank");
      $gb_modal_label_copy_tooltip = __("In this field, you would need to choose an option which you would like to copy", "gallery-bank");
      $gb_modal_label_move_tooltip = __("In this field, you would need to choose an option which you would like to move", "gallery-bank");
      $gb_copy_images = __("Selected Gallery Items have been copied Successfully", "gallery-bank");
      $gb_edit_image_error = __("Invalid Height/Width given for Scaling", "gallery-bank");
      $gb_selected_galleries_deleted = __("Selected Galleries have been deleted Successfully", "gallery-bank");
      $gb_duplicate_data_message = __("Please choose at least 1 record to duplicate !", "gallery-bank");
      $gb_confirm_duplicate_data_message = __("Are you sure you want to duplicate these galleries ?", "gallery-bank");
      $gb_duplicate_galleries = __("Selected Galleries have been duplicated Successfully", "gallery-bank");
      $gb_confirm_delete_all_galleries = __("Are you sure you want to delete all Galleries ?", "gallery-bank");
      $gb_all_galleries_deleted = __("All Galleries have been deleted Successfully", "gallery-bank");
      $gb_confirm_purge_galleries = __("Are you sure you want to Purge Galleries ?", "gallery-bank");
      $gb_purge_galleries_data = __("Galleries have been Purged Successfully", "gallery-bank");
      $gb_gallery_delete_data = __("Gallery has been deleted Successfully", "gallery-bank");
      $gb_update_gallery = __("Edit Gallery", "gallery-bank");

      $gb_add_gallery_directory_path_placeholder = __("Enter the directory path to import images", "gallery-bank");
      $gb_add_gallery_import_images = __("Import Images", "gallery-bank");
      $gb_add_gallery_choose_folder = __("Please choose a Folder !", "gallery-bank");

      $gb_add_gallery_upload_videos = __("Upload Videos", "gallery-bank");
      $gb_add_gallery_videos_url = __("Video URL", "gallery-bank");
      $gb_add_gallery_videos_url_placeholder = __("Please provied Video Url", "gallery-bank");
      $gb_add_gallery_video_url_tooltip = __("In this field, you would need to provide Video Url for Uploading Video", "gallery-bank");
      $gb_enter_video_url = __("Please provide Video URL", "gallery-bank");
      $gb_enter_valid_video_url = __("Please provide a valid Video URL", "gallery-bank");
      $gb_video_uploaded = __("Video has been uploaded Successfully", "gallery-bank");

      //Sort Galleries
      $gb_sort_galleries_choose_gallery_tooltip = __("In this field, you would need to choose specific Gallery for Sorting", "gallery-bank");
      $gb_sort_galleries_choose_gallery_title = __("Please choose Gallery", "gallery-bank");
      $gb_sort_gallery_message = __("Please choose Gallery for Sorting", "gallery-bank");
      $gb_sort_galleries_data = __("Gallery has been sorted Successfully", "gallery-bank");

      //Manage Albums
      $gb_delete_all_albums = __("Delete All Albums", "gallery-bank");
      $gb_manage_delete_album = __("Delete Albums", "gallery-bank");
      $gb_manage_duplicate_album = __("Duplicate Albums", "gallery-bank");
      $gb_manage_album_details = __("Album Details", "gallery-bank");

      //Add Albums
      $gb_add_album_basic_detail = __("Album Title & Description", "gallery-bank");
      $gb_add_album_upload_local_media = __("Upload Albums", "gallery-bank");
      $gb_album_title = __("Album Title", "gallery-bank");
      $gb_choose_album_type = __("Album Type", "gallery-bank");
      $gb_choose_album_type_tooltip = __("In this field you would need to choose  Album Type for display", "gallery-bank");
      $gb_album_compact = __("Compact Album", "gallery-bank");
      $gb_album_extended = __("Extended Album", "gallery-bank");
      $gb_add_album_title_tooltip = __("In this field, you would need to provide Album Title", "gallery-bank");
      $gb_add_album_title_placeholder = __("Please provide Album Title", "gallery-bank");
      $gb_add_album_description_tooltip = __("In this field, you would need to provide Album Description. It would be displayed when using shortcode", "gallery-bank");
      $gb_manage_album_cover_image = __("Album Cover Image", "gallery-bank");
      $gb_manage_album_overview = __("Album Overview", "gallery-bank");
      $gb_choose_gallery_for_albums = __("Please choose gallery from the Galleries Available Dropdown!", "gallery-bank");
      $gb_galleries_available = __("Galleries Available", "gallery-bank");
      $gb_galleries_available_tooltip = __("Please select the Galleries From dropdown", "gallery-bank");
      $gb_add_gallery_button = __("Add", "gallery-bank");
      $gb_remove_gallery_button = __("Remove", "gallery-bank");
      $gb_galleries_included_in_this_album = __("Galleries Included in this Album", "gallery-bank");
      $gb_galleries_included_in_this_album_tooltip = __("In This Field, List of Included Galleries are available", "gallery-bank");
      $add_album_message = __("Your Album have been added Successfully", "gallery-bank");
      $gb_get_count_galleries = __("Total Galleries Added", "gallery-bank");

      // Add Tags
      $gb_delete_tag_exists = __("Selected Tags have been already used in Galleries", "gallery-bank");
      $gb_tag_name_title = __("Tag Name", "gallery-bank");
      $gb_tag_description_title = __("Tag Description", "gallery-bank");
      $gb_add_tag_name_tooltip = __("In this field, you would need to provide Tag Name", "gallery-bank");
      $gb_add_tag_name_placeholder = __("Please provide Tag Name", "gallery-bank");
      $gb_add_tag_description_tooltip = __("In this field, you would need to provide a brief Tag Description", "gallery-bank");
      $gb_add_tag_description_placeholder = __("Please provide Tag Description", "gallery-bank");

      //Animation Effects
      $gb_magic_effect = "Magic Effects";
      $gb_twister_in_down = "Twister In Down";
      $gb_twister_in_up = "Twister In Up";
      $gb_swap = "Swap";
      $gb_bling = "Bling";
      $gb_puff_in = "Puff In";
      $gb_vanish_in = "Vanish In";
      $gb_static_effect = "Static Effects";
      $gb_open_down_left = "Open Down Left";
      $gb_open_down_right = "Open Down Right";
      $gb_open_up_left = "Open Up Left";
      $gb_open_up_right = "Open Up Right";
      $gb_open_down_left_return = "Open Down Left Return";
      $gb_open_down_right_return = "Open Down Right Return";
      $gb_open_up_left_return = "Open Up Left Return";
      $gb_open_up_right_return = "Open Up Right Return";
      $gb_perspective = "Perspective";
      $gb_perspective_down_return = "Perspective Down Return";
      $gb_perspective_up_return = "Perspective Up Return";
      $gb_perspective_left_return = "Perspective Left Return";
      $gb_perspective_right_return = "Perspective Right Return";
      $gb_perspective_down = "Perspective Down";
      $gb_perspective_up = "Perspective Up";
      $gb_perspective_left = "Perspective Left";
      $gb_perspective_right = "Perspective Right";
      $gb_slide_down = "Slide Down";
      $gb_slide_up = "Slide Up";
      $gb_slide_left = "Slide Left";
      $gb_slide_right = "Slide Right";
      $gb_slide_down_return = "Slide Down Return";
      $gb_slide_up_return = "Slide Up Return";
      $gb_slide_left_return = "Slide Left Return";
      $gb_slide_right_return = "Slide Right Return";
      $gb_math = "Math";
      $gb_swash_in = "Swash In";
      $gb_foolish_in = "Foolish In";
      $gb_tin = "Tin";
      $gb_tin_right_in = "Tin Right In";
      $gb_tin_left_in = "Tin Left In";
      $gb_boing = "Boing";
      $gb_boing_in_up = "Boing In Up";
      $gb_on_the_space = "On the Space";
      $gb_space_in_up = "Space In Up";
      $gb_space_in_right = "Space In Right";
      $gb_space_in_down = "Space In Down";
      $gb_space_in_left = "Space In Left";
      $gb_attention_seekers = "Attention Seekers";
      $gb_bounce = "Bounce";
      $gb_flash = "Flash";
      $gb_pulse = "Pulse";
      $gb_rubber_band = "Rubber Band";
      $gb_shake = "Shake";
      $gb_swing = "Swing";
      $gb_tada = "Tada";
      $gb_wobble = "Wobble";
      $gb_jello = "Jello";
      $gb_bouncing_entrances = "Bouncing Entrances";
      $gb_bounce_in = "Bounce In";
      $gb_bounce_in_down = "Bounce In Down";
      $gb_bounce_in_left = "Bounce In Left";
      $gb_bounce_in_right = "Bounce In Right";
      $gb_bounce_in_up = "Bounce In Up";
      $gb_fading_entrances = "Fading Entrances";
      $gb_fade_in = "Fade In";
      $gb_fade_in_down = "Fade In Down";
      $gb_fade_in_left = "Fade In Left";
      $gb_fade_in_left_big = "Fade In Left Big";
      $gb_fade_in_right = "Fade In Right";
      $gb_fade_in_right_big = "Fade In Right Big";
      $gb_fade_in_up = "Fade In Up";
      $gb_flippers = "Flippers";
      $gb_flip_in_x = "Flip In X";
      $gb_flip_in_y = "Flip In Y";
      $gb_flip = "Flip";
      $gb_lightspeed = "Lightspeed";
      $gb_light_speed_in = "Light Speed In";
      $gb_rotating_entrances = "Rotating Entrances";
      $gb_rotate_in = "Rotate In";
      $gb_rotate_in_down_left = "Rotate In Down Left";
      $gb_rotate_in_down_right = "Rotate In Down Right";
      $gb_rotate_in_up_left = "Rotate In Up Left";
      $gb_rotate_in_up_right = "Rotate In Up Right";
      $gb_sliding_entrances = "Sliding Entrances";
      $gb_slide_in_up = "Slide In Up";
      $gb_slide_in_down = "Slide In Down";
      $gb_slide_in_left = "Slide In Left";
      $gb_slide_in_right = "Slide In Right";
      $gb_zoom_entrances = "Zoom Entrances";
      $gb_zoom_in = "Zoom In";
      $gb_zoom_in_down = "Zoom In Down";
      $gb_zoom_in_left = "Zoom In Left";
      $gb_zoom_in_right = "Zoom In Right";
      $gb_zoom_in_up = "Zoom In Up";
      $gb_specials = "Specials";
      $gb_roll_in = "Roll In";
      $gb_copied_successfully = "Copied Successfully";

      // Layouts
      $gb_margin_thumbnail_setting_tooltip = __("In this field, you would need to provide Margin for Thumbnail Layout", "gallery-bank");
      $gb_padding_thumbnail_setting_tooltip = __("In this field, you would need to provide Padding for Thumbnail Layout", "gallery-bank");
      $gb_thumbnail_layout_border_style_tooltip = __("In this field, you would need to provide Width,Thickness and Color for Thumbnail Layout", "gallery-bank");
      $gb_thumbnail_layout_border_radius_tooltip = __("In this field, you would need to provide Border Radius for Thumbnail Layout", "gallery-bank");
      $gb_thumbnail_layout_shadow_tooltip = __("In this field, you would need to provide CSS type values for Shadow of Thumbnail Layout", "gallery-bank");
      $gb_thumbnail_layout_opacity_title = __("Thumbnail Opacity (%)", "gallery-bank");
      $gb_thumbnail_layout_opacity_tooltip = __("In this field, you would need to provide Opacity for Thumbnail Layout. It should be between 1 to 100", "gallery-bank");
      $gb_thumbnail_layout_container_width = __("Container Width (%)", "gallery-bank");
      $gb_thumbnail_layout_container_width_tooltip = __("In this field, you would need to provide Width. It should be between 1 to 100", "gallery-bank");
      $gb_container_width_placeholder = __("Please Provide Container Width", "gallery-bank");
      $gb_thumbnail_layout_thumbnail_position = __("Thumbnail Position", "gallery-bank");
      $gb_thumbnail_layout_thumbnail_position_tooltip = __("In this field, you would need to choose Thumbnail Position for Thumbnail Layout.", "gallery-bank");

      $gb_masonry_layout_margin_tooltip = __("In this field, you would need to provide Margin for Masonry Layout", "gallery-bank");
      $gb_masonry_layout_padding_tooltip = __("In this field, you would need to Padding for Masonry layout", "gallery-bank");
      $gb_masonry_layout_border_style_tooltip = __("In this field, you would need to provide Width,Thickness and Color for Masonry layout", "gallery-bank");
      $gb_masonry_layout_border_radius_tooltip = __("In this field, you would need to provide Border Radius for Masonry layout", "gallery-bank");
      $gb_masonry_layout_shadow_tooltip = __("In this field, you would need to provide CSS type values for Shadow of Masonry layout", "gallery-bank");
      $gb_masonry_layout_opacity_tooltip = __("In this field, you would need to provide Opacity for Masonry Layout. It should be between 1 to 100", "gallery-bank");

      $gb_slideshow_layout_buttons_color_tooltip = __("In this field, you would need to choose Buttons Color for Slideshow Layout", "gallery-bank");
      $gb_buttons_color_placeholder = __("Please choose Buttons Color", "gallery-bank");
      $gb_slideshow_layout_border_style_tooltip = __("In this field, you would need to provide Width,Thickness and Color for Slidshow Layout", "gallery-bank");
      $gb_slideshow_layout_border_radius_tooltip = __("In this field, you would need to provide Border Radius for Slideshow Layout", "gallery-bank");
      $gb_slideshow_layout_shadow_tooltip = __("In this field, you would need to provide CSS type values for Shadow of Slideshow Layout", "gallery-bank");
      $gb_slideshow_layout_filmstrip_margin_title = __("Filmstrip Margin (px)", "gallery-bank");
      $gb_slideshow_layout_filmstrip_margin_tooltip = __("In this field, you would need to provide Margin for Filmstrip", "gallery-bank");
      $gb_slideshow_layout_filmstrip_padding_title = __("Filmstrip Padding (px)", "gallery-bank");
      $gb_slideshow_layout_filmstrip_padding_tooltip = __("In this field, you would need to provide Padding for Filmstrip", "gallery-bank");
      $gb_slideshow_layout_filmstrip_border_style_title = __("Filmstrip Border Style (Width,Thickness,Color)", "gallery-bank");
      $gb_slideshow_layout_filmstrip_border_style_tooltip = __("In this field, you would need to provide Width,Thickness and Color for Filmstrip", "gallery-bank");
      $gb_slideshow_layout_filmstrip_border_radius_title = __("Filmstrip Border Radius", "gallery-bank");
      $gb_slideshow_layout_filmstrip_border_radius_tooltip = __("In this field, you would need to provide Border Radius for Filmstrip", "gallery-bank");
      $gb_slideshow_layout_filmstrip_border_radius_placeholder = __("Please provide Filmstrip Border Radius", "gallery-bank");
      $gb_slideshow_layout_filmstrip_active_border_style_title = __("Filmstrip Active Border Style (Width,Thickness,Color)", "gallery-bank");
      $gb_slideshow_layout_filmstrip_deactive_transparency_title = __("Filmstrip De-active Transparency (%)", "gallery-bank");
      $gb_slideshow_layout_filmstrip_deactive_transparency_tooltip = __("In this field, you would need to provide Transparency for Deactivated Filmstrip. It should be between 1 to 100", "gallery-bank");
      $gb_slideshow_layout_filmstrip_deactive_transparency_placeholder = __("Please provide Filmstrip De-active Transparency", "gallery-bank");
      $gb_lightbox_colorbox_background_color_placeholder = __("Please choose Background Color", "gallery-bank");

      $gb_justified_grid_layout_padding_tooltip = __("In this field, you would need to provide Padding for Justified Grid Layout", "gallery-bank");
      $gb_justified_grid_layout_border_style_tooltip = __("In this field, you would need to provide Width,Thickness and Color for Justified Grid Layout", "gallery-bank");
      $gb_justified_grid_layout_border_radius_tooltip = __("In this field, you would need to provide Border Radius for Justified Grid Layout", "gallery-bank");
      $gb_justified_grid_layout_shadow_tooltip = __("In this field, you would need to provide CSS type values for Shadow of Justified Grid layout", "gallery-bank");
      $gb_justified_grid_layout_opacity_title = __("Justified Grid Opacity (%)", "gallery-bank");
      $gb_justified_grid_layout_opacity_tooltip = __("In this field, you would need to provide Opacity for Justified Grid Layout. It should be between 1 to 100", "gallery-bank");

      $gb_blog_style_layout_padding_tooltip = __("In this field, you would need to provide Padding for Blog Style Layout", "gallery-bank");
      $gb_blog_style_layout_border_style_tooltip = __("In this field, you would need to provide Width,Thickness and Color for Blog Style Layout", "gallery-bank");
      $gb_blog_style_layout_margin_tooltip = __("In this field, you would need to provide Margin for Blog Style Layout", "gallery-bank");
      $gb_blog_style_layout_border_radius_tooltip = __("In this field, you would need to provide Border Radius for Blog Style Layout", "gallery-bank");
      $gb_blog_style_layout_shadow_tooltip = __("In this field, you would need to provide CSS type values for Shadow of Blog Style Layout", "gallery-bank");
      $gb_blog_style_layout_opacity_title = __("Blog Style Opacity (%)", "gallery-bank");
      $gb_blog_style_layout_opacity_tooltip = __("In this field, you would need to provide Opacity for Blog Style Layout. It should be between 1 to 100", "gallery-bank");
      $gb_custom_css_message = __("Custom CSS have been updated successfully", "gallery-bank");

      $gb_buttons_color_title = __("Buttons Color", "gallery-bank");
      $gb_image_browser_layout_buttons_color_tooltip = __("In this field, you would need to choose Buttons Color for Image Browser Layout", "gallery-bank");
      $gb_image_browser_layout_border_style_tooltip = __("In this field, you would need to provide Width,Thickness and Color for Image Browser Layout", "gallery-bank");
      $gb_image_browser_layout_border_radius_tooltip = __("In this field, you would need to provide Border Radius for Image Browser Layout", "gallery-bank");
      $gb_image_browser_layout_shadow_tooltip = __("In this field, you would need to provide CSS type values for Shadow of Image Browser Layout", "gallery-bank");
      $gb_image_browser_layout_opacity_title = __("Image Browser Opacity (%)", "gallery-bank");
      $gb_image_browser_layout_opacity_tooltip = __("In this field, you would need to provide Opacity for Image Browser Layout. It should be between 1 to 100", "gallery-bank");
      $gb_image_browser_layout_button_margin = __("In this field, you would need to provide Margin for button" . "gallery-bank");
      $gb_image_browser_layout_button_padding = __("In this field, you would need to provide padding for button" . "gallery-bank");
      $gb_image_browser_layout_background_color = __("Background Color", "gallery-bank");
      $gb_image_browser_layout_background_color_tooltip = __("In this field, you would need to choose Background Color for Image Browser Layout", "gallery-bank");
      $gb_background_color_placeholder = __("Please choose Background Color", "gallery-bank");

      $gb_compact_album_layout = __("Compact Album Layout", "gallery-bank");
      $gb_extended_album_layout = __("Extended Album Layout", "gallery-bank");
      $gb_album_cover = __("Album Cover", "gallery-bank");
      $gb_album_description = __("Album Description", "gallery-bank");

      //LightBoxes
      $gb_lightcase_overlay_opacity = __("Overlay Opacity (%)", "gallery-bank");
      $gb_lightcase_overlay_opacity_tooltip = __("In this field, you would need to provide Opacity for Overlay. It should be between 1 to 100", "gallery-bank");
      $gb_lightcase_overlay_opacity_placeholder = __("Please provide Opacity for Overlay", "gallery-bank");
      $gb_lightcase_image_transition = __("Transition", "gallery-bank");
      $gb_lightcase_image_transition_tooltip = __("In this field, you would need to choose Transition Effect for LightBox", "gallery-bank");
      $gb_transition_fade = "Fade";
      $gb_transition_fadeinline = "Fade Inline";
      $gb_transition_scrolltop = "Scroll Top";
      $gb_transition_elastic = "Elastic";
      $gb_transition_scrollright = "Scroll Right";
      $gb_transition_scrollbottom = "Scroll Bottom";
      $gb_transition_scrollleft = "Scroll Left";
      $gb_transition_scrollhorizontal = "Scroll Horizontal";
      $gb_transition_scrollvertical = "Scroll Vertical";
      $gb_lightcase_animation_speed_starting_transition = __("Starting Transition Speed (milliseconds)", "gallery-bank");
      $gb_lightcase_animation_speed_starting_transition_tooltip = __("In this field, you would need to provide Starting Transition Speed for LightBox", "gallery-bank");
      $gb_lightcase_animation_speed_starting_transition_placeholder = __("Please provide Starting Transition Speed", "gallery-bank");
      $gb_lightcase_animation_speed_ending_transition = __("Ending Transition Speed (milliseconds)", "gallery-bank");
      $gb_lightcase_animation_speed_ending_transition_tooltip = __("In this field, you would need to provide Ending Transition Speed for LightBox", "gallery-bank");
      $gb_lightcase_animation_speed_ending_transition_placeholder = __("Please provide Ending Transition Speed", "gallery-bank");
      $gb_button_style = __("Button Style", "gallery-bank");
      $gb_button_style_title_tooltip = __("In this field, you would need to provide Title Font Size and Color for Button", "gallery-bank");
      $gb_button_size_placeholder = __("Please provide Button Font Size", "gallery-bank");
      $gb_button_color_placeholder = __("Please choose Button Font Color", "gallery-bank");
      $gb_close_button = __("Close Button", "gallery-bank");
      $gb_close_button_tooltip = __("In this field, you would need to choose Show to display Close Button", "gallery-bank");
      $gb_image_counter = __("Image Counter", "gallery-bank");
      $gb_iimage_counter_tooltip = __("In this field, you would need to choose Show to display Image Counter in Lightcase", "gallery-bank");
      $gb_counter_font_style = __("Counter Font Style", "gallery-bank");
      $gb_counter_font_style_title_tooltip = __("In this field, you would need to provide Title Font Size and Color for Counter", "gallery-bank");
      $gb_counter_font_size_placeholder = __("Please provide Counter Font Size", "gallery-bank");
      $gb_counter_color_placeholder = __("Please choose Counter Font Color", "gallery-bank");
      $gb_counter_font_family_title = __("Counter Font Family", "gallery-bank");
      $gb_counter_font_family_title_tooltip = __("In this field, you would need to choose Font Family", "gallery-bank");
      $gb_update_lightcase_lightbox_data = __("Lightcase LightBox settings have been saved Successfully", "gallery-bank");

      $gb_fancy_box_margin_tooltip = __("In this field, you would need to provide Margin for Fancy Box", "gallery-bank");
      $gb_fancy_box_margin_placeholder = __("Please provide Margin", "gallery-bank");
      $gb_fancy_box_padding_tooltip = __("In this field, you would need to Padding for Fancy Box", "gallery-bank");
      $gb_fancy_box_padding_placeholder = __("Please provide Padding", "gallery-bank");
      $gb_fancy_box_open_effect_title = "Open Effect";
      $gb_fancy_box_open_effect_tooltip = __("In this field, you would need to choose an Opening Effect for Fancy Box", "gallery-bank");
      $gb_fancy_box_close_effect_title = "Close Effect";
      $gb_fancy_box_close_effect_tooltip = __("In this field, you would need to choose a Closing Effect for Fancy Box", "gallery-bank");
      $gb_fancy_box_open_speed_title = __("Open Speed (milliseconds)", "gallery-bank");
      $gb_fancy_box_open_speed_tooltip = __("In this field, you would need to provide Speed of Opening for Fancy Box", "gallery-bank");
      $gb_fancy_box_open_speed_placeholder = __("Please provide Open Speed (milliseconds)", "gallery-bank");
      $gb_fancy_box_close_speed_title = __("Close Speed (milliseconds)", "gallery-bank");
      $gb_fancy_box_close_speed_tooltip = __("In this field, you would need to provide Speed of Closing for Fancy Box", "gallery-bank");
      $gb_fancy_box_close_speed_placeholder = __("Please provide Close Speed (milliseconds)", "gallery-bank");
      $gb_fancy_box_cyclic_title = __("Repeat Images", "gallery-bank");
      $gb_fancy_box_cyclic_tooltip = __("If you would like to Repeat Images in LightBox then you would need to choose Enable from dropdown or vice-versa", "gallery-bank");
      $gb_fancy_box_arrows_title = __("Navigation Arrows", "gallery-bank");
      $gb_fancy_box_arrows_tooltip = __("In this field, you would need to choose Show to display Navigation Arrows", "gallery-bank");
      $gb_fancy_box_mouse_wheel_title = __("Mouse Wheel", "gallery-bank");
      $gb_fancy_box_mouse_wheel_tooltip = __("If you would like that Fancy Box will respond to Mouse Wheel events then you would need to choose Enable from dropdown or vice-versa", "gallery-bank");
      $gb_fancy_box_button_position_title = __("Button Position", "gallery-bank");
      $gb_fancy_box_button_position_tooltip = __("In this field, you would need to choose Button Position for Fancy Box. It could be either Top or Bottom", "gallery-bank");
      $gb_fancy_box_enable_escapebutton_tooltip = __("In this field, you would need to choose Enable to close Images with Esc Button on Keyboard", "gallery-bank");
      $gb_fancy_box_title_position_title = __("Title Position", "gallery-bank");
      $gb_fancy_box_title_position_tooltip = __("In this field, you would need to choose Title Position for Fancy Box. It could be Inside, Outside or Over", "gallery-bank");
      $gb_fancy_box_show_close_button_tooltip = __("In this field, you would need to choose Show to display Close Button", "gallery-bank");
      $gb_fancy_box_change_speed_title = __("Speed (milliseconds)", "gallery-bank");
      $gb_fancy_box_change_speed_tooltip = __("In this field, you would need to provide Speed for slideshow in Fancy Box", "gallery-bank");
      $gb_fancy_box_change_speed_placeholder = __("Please provide Slideshow Speed (milliseconds)", "gallery-bank");
      $gb_fancy_box_outside = "Outside";
      $gb_fancy_box_inside = "Inside";
      $gb_fancy_box_over = "Over";
      $gb_fancy_box_top = "Top";
      $gb_fancy_box_bottom = "Bottom";
      $gb_update_fancy_box_settings = __("Fancy Box Settings have been updated Successfully", "gallery-bank");

      $gb_escape_button = "Escape Button";
      $gb_opacity_title = __("Background Opacity", "gallery-bank");
      $gb_lightbox_overlay_opacity_title = __("Overlay Opacity", "gallery-bank");
      $gb_fade = "Fade";
      $gb_slide = "Slide";
      $gb_elastic = "Elastic";
      $gb_lightbox_title_font_style = __("Title Font Style", "gallery-bank");
      $gb_lightbox_title_font_family = __("Title Font Family", "gallery-bank");
      $gb_lightbox_title_font_family_tooltip = __("In this field, you would need to choose Font Family for Title", "gallery-bank");
      $gb_lightbox_description_font_style = __("Description Font Style", "gallery-bank");
      $gb_lightbox_description_font_style_tooltip = __("In this field, you would need to provide Font Size and Color for Description", "gallery-bank");
      $gb_lightbox_description_font_family = __("Description Font Family", "gallery-bank");
      $gb_lightbox_description_font_family_tooltip = __("In this field, you would need to choose Font Family for Description", "gallery-bank");
      $gb_general_background_color_tooltip = __("In this field, you would need to choose Background Color", "gallery-bank");
      $gb_lightbox_overlay_opacity_tooltip = __("In this field, you would need to provide Opacity for Overlay. It should be between 1 to 100", "gallery-bank");
      $gb_lightbox_overlay_opacity_placeholder = __("Please provide Overlay Opacity", "gallery-bank");

      $gb_lightbox_colorbox_type_title = __("Color Box Type", "gallery-bank");
      $gb_lightbox_colorbox_type_tooltip = __("In this field, you would need to choose Color Box Type from dropdown or vice-versa", "gallery-bank");
      $gb_lightbox_colorbox_type1 = "Color Box Type 1";
      $gb_lightbox_colorbox_type2 = "Color Box Type 2";
      $gb_lightbox_colorbox_type3 = "Color Box Type 3";
      $gb_lightbox_colorbox_type4 = "Color Box Type 4";
      $gb_lightbox_colorbox_type5 = "Color Box Type 5";
      $gb_lightbox_colorbox_effect_title = __("Color Box Transition Effect", "gallery-bank");
      $gb_lightbox_colorbox_effect_tooltip = __("In this field, you would need to choose Transition Effect for Color Box. It should be either Elastic or Fade", "gallery-bank");
      $gb_lightbox_colorbox_effect_speed_title = __("Transition Speed (milliseconds)", "gallery-bank");
      $gb_lightbox_colorbox_effect_speed_tooltip = __("In this field, you would need to provide Transition Speed for Color Box", "gallery-bank");
      $gb_lightbox_colorbox_effect_speed_placeholder = __("Please provide Transition Speed (milliseconds)", "gallery-bank");
      $gb_lightbox_colorbox_fadeout_title = __("Fade Out (milliseconds)", "gallery-bank");
      $gb_lightbox_colorbox_fadeout_tooltip = __("In this field, you would need to provide speed at which Images in Color Box would be Fade Out", "gallery-bank");
      $gb_lightbox_colorbox_fadeout_placeholder = __("Please provide Fade Out Interval (milliseconds)", "gallery-bank");
      $gb_lightbox_colorbox_opacity_tooltip = __("In this field, you would need to provide Background Opacity for Color Box. It should be between 1 to 100", "gallery-bank");
      $gb_lightbox_colorbox_open_title = __("Open When Page Load", "gallery-bank");
      $gb_lightbox_colorbox_open_tooltip = __("In this field, you would need to choose Enable to display Color Box at Page Loading", "gallery-bank");
      $gb_lightbox_colorbox_close_button_title = __("Show Close Button", "gallery-bank");
      $gb_lightbox_colorbox_close_button_tooltip = __("In this field, you would need to choose Enable to display Close Button", "gallery-bank");
      $gb_lightbox_colorbox_slideshow_title = __("Slideshow", "gallery-bank");
      $gb_lightbox_colorbox_slideshow_tooltip = __("If you would like to display Slideshow in Color Box then you would need to choose Enable or vice-versa", "gallery-bank");
      $gb_lightbox_colorbox_slideshow_speed_title = __("Slideshow Speed (milliseconds)", "gallery-bank");
      $gb_lightbox_colorbox_slideshow_speed_tooltip = __("In this field, you would need to provide Slideshow Speed for Color Box", "gallery-bank");
      $gb_lightbox_colorbox_slideshow_speed_placeholder = __("Please provide Slideshow Speed", "gallery-bank");
      $gb_lightbox_colorbox_slideshow_auto_title = __("Auto Slideshow", "gallery-bank");
      $gb_lightbox_colorbox_slideshow_auto_tooltip = __("In this field, you would need to choose Enable to autoplay Slideshow", "gallery-bank");
      $gb_lightbox_colorbox_slideshow_positioning_title = __("Positioning", "gallery-bank");
      $gb_lightbox_colorbox_slideshow_positioning_tooltip = __("In this field, you would need to choose Position for Color Box", "gallery-bank");
      $gb_lightbox_colorbox_slideshow_reposition = "Reposition";
      $gb_lightbox_colorbox_slideshow_fixed_position_title = "Fixed Position";
      $gb_lightbox_colorbox_slideshow_fixed_position_tooltip = __("If you do not like to change Position for LightBox while scrolling up or down then you would need to choose Enable from dropdown or vice-versa", "gallery-bank");
      $gb_lightbox_colorbox_slideshow_positioning_value_title = __("Positioning Value", "gallery-bank");
      $gb_lightbox_colorbox_slideshow_positioning_value_tooltip = __("In this field, you would need to provide Positioning Value for Color Box", "gallery-bank");
      $gb_lightbox_colorbox_slideshow_positioning_value_placeholder = __("Please provide Positioning Value", "gallery-bank");
      $gb_lightbox_colorbox_background_color_tooltip = __("In this field, you would need to choose Background Color", "gallery-bank");
      $gb_update_color_box_data = __("Color Box settings have been saved Successfully", "gallery-bank");

      $gb_nivo_lightbox_effect_title = __("Choose Open Effects : ", "gallery-bank");
      $gb_nivo_lightbox_fadescale = "FadeScale";
      $gb_nivo_lightbox_slideLeft = "SlideLeft";
      $gb_nivo_lightbox_slideRight = "SlideRight";
      $gb_nivo_lightbox_slideUp = "SlideUp";
      $gb_nivo_lightbox_slideDown = "SlideDown";
      $gb_nivo_lightbox_fall = "Fall";
      $gb_nivo_lightbox_keyboard_navigation_title = __("Keyboard Navigation", "gallery-bank");
      $gb_nivo_lightbox_click_image_to_close_title = __("Click Image To Close", "gallery-bank");
      $gb_nivo_lightbox_click_overlay_to_close_title = __("Click Overlay To Close", "gallery-bank");
      $gb_nivo_lightbox_effect_tooltip = __("In this field, you would need to choose Nivo Open Effect from dropdown which is to be applied on LightBox", "gallery-bank");
      $gb_nivo_lightbox_keyboard_navigation_tooltip = __("If you would like to Navigate Images from Keyboard arrow keys then you would need to choose Enable from dropdown or vice-versa", "gallery-bank");
      $gb_nivo_lightbox_click_image_to_close_tooltip = __("If you would like to close LightBox by clicking on Image then you would need to choose Enable from dropdown or vice-versa", "gallery-bank");
      $gb_nivo_lightbox_click_overlay_to_close_tooltip = __("If you would like to close LightBox by clicking on Overlay then you would need to choose Enable from dropdown or vice-versa", "gallery-bank");
      $gb_update_nivo_lightbox_data = __("Nivo LightBox settings have been saved Successfully", "gallery-bank");

      $gb_foo_box_free_edition_show_count_tooltip = __("In this field, you would need to choose Enable to display count of Images in LightBox", "gallery-bank");
      $gb_foo_box_caption_show_on_hover_tooltip = __("If you would like to show Title on hover of Images then you would need to choose Enable from dropdown or vice-versa", "gallery-bank");
      $gb_foo_box_close_overlay_click_tooltip = __("If you would like to close LightBox by clicking on Overlay then you would need to choose Enable from dropdown or vice-versa", "gallery-bank");
      $gb_foo_box_hide_page_scrollbars_tooltip = __("In this field, you would need to choose Enable to Hide Page Scrollbars", "gallery-bank");
      $gb_foo_box_free_edition_show_count_title = __("Show Count", "gallery-bank");
      $gb_foo_box_hide_page_scrollbars_title = __("Hide Page Scrollbars", "gallery-bank");
      $gb_foo_box_caption_show_on_hover_title = __("Title Show On Hover", "gallery-bank");
      $gb_foo_box_close_overlay_click_title = __("Close Overlay Click", "gallery-bank");
      $gb_update_foo_box_data = __("Foo Box free Edition Settings have been updated Successfully");

      $gb_lightbox_overlay_color_title = __("Overlay Color", "gallery-bank");
      $gb_lightbox_overlay_color_tooltip = __("In this field, you would need to choose Color for Overlay", "gallery-bank");
      $gb_lightbox_overlay_color_placeholder = __("Please choose Overlay Color", "gallery-bank");
      $gb_slideshow_interval = __("Slideshow Interval (secs)", "gallery-bank");
      $gb_slideshow_interval_tooltip = __("In this field, you would need to provide Time Interval to complete Slideshow", "gallery-bank");
      $gb_slideshow_interval_placeholder = __("Please provide Slideshow Interval Time (secs)", "gallery-bank");
      $gb_text_alignment_title = __("Text Alignment", "gallery-bank");
      $gb_text_alignment_tooltip = __("In this field, you would need to choose Alignment for Text. It could be either Left, Center, Right or Justify", "gallery-bank");
      $gb_h1_tag = "H1 Tag";
      $gb_h2_tag = "H2 Tag";
      $gb_h3_tag = "H3 Tag";
      $gb_h4_tag = "H4 Tag";
      $gb_h5_tag = "H5 Tag";
      $gb_h6_tag = "H6 Tag";
      $gb_blockquote_tag = "Blockquote Tag";
      $gb_paragraph_tag = "Paragraph Tag";
      $gb_span_tag = "Span Tag";
      $gb_description = __("Description", "gallery-bank");
      $gb_description_tooltip = __("In this field, you would need to provide Description for LightBox", "gallery-bank");
      $gb_border_style_tooltip = __("In this field, you would need to provide Width,Thickness and Color for LightBox", "gallery-bank");
      $gb_border_radius_tooltip = __("In this field, you would need to provide Border Radius for LightBox", "gallery-bank");
      $gb_title_tooltip = __("If you would like to display Title on LightBox then you would need to choose Show from dropdown or vice-versa", "gallery-bank");
      $gb_html_tag_tooltip = __("In this field, you would need to choose HTML Tag for Text", "gallery-bank");
      $gb_margin_gallery_title_tooltip = __("In this field, you would need to provide Margin for Gallery Title", "gallery-bank");
      $gb_padding_gallery_title_tooltip = __("In this field, you would need to provide Padding for Gallery Title", "gallery-bank");
      $gb_margin_gallery_description_tooltip = __("In this field, you would need to provide Margin for Gallery Description", "gallery-bank");
      $gb_padding_gallery_description_tooltip = __("In this field, you would need to provide Padding for Gallery Description", "gallery-bank");
      $gb_autoplay_slideshow_tooltip = __("In this field, you would need to choose Enable to display Autoplay Slideshow", "gallery-bank");


      //General Settings
      $gb_update_global_options_data = __("Global Options have been updated Successfully", "gallery-bank");
      $gb_global_options_generated_image_dimension_title = __("Image Dimensions (px)", "gallery-bank");
      $gb_global_options_generated_image_dimension_tooltip = __("In this field, you would need to provide Width and Height for Image", "gallery-bank");
      $gb_global_option_thumbnail_dimension_title = __("Thumbnail Dimensions (px)", "gallery-bank");
      $gb_global_option_thumbnail_dimension_tooltip = __("In this field, you would need to provide Width and Height for Thumbnail", "gallery-bank");
      $gb_global_option_language_direction_title = __("Language Direction", "gallery-bank");
      $gb_global_option_language_direction_tooltip = __("In this field, you would need to choose Language Direction from dropdown. It could be either Right To Left or Left To Right", "gallery-bank");
      $gb_global_option_language_direction_right_to_left = "Right To Left";
      $gb_global_option_language_direction_left_to_right = "Left To Right";
      $gb_global_option_lazy_load_title = __("Lazy Load", "gallery-bank");
      $gb_global_option_lazy_load_tooltip = __("If you would like to show Lazy Loading for Images then you would need to choose Enable from dropdown or vice-versa", "gallery-bank");
      $gb_global_option_right_click_protection_title = __("Right Click Protection", "gallery-bank");
      $gb_global_option_right_click_protection_tooltip = __("In this field, you would need to choose whether to enable right-click protection for Images or not", "gallery-bank");
      $gb_global_option_search_box_tooltip = __("In this field, you would need to choose whether to display a search box for Image search in galleries or not", "gallery-bank");
      $gb_global_option_search_box_font_style_tooltip = __("In this field, you would need to provide Font Size and Color for Search Box", "gallery-bank");
      $gb_global_option_search_box_font_family_tooltip = __("In this field, you would need to choose Font Family for Search Box from dropdown", "gallery-bank");
      $gb_global_option_order_by_tooltip = __("In this field, you would need to choose whether to allow users to change ordering option of displayed Images or not", "gallery-bank");
      $gb_global_option_order_by_font_style_tooltip = __("In this field, you would need to provide Font Size and Color for Order By", "gallery-bank");
      $gb_global_option_order_by_font_family_tooltip = __("In this field, you would need to choose Font Family for Order By from dropdown", "gallery-bank");
      $gb_global_option_filter_font_style_tooltips = __("In this field, you would need to provide Font Size and Color for Filters", "gallery-bank");
      $gb_global_option_filter_font_family_tooltip = __("In this field, you would need to choose Font Family for Filters from dropdown", "gallery-bank");
      $gb_global_background_color_tooltip = __("In this field, you would need to choose Background Color for Loader", "gallery-bank");
      $gb_loader_color = __("Loader Color", "gallery-bank");
      $gb_global_loader_color_tooltip = __("In this field, you would need to choose Color for Loader", "gallery-bank");
      $gb_global_loader_text_tooltip = __("If you would like to display Loader Text in your galleries and albums then you would need to choose Show from dropdown or vice-versa", "gallery-bank");
      $gb_global_loader_title_tooltip = __("In this field, you would need to provide Title for Loader which you would like to display on your galleries and albums", "gallery-bank");
      $gb_global_option_font_style_tooltip = __("In this field, you would need to provide Font Size and Color for Loader which you would like to display on your galleries and albums", "gallery-bank");
      $gb_global_option_font_family_tooltip = __("In this field, you would need to choose Font Family for Loader from dropdown", "gallery-bank");
      $gb_global_option_filter_background_color = __("Background Color & Transparency", "gallery-bank");
      $gb_global_option_filter_background_color_tooltips = __("In this field you would need to choose background color  and Transparency for  Filters. Transparency should be between 1 to 100 ", "gallery-bank");
      $gb_global_option_filter_border_style_tooltip = __("In this field, you would need to provide Width,Thickness and Color for Filter ", "gallery-bank");
      $gb_global_option_filter_border_radius_tooltip = __("In this field, you would need to provide Border Radius for Filter", "gallery-bank");
      $gb_global_option_background_hover_color = __("Background Hover Color", "gallery-bank");
      $gb_global_option_filter_background_hover_color_tooltip = __("In this field you would need to choose background hover color", "gallery-bank");
      $gb_global_option_filter_background_hover_color_placeholder = __("Please Choose Background Hover Color", "gallery-bank");
      $gb_global_option_filter_border_hover_color_tooltip = __("In this field you would need to choose Border Hover color for filter", "gallery-bank");
      $gb_global_option_filter_border_hover_color_placeholder = __("Please Choose Border Hover Color", "gallery-bank");
      $gb_global_option_active_font_color = __("Active Font Color", "gallery-bank");
      $gb_global_option_active_font_color_tooltips = __("In this field you would need to choose Active font color", "gallery-bank");
      $gb_global_option_active_font_color_placeholder = __("Please Choose Active Font Color", "gallery-bank");
      $gb_global_option_active_font_hover_color_tooltip = __("In this field you would need to choose font hover color", "gallery-bank");
      $gb_global_option_active_font_hover_color_placeholder = __("Please Choose Font Hover Color", "gallery-bank");
      $gb_global_option_search_box_placeholder_text = __("Placeholder Text", "gallery-bank");
      $gb_global_option_search_box_placeholder = __("Please provide placeholder text", "gallery-bank");
      $gb_global_option_search_box_placeholder_text_tooltip = __("In this field you would need to Provide Placeholder text", "gallery-bank");
      $global_option_search_box = __("Search Box", "gallery-bank");
      $global_option_order_by = __("Order By", "gallery-bank");
      $gb_global_option_search_border_style_tooltip = __("In this field, you would need to provide Width,Thickness and Color for Search Box ", "gallery-bank");
      $gb_global_option_search_border_radius_tooltip = __("In this field, you would need to provide Border Radius for Search Box ", "gallery-bank");
      $gb_global_option_search_box_background_color_tooltips = __("In this field you would need to choose background color  and Transparency for Search Box. Transparency should be between 1 to 100 ", "gallery-bank");
      $gb_global_option_order_by_background_color_tooltips = __("In this field you would need to choose background color  and Transparency. Transparency should be between 1 to 100  ", "gallery-bank");
      $gb_global_option_order_by_border_hover_color_tooltip = __("In this field you would need to choose Border Hover color for Order By", "gallery-bank");
      $gb_global_option_order_by_border_style_tooltip = __("In this field, you would need to provide Width,Thickness and Color for Order By", "gallery-bank");
      $gb_global_option_order_by_border_radius_tooltip = __("In this field, you would need to provide Border Radius for Order By", "gallery-bank");
      $gb_search_box_margin_tooltip = __("In this field, you would need to provide Margin for Search Box", "gallery-bank");
      $gb_search_box_padding_tooltip = __("In this field, you would need to provide Padding for Search Box", "gallery-bank");
      $gb_order_by_margin_tooltip = __("In this field, you would need to provide Margin for Order By", "gallery-bank");
      $gb_order_by_padding_tooltip = __("In this field, you would need to provide Padding for Order By", "gallery-bank");
      $gb_global_option_background_color = __("Please Provide the Background Color", "gallery-bank");
      $gb_global_option_background_color_transparency = __("Please Provide the Background Color Transparency", "gallery-bank");

      $gb_filters_tooltip = __("If you would like to show Filters in your galleries and albums then you would need to choose Enable from dropdown or vice-versa", "gallery-bank");
      $gb_filters_margin_tooltip = __("In this field, you would need to provide Margin for Filters", "gallery-bank");
      $gb_filters_padding_tooltip = __("In this field, you would need to provide Padding for Filters", "gallery-bank");

      $gb_watermark_settings_type_title = __("Watermark Type", "gallery-bank");
      $gb_watermark_settings_type_tooltip = __("In this field, you would need to choose what type of Watermark would you like to use in your galleries and albums. It could be Text or Image. If you would not like to use watermark then choose None", "gallery-bank");
      $gb_watermark_settings_text_title = __("Watermark Text", "gallery-bank");
      $gb_watermark_settings_text_tooltip = __("In this field, you would need to provide Text for Watermark which will be displayed over gallery and album Images", "gallery-bank");
      $gb_watermark_settings_text_placeholder = __("Please provide Watermark Text", "gallery-bank");
      $gb_watermark_settings_watermark_url_title = __("Watermark URL", "gallery-bank");
      $gb_watermark_settings_url_tooltip = __("In this field, you would need to provide URL of that particular Image. If you would like to add Image from Media Library, then you would need to click on Add Image button and choose Image from Media Library", "gallery-bank");
      $gb_watermark_settings_size_title = __("Watermark Size (%)", "gallery-bank");
      $gb_watermark_settings_size_tooltip = __("In this field, you would need to provide appropriate Size (in percentage for the responsive look) for Watermark Image", "gallery-bank");
      $gb_watermark_settings_size_placeholder = __("Please provide Watermark Size", "gallery-bank");
      $gb_watermark_settings_position_title = __("Watermark Position", "gallery-bank");
      $gb_watermark_settings_position_tooltip = __("In this field, you would need to choose Position for Watermark from dropdown", "gallery-bank");
      $gb_watermark_settings_offset_title = "Offset";
      $gb_watermark_settings_offset_tooltip = __("In this field, you would need to provide values for Offset X and Y for Watermark", "gallery-bank");
      $gb_watermark_settings_rotate_title = __("Text Angle", "gallery-bank");
      $gb_watermark_settings_rotate_tooltip = __("In this field, you would need to provide an Angle at which Watermark Text is to be rotated", "gallery-bank");
      $gb_watermark_settings_opacity_title = __("Watermark Opacity", "gallery-bank");
      $gb_watermark_settings_opacity_tooltip = __("In this field, you would need to provide Opacity for Watermark. It should be between 1 to 100", "gallery-bank");
      $gb_watermark_settings_offset_x_placeholder = "Offset X";
      $gb_watermark_settings_offset_y_placeholder = "Offset Y";
      $gb_watermark_setting_text_angle_placeholder = __("Please provide Text Angle", "gallery-bank");

      $gb_advertisement_title = __("Advertisement Type", "gallery-bank");
      $gb_advertisement_tooltip = __("In this field, you would need to choose what type of Advertisement would you like to use in your galleries and albums. It could be Text or Image. If you would not like to use Advertisement then choose None", "gallery-bank");
      $gb_advertisement_text_title = __("Advertisement Text", "gallery-bank");
      $gb_advertisement_text_tooltip = __("In this field, you would need to provide Text for Advertisment which will be displayed over gallery and album Images", "gallery-bank");
      $gb_advertisement_text_placeholder = __("Please provide Advertisement Text", "gallery-bank");
      $gb_advertisement_url_title = __("Advertisement URL", "gallery-bank");
      $gb_advertisement_url_tooltip = __("In this field, you would need to provide URL of that particular Image. If you would like to add Image from Media Library, then you would need to click on Add Image button and choose Image from Media Library", "gallery-bank");
      $gb_advertisement_width_title = __("Advertisment Image Width (px)", "gallery-bank");
      $gb_advertisement_width_tooltip = __("In this field, you would need to provide Width for Advertisment Image", "gallery-bank");
      $gb_advertisement_width_placeholder = __("Please provide Width for Advertisment Image", "gallery-bank");
      $gb_advertisement_height_title = __("Advertisment Height (px)", "gallery-bank");
      $gb_advertisement_height_tooltip = __("In this field, you would need to provide Height for Advertisement Image", "gallery-bank");
      $gb_advertisement_hieght_placeholder = __("Please provide Height for Advertisement Image", "gallery-bank");
      $gb_advertisement_position_title = __("Advertisement Position", "gallery-bank");
      $gb_advertisement_position_tooltip = __("In this field, you would need to choose Position for Advertisement from dropdown", "gallery-bank");
      $gb_advertisement_link_title = __("Advertisement Link", "gallery-bank");
      $gb_advertisement_link_tooltip = __("In this field, you would need to provide link for Advertisement which will be open when user clicks on Advertisement text", "gallery-bank");
      $gb_advertisemnt_link_placeholder = __("Please provide Advertisement Link", "gallery-bank");
      $gb_advertisemnt_link_opacity_title = __("Advertisment Opacity (%)", "gallery-bank");
      $gb_advertisemnt_link_opacity_tooltip = __("In this field, you would need to provide Opacity for Advertisement. It should be between 1 to 100", "gallery-bank");
      $gb_advertisemnt_link_font_family_tooltip = __("In this field, you would need to choose Font Family for Advertisement Text from dropdown", "gallery-bank");

      $gb_both = __("Both Top & Bottom", "gallery-bank");
      $gb_page_navigation_galleries_title = __("Page Navigation For Galleries", "gallery-bank");
      $gb_page_navigation_margin_tooltip = __("In this field, you would need to provide Margin for Page Navigation", "gallery-bank");
      $gb_page_navigation_padding_tooltip = __("In this field, you would need to provide Padding for Page Navigation", "gallery-bank");
      $gb_page_navigation_border_style_tooltip = __("In this field, you would need to provide Width,Thickness and Color for Page Navigation", "gallery-bank");
      $gb_page_navigation_border_radius_tooltip = __("In this field, you would need to provide Border Radius for Page Navigation", "gallery-bank");
      $gb_page_navigation_alignment_tooltip = __("In this field, you would need to choose Alignment for Page Navigation. It could be either Left, Center, Right or Justify", "gallery-bank");
      $gb_page_navigation_position_title = __("Position", "gallery-bank");
      $gb_page_navigation_position_tootltip = __("In this field, you would need to choose Position for Page Navigation", "gallery-bank");
      $gb_page_navigation_numbering_title = __("Numbering", "gallery-bank");
      $gb_page_navigation_numbering_tooltip = __("If you would like to show Numbering on Page Navigation then you would need to choose Yes from dropdown or vice-versa", "gallery-bank");
      $gb_page_navigation_font_style_tooltip = __("In this field, you would need to provide Font Size and Color for Page Navigation", "gallery-bank");
      $gb_page_navigation_font_family_tooltip = __("In this field, you would need to choose Font Family for Page Navigation", "gallery-bank");
      $gb_page_navigation_background_color_tooltip = __("In this field, you would need to choose Background Color for Page Navigation", "gallery-bank");
      $gb_update_page_navigation = __("Page Navigation Settings have been updated Successfully", "gallery-bank");

      //Shortcode
      $gb_slideshow_layout_shortcode_slideshow_width = __("Slideshow Width (px)", "gallery-bank");
      $gb_slideshow_layout_shortcode_slideshow_tooltip = __("In this field, you would need to provide Width for Slideshow Images", "gallery-bank");
      $gb_slideshow_layout_control_button_title = __("Control Buttons", "gallery-bank");
      $gb_slideshow_layout_control_button_tooltip = __("If you would like to display Control Buttons then you would need to choose Show from dropdown or vice-versa", "gallery-bank");
      $gb_slideshow_layout_slideshow_flimstrips_title = __("Slideshow Filmstrip", "gallery-bank");
      $gb_slideshow_layout_slideshow_flimstrips_tooltip = __("If you would like to display Slideshow Filmstrip then you would need to choose Show from dropdown or vice-versa", "gallery-bank");
      $gb_shortcode_slideshow_width_exceed_msg = __("Slideshow Width must be less than or equal to Global Image Width", "gallery-bank");
      $gb_shortcode_image_dimensions_exceed_msg = __("Image Browser Dimensions must be less than or equal to Global Image Width", "gallery-bank");
      $gb_shortcode_blog_width_exceed_msg = __("Blog Image Width must be less than or equal to Global Image Width", "gallery-bank");

      $gb_image_browser_layout_image_browser_title = __("Image Browser Dimensions (Max Width & Height)", "gallery-bank");
      $gb_image_browser_layout_image_browser_tooltip = __("In this field, you would need to provide Maximum Width & Height for Browser Images", "gallery-bank");
      $gb_page_navigation_button_text_tooltip = __("In this field, you would need to choose Button Text. It could be Text or Arrow", "gallery-bank");
      $gb_page_navigation_arrow = __("Arrow", "gallery-bank");

      $gb_justified_grid_shortcode_row_height = __("Row Height (px)", "gallery-bank");
      $gb_justified_grid_shortcode_row_height_tooltip = __("In this field, you would need to provide Height of Rows for Justified Grid Layout", "gallery-bank");
      $gb_justified_grid_shortcode_row_height_placeholder = __("Please provide Row Height (px)", "gallery-bank");

      $gb_blog_style_layout_blog_width_title = __("Blog Image Max Width (px)", "gallery-bank");
      $gb_blog_style_layout_blog_width_tooltip = __("In this field, you would need to provide Maximum Width for Blog Images", "gallery-bank");

      //other settings
      $gb_other_setting_remove_table_at_uninstall_title = __("Remove Table at Uninstall", "gallery-bank");
      $gb_other_setting_remove_table_at_uninstall_tooltip = __("If you would like to remove tables during uninstalling the Plugin then you would need to choose Enable or vice-versa from dropdown", "gallery-bank");
      $gb_update_other_settings_data = __("Other Settings have been saved Successfully", "gallery-bank");

      // Shortcode
      $gb_gallery_template = __("Gallery Template", "gallery-bank");
      $gb_grid_style_layout = __("Grid Style Layout", "gallery-bank");
      $gb_masonry_style_layout = __("Masonry Style Layout", "gallery-bank");

      // Sort Albums
      $gb_sort_albums_choose_album_title = __("Please choose Album", "gallery-bank");

      // Search Box Settings
      $gb_font_style = __("Font Style", "gallery-bank");
      $gb_font_style_tooltip = __("In this field, you would need to provide Font Size and Color", "gallery-bank");
      $gb_font_style_title_tooltip = __("In this field, you would need to provide Font Size and Color for Title", "gallery-bank");
      $gb_font_style_description_tooltip = __("In this field, you would need to provide Font Size and Color for Description", "gallery-bank");
      $gb_font_family_title = __("Font Family", "gallery-bank");
      $gb_font_family_title_tooltip = __("In this field, you would need to choose Font Family for Title", "gallery-bank");
      $gb_font_family_description_tooltip = __("In this field, you would need to choose Font Family for Description", "gallery-bank");
      $gb_background_color = __("Background Color", "gallery-bank");
      $gb_background_transparency = __("Background Transparency", "gallery-bank");
      $gb_background_transparency_placeholder = __("Please provide Background Transparency", "gallery-bank");
      $gb_buttons_transparency_title = __("Buttons Background Transparency", "gallery-bank");
      $gb_settings = __("Settings", "gallery-bank");
      $gb_border_radius_title = __("Border Radius (px)", "gallery-bank");
      $gb_border_radius_placeholder = __("Please provide Border Radius (px)", "gallery-bank");
      $gb_buttons_border_radius_title = __("Buttons Border Radius (px)", "gallery-bank");
      $gb_none = "None";
      $gb_solid = "Solid";
      $gb_dashed = "Dashed";
      $gb_dotted = "Dotted";
      $gb_color_placeholder = __("Please choose Color", "gallery-bank");
      $gb_top = "Top";
      $gb_font_size_placeholder = __("Please provide Font Size", "gallery-bank");
      $gb_background_transparency_tooltip = __("In this field, you would need to provide Background Transparency. It should be between 1 to 100", "gallery-bank");

      //Roles and Capabilities
      $gb_roles_capabilities_show_menu = __("Show Gallery Bank Menu", "gallery-bank");
      $gb_roles_capabilities_show_menu_tooltip = __("In this field, you would need to choose a specific Role who can see Sidebar Menu", "gallery-bank");
      $gb_roles_capabilities_administrator = __("Administrator", "gallery-bank");
      $gb_roles_capabilities_author = __("Author", "gallery-bank");
      $gb_roles_capabilities_editor = __("Editor", "gallery-bank");
      $gb_roles_capabilities_contributor = __("Contributor", "gallery-bank");
      $gb_roles_capabilities_subscriber = __("Subscriber", "gallery-bank");
      $gb_roles_capabilities_others = __("Others", "gallery-bank");
      $gb_roles_capabilities_topbar_menu = __("Show Gallery Bank Top Bar Menu", "gallery-bank");
      $gb_roles_capabilities_topbar_menu_tooltip = __("If you would like to show Gallery Bank Top Bar Menu then you would need to choose Enable from dropdown or vice-versa", "gallery-bank");
      $gb_roles_capabilities_administrator_role = __("An Administrator Role can do the following", "gallery-bank");
      $gb_roles_capabilities_administrator_role_tooltip = __("Administrators will have by default full control to manage different options in Gallery Bank, so all checkboxes will be already selected for the Administrator Role as mentioned below", "gallery-bank");
      $gb_roles_capabilities_full_control = __("Full Control", "gallery-bank");
      $gb_roles_capabilities_author_role = __("An Author Role can do the following", "gallery-bank");
      $gb_roles_capabilities_author_role_tooltip = __("You can choose what pages could be accessed by users having an Author Role and you can also choose additional capabilities that could be accessed by users on your Gallery Bank for security purpose which is mentioned below in Author Role checkboxes", "gallery-bank");
      $gb_roles_capabilities_editor_role = __("An Editor Role can do the following", "gallery-bank");
      $gb_roles_capabilities_editor_role_tooltip = __("You can choose what pages could be accessed by the users having an Editor Role and you can also choose additional capabilities that could be accessed by users on your Gallery Bank for security purpose which is mentioned below in Editor Role checkboxes", "gallery-bank");
      $gb_roles_capabilities_contributor_role = __("A Contributor Role can do the following", "gallery-bank");
      $gb_roles_capabilities_contributor_role_tooltip = __("You can choose what pages could be accessed by the users having a Contributor Role and you can also choose additional capabilities that could be accessed by users on your Gallery Bank for security purpose which is mentioned below in Contributor Role checkboxes", "gallery-bank");
      $gb_roles_capabilities_subscriber_role = __("A Subscriber Role can do the following", "gallery-bank");
      $gb_roles_capabilities_subscriber_role_tooltip = __("You can choose what pages could be accessed by the users having a Subscriber Role and you can also choose additional capabilities that could be accessed by users on your Gallery Bank for security purpose which is mentioned below in Subscriber Role checkboxes", "gallery-bank");
      $gb_roles_capabilities_other_role = __("Other Roles can do the following", "gallery-bank");
      $gb_roles_capabilities_other_role_tooltip = __("You can choose what pages could be accessed by the users having an Others Role and you can also choose additional capabilities that could be accessed by users on your Gallery Bank for security purpose which is mentioned below in Others Role checkboxes", "gallery-bank");
      $gb_roles_capabilities_other_roles_capabilities = __("Please tick appropriate capabilities for security purposes", "gallery-bank");
      $gb_roles_capabilities_other_roles_capabilities_tooltip = __("In this field, only users with these capabilities can access of Gallery Bank", "gallery-bank");

      // Thumbnail layout shortcode
      $gb_sort_albums_title = __("Sort Albums By", "gallery-bank");
      $gb_sort_albums_tooltip = __("In this field, you would need to choose a specific sorting order according to which you would like to display Albums", "gallery-bank");
      $gb_order_albums_by_title = __("Order Albums By", "gallery-bank");
      $gb_order_albums_by_tooltip = __("In this field, you would need to choose a particular Order for Albums. It could be ascending or descending", "gallery-bank");

      //Albums
      $gb_update_compact_album_layout = __("Compact Album Layout Settings have been updated Successfully", "gallery-bank");
      $gb_update_extended_album_layout = __("Extended Album Layout Settings have been updated Successfully", "gallery-bank");
      $gb_button_hover_color_tooltip = __("In this field you would need to choose Hover Color for Button", "gallery-bank");
      $gb_button_border_hover_placeholder = __("Please provide Border Hover Color", "gallery-bank");
      $gb_sort_albums_choose_album_tooltip = __("In this field, you would need to choose specific Album for Sorting", "gallery-bank");
      $gb_opacity_placeholder = __("Please provide Opacity", "gallery-bank");
   }
}