/**!
 * FooBox - A jQuery plugin for responsive lightboxes
 * @version 2.1.8
 * @link http://fooplugins.com/plugins/foobox-jquery
 * @copyright Steven Usher & Brad Vincent 2014
 * @license Released under the MIT license.
 * You are free to use FooBox jQuery in personal projects as long as this copyright header is left intact.
 */
!function (a, b, c, undefined) {
   if (a && b) {
      b.FooBox = {
         defaults: {
            affiliate: {
               enabled: !0,
               prefix: "Powered by ",
               url: "http://fooplugins.com/plugins/foobox/"
            },
            alwaysInit: !1,
            closeOnOverlayClick: !0,
            containerCssClass: "fbx-instance",
            countMessage: "item %index of %total",
            error: "Could not load the item",
            excludes: ".fbx-link, .nofoobox",
            externalSelector: "a[data-foobox],input[data-foobox]",
            fitToScreen: !1,
            hideScrollbars: !0,
            loadDelay: 0,
            loaderTimeout: 600,
            modalClass: "",
            preload: !1,
            rel: null,
            resizeSpeed: 300,
            selector: "a",
            showButtons: !0,
            showCount: !0,
            style: "fbx-rounded",
            theme: "fbx-light",
            transitionInSpeed: 200,
            transitionOutSpeed: 200,
            initCallback: null,
            loop: !0
         },
         version: "2.0.10",
         instances: [],
         ready: function (b) {
            (Function("/*@cc_on return true@*/")() ? "complete" === document.readyState : "loading" !== document.readyState) ? b(a) : setTimeout(function () {
               FooBox.ready(b)
            }, 1)
         }
      }, FooBox.$ = a, FooBox.format = function (a, b, c) {
         var d, e, f = arguments[0];
         for (d = 0; d < arguments.length - 1; d++)
            e = new RegExp("\\{" + d + "\\}", "gm"), f = f.replace(e, arguments[d + 1]);
         return f
      }, FooBox.browser = {
         isIE: !1,
         isChrome: !1,
         isSafari: !1,
         isLtSafari10: !1,
         version: 0,
         css: "",
         iOS: !1,
         Mac: !1,
         isMobile: function (a) {
            return /(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(a) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4))
         }(navigator.userAgent || navigator.vendor || b.opera),
         check: function () {
            var a = navigator.appVersion.toLowerCase(),
                    c = navigator.userAgent.toLowerCase(),
                    d = navigator.platform;
            FooBox.browser.iOS = /(iPad|iPhone|iPod)/g.test(d), 1 == FooBox.browser.iOS && (FooBox.browser.css += " fbx-ios"), FooBox.browser.Mac = /(Mac)/g.test(d), 1 == FooBox.browser.Mac && (FooBox.browser.css += " fbx-mac"), FooBox.browser.isChrome = a.indexOf("chrome") > -1 || a.indexOf("crios") > -1, FooBox.browser.isChrome && (FooBox.browser.css += " fbx-chrome"), FooBox.browser.isSafari = a.indexOf("safari") > -1 && !FooBox.browser.isChrome, FooBox.browser.isSafari && (FooBox.browser.css += " fbx-safari", FooBox.browser.isLtSafari10 = /constructor/i.test(b.HTMLElement)), FooBox.browser.isFirefox = c.indexOf("firefox") > -1, FooBox.browser.isFirefox && (FooBox.browser.css += " fbx-firefox");
            var e = c.indexOf("msie "),
                    f = c.indexOf("trident/"),
                    g = c.indexOf("edge/");
            if (FooBox.browser.isIE = e > -1 || f > -1 || g > -1, FooBox.browser.isIE) {
               if (e > -1)
                  FooBox.browser.version = parseInt(c.substring(e + 5, c.indexOf(".", e)), 10);
               else if (f > -1) {
                  var h = c.indexOf("rv:");
                  FooBox.browser.version = parseInt(c.substring(h + 3, c.indexOf(".", h)), 10)
               } else
                  g > -1 && (FooBox.browser.version = parseInt(c.substring(g + 5, c.indexOf(".", g)), 10));
               FooBox.browser.css = FooBox.format("fbx-ie fbx-ie{0}", FooBox.browser.version)
            }
         },
         supportsTransitions: function () {
            var a, b = document.body || document.documentElement,
                    c = b.style,
                    d = "transition";
            if ("string" == typeof c[d])
               return !0;
            a = ["Moz", "Webkit", "Khtml", "O", "ms"], d = d.charAt(0).toUpperCase() + d.substr(1);
            for (var e = 0; e < a.length; e++)
               if ("string" == typeof c[a[e] + d])
                  return !0;
            return !1
         },
         transitionEnd: function () {
            var a, b = document.createElement("fakeelement"),
                    c = {
                       transition: "transitionend",
                       OTransition: "oTransitionEnd",
                       MozTransition: "transitionend",
                       WebkitTransition: "webkitTransitionEnd"
                    };
            for (a in c)
               if (c.hasOwnProperty(a) && b.style[a] !== undefined)
                  return c[a];
            return null
         }
      }, FooBox.browser.check(), FooBox.qualifiedURL = function (a) {
         var b = document.createElement("a");
         return b.href = a, b.href
      }, c || (c = {}), c.log = c.log || function () {}, c.warn = c.warn || function () {}, c.error = c.error || function () {}, c.info = c.info || function () {};
      var d = {
         write: function () {
            c.log(FooBox.format.apply(d, arguments))
         },
         error: function () {
            1 === arguments.length && arguments[0] instanceof Error ? c.error(arguments[0]) : c.error(FooBox.format.apply(d, arguments))
         }
      };
      jQuery.Event.prototype.fb = {
         instance: null,
         modal: null,
         options: null
      }, FooBox.raise = function (b, c, d) {
         d = d || {};
         var e = a.Event(c);
         return e.fb = {}, e.fb.instance = b, e.fb.modal = b.modal.element, e.fb.options = b.options, a.extend(!0, e.fb, d), b.element.one(c, function (a) {
            a.stopPropagation()
         }).trigger(e), e
      }, FooBox.isjQuery = function (a) {
         return a instanceof jQuery ? !0 : a && a.jquery
      }, FooBox.options = {
         isMultipart: function (a, b) {
            return "string" == typeof a && a.length > 0 && -1 !== a.indexOf(b)
         },
         hasProperties: function (a) {
            if ("object" != typeof a)
               return !1;
            var b;
            for (b in a)
               if (a.hasOwnProperty(b))
                  return !0;
            return !1
         },
         get: function (a, b) {
            if (FooBox.options.isMultipart(b, ".")) {
               var c = b.substring(0, b.indexOf(".")),
                       d = b.substring(b.indexOf(".") + 1);
               return a[c] = a[c] || {}, FooBox.options.get(a[c], d)
            }
            return a[b]
         },
         set: function (a, b, c) {
            if (FooBox.options.isMultipart(b, ".")) {
               var d = b.substring(0, b.indexOf(".")),
                       e = b.substring(b.indexOf(".") + 1);
               a[d] = a[d] || {}, FooBox.options.set(a[d], e, c)
            } else
               a[b] = c
         },
         merge: function (a, b, c) {
            var d, e = Array.prototype.slice.call(arguments);
            for (a = e.shift(), b = e.shift(), FooBox.options._merge(a, b), d = 0; d < e.length; d++)
               c = e[d], FooBox.options._merge(a, c);
            return a
         },
         _merge: function (b, c) {
            var d;
            for (d in c)
               c.hasOwnProperty(d) && (FooBox.options.hasProperties(c[d]) && !a.isArray(c[d]) ? (b[d] = b[d] || {}, FooBox.options._merge(b[d], c[d])) : a.isArray(c[d]) ? (b[d] = [], a.extend(!0, b[d], c[d])) : b[d] = c[d])
         }
      }, FooBox.objects = {
         registered: {},
         ensure: function (a) {
            return FooBox.objects.registered[a] = FooBox.objects.registered[a] || []
         },
         register: function (b, c, d) {
            var e = FooBox.objects.ensure(b);
            return e.push(c), "object" == typeof d && a.extend(!0, FooBox.defaults, d), !0
         },
         load: function (a, b) {
            var c, e, f = [],
                    g = FooBox.objects.ensure(a);
            for (e = 0; e < g.length; e++)
               try {
                  c = g[e], f.push(new c(b))
               } catch (h) {
                  d.error(h)
               }
            b.objects = b.objects || {}, b.objects[a] = f
         },
         call: function (b, c, e, f, g) {
            var h, i = Array.prototype.slice.call(arguments);
            b = i.shift(), c = i.shift(), e = i.shift();
            for (var j = c.objects[b] || [], k = 0; k < j.length; k++)
               try {
                  if (h = j[k], !a.isFunction(h[e]))
                     continue;
                  h[e].apply(h, i)
               } catch (l) {
                  d.error(l)
               }
         },
         get: function (b, c, d) {
            var e, f = c.objects[b];
            if (!f || !a.isFunction(d))
               return null;
            for (e = 0; e < f.length; e++)
               if (d(f[e]))
                  return f[e];
            return null
         }
      }, FooBox.addons = {
         _ns: "addons",
         validate: function (b) {
            return a.isFunction(b) ? !0 : (d.error('Expected type "function", received type "{0}".', typeof b), !1)
         },
         register: function (a, b) {
            return FooBox.addons.validate(a) ? FooBox.objects.register(FooBox.addons._ns, a, b) : (d.error("Failed to register the addon."), !1)
         },
         load: function (a) {
            FooBox.objects.load(FooBox.addons._ns, a)
         },
         call: function (a, b, c, d) {
            var e = Array.prototype.slice.call(arguments);
            e.unshift(FooBox.addons._ns), FooBox.objects.call.apply(this, e)
         }
      }, FooBox.handlers = {
         _ns: "handlers",
         validate: function (b) {
            if (!a.isFunction(b))
               return d.error('Expected type "function", received type "{0}".', typeof b), !1;
            var c = new b;
            return a.isFunction(c.handles) ? a.isFunction(c.defaults) ? a.isFunction(c.parse) ? a.isFunction(c.load) ? a.isFunction(c.getSize) ? a.isFunction(c.hasChanged) ? a.isFunction(c.preload) ? !0 : (d.error('The required "preload" method is not implemented.'), !1) : (d.error('The required "hasChanged" method is not implemented.'), !1) : (d.error('The required "getSize" method is not implemented.'), !1) : (d.error('The required "load" method is not implemented.'), !1) : (d.error('The required "parse" method is not implemented.'), !1) : (d.error('The required "defaults" method is not implemented.'), !1) : (d.error('The required "handles" method is not implemented.'), !1)
         },
         register: function (a, b) {
            return FooBox.handlers.validate(a) ? FooBox.objects.register(FooBox.handlers._ns, a, b) : (d.error("Failed to register the handler."), !1)
         },
         load: function (a) {
            FooBox.objects.load(FooBox.handlers._ns, a)
         },
         call: function (a, b, c, d) {
            var e = Array.prototype.slice.call(arguments);
            e.unshift(FooBox.handlers._ns), FooBox.objects.call.apply(this, e)
         },
         get: function (a, b) {
            return FooBox.objects.get(FooBox.handlers._ns, a, function (a) {
               return a.type == b
            })
         }
      }, FooBox.Item = function (b, c, d) {
         return this.type = b, this.element = FooBox.isjQuery(c) ? c : a(c), this.handler = d, this.width = null, this.height = null, this.url = null, this.overflow = !1, this.preloaded = !1, this.proportion = !1, this.error = !1, this
      }, FooBox.Size = function (a, b) {
         return this.width = "number" == typeof a ? a : parseInt(a, 0), this.height = "number" == typeof b ? b : parseInt(b, 0), this.equalTo = function (a) {
            return this.width == a.width && this.height == a.height
         }, this
      }, FooBox.Size.check = function (a) {
         return "number" == typeof a ? a : isNaN(parseInt(a)) ? null : parseInt(a)
      }, FooBox.Timer = function () {
         this.id = null, this.busy = !1;
         var a = this;
         return this.start = function (b, c, d) {
            d = d || b, a.stop(), a.id = setTimeout(function () {
               b.call(d), a.id = null, a.busy = !1
            }, c), a.busy = !0
         }, this.stop = function () {
            null !== a.id && a.busy !== !1 && (clearTimeout(a.id), a.id = null, a.busy = !1)
         }, this
      }, a.fn.foobox = function (b) {
         return b = b || {}, this.each(function () {
            var c = a(this).data("fbx_instance");
            if (c instanceof FooBox.Instance)
               if (1 == c.options.alwaysInit) {
                  var d = c.options;
                  c.destroy(), c = new FooBox.Instance(c.id), c.init(this, a.extend(!0, d, b))
               } else
                  c.reinit(b);
            else {
               if (c = a(this).data("fbx_p_instance"), c instanceof FooBox.Instance)
                  return;
               c = new FooBox.Instance, c.init(this, b)
            }
         })
      }, FooBox.Modal = function (b) {
         this.FooBox = b, this.element = null, this.loaderTimeout = new FooBox.Timer, this._first = !1, this._busy = !1, this._closed = !1;
         var c = this;
         return this.init = function (a, b) {
            c.setup.html(), c.setup.options(b), c.setup.bind()
         }, this.reinit = function (a) {
            c.setup.options(a)
         }, this.destroy = function () {
            FooBox.isjQuery(c.element) && c.element.remove()
         }, this.setup = {
            html: function () {
               if (!FooBox.isjQuery(c.element)) {
                  c.element = a('<div class="fbx-modal"></div>'), c.element.append('<div class="fbx-inner-spacer"></div>');
                  var b = a('<div class="fbx-stage"></div>');
                  b.append('<div class="fbx-item-current"></div>'), b.append('<div class="fbx-item-next"></div>');
                  var d = a('<div class="fbx-inner fbx-inner-shadow"></div>');
                  d.append(b), d.append('<a class="fbx-prev fbx-btn-transition fbx-btn-shadow"></a>'), d.append('<div class="fbx-credit"><a target="_blank" href=""><em></em><span> FooBox</span></a></div>'), d.append('<span class="fbx-count" />'), d.append('<a class="fbx-next fbx-btn-transition fbx-btn-shadow"></a>'), d.append('<a class="fbx-close fbx-btn-transition fbx-btn-shadow"></a>'), c.element.append('<div class="fbx-loader"><div></div></div>'), c.element.append(d), c.FooBox.raise("foobox.setupHtml"), a("body").append(c.element)
               }
            },
            options: function (a) {
               var b;
               c.element.removeClass().addClass("fbx-modal").addClass(FooBox.format("fbx-{0}", c.FooBox.id)).addClass(c.FooBox.element.data("style") || a.style).addClass(c.FooBox.element.data("theme") || a.theme).addClass(c.FooBox.element.data("modal-class")).addClass(a.modalClass).data("fbx_instance", c.FooBox), c.element.addClass(FooBox.browser.css), b = a.affiliate.enabled ? "" : "none", c.element.find(".fbx-credit").css("display", b), a.affiliate.enabled && (c.element.find(".fbx-credit > a").attr("href", a.affiliate.url), c.element.find(".fbx-credit > a > em").text(a.affiliate.prefix)), b = a.showCount && c.FooBox.items.multiple() ? "" : "none", c.element.find(".fbx-count").css("display", b), a.showButtons && c.FooBox.items.multiple() || c.element.addClass("fbx-no-buttons"), c.FooBox.raise("foobox.setupOptions")
            },
            bind: function () {
               1 == c.FooBox.options.closeOnOverlayClick && c.element.unbind("click.foobox").bind("click.foobox", function (b) {
                  1 == c.FooBox.options.closeOnOverlayClick && a(b.target).is(".fbx-modal") && c.close()
               }), c.element.find(".fbx-close").unbind("click.foobox").bind("click.foobox", function (a) {
                  a.preventDefault(), a.stopPropagation(), c.close()
               }).end().find(".fbx-prev").unbind("click.foobox").bind("click.foobox", function (b) {
                  b.preventDefault(), b.stopPropagation(), a(this).hasClass("fbx-disabled") || c.prev()
               }).end().find(".fbx-next").unbind("click.foobox").bind("click.foobox", function (b) {
                  b.preventDefault(), b.stopPropagation(), a(this).hasClass("fbx-disabled") || c.next()
               })
            }
         }, this.prioritize = function () {
            FooBox.instances.length > 1 && c.element.nextAll(".fbx-modal:last").after(c.element)
         }, this.preload = function () {
            if (1 == c.FooBox.options.preload) {
               var a = c.FooBox.items.prev();
               a && a.handler.preload(a);
               var b = c.FooBox.items.next();
               b && b.handler.preload(b)
            }
         }, this.show = function (b) {
            function e(a) {
               if (c.loaderTimeout.stop(), c.element.removeClass("fbx-loading"), c._busy = !1, d.error(a), !c.FooBox.raise("foobox.onError", {
                  error: a
               }).isDefaultPrevented()) {
                  var e = c.FooBox.items.error(f.index);
                  null != e && c.show(b)
               }
            }
            b = b || !1, c._first = b, c._busy = !0, c._closed = !1, a("body").addClass("fbx-active"), c.FooBox.options.hideScrollbars && a("html").css("overflow", "hidden");
            var f = c.FooBox.items.current();
            1 == f.error ? c.element.addClass("fbx-error") : c.element.removeClass("fbx-error"), c.element.hasClass("fbx-show") || (c.prioritize(), c.element.addClass("fbx-loading").find(".fbx-inner").css({
               width: "100px",
               height: "100px",
               "margin-top": "-50px",
               "margin-left": "-50px"
            }));
            var g = c.element.find(".fbx-item-current"),
                    h = c.element.find(".fbx-item-next");
            if (h.hide().css("opacity", "0"), c.element.find(".fbx-count").text(c.FooBox.options.countMessage.replace("%index", "" + (c.FooBox.items.indexes.current + 1)).replace("%total", "" + c.FooBox.items.array.length)), c.FooBox.raise("foobox.beforeLoad", {
               item: f
            }).isDefaultPrevented())
               return void(c._busy = !1);
            if (f.handler.hasChanged(f)) {
               var i = f.index,
                       j = f.element.get(0);
               f = f.handler.parse(f.element);
               var k = c.FooBox.raise("foobox.parseItem", {
                  element: f.element,
                  item: f
               });
               j.index = k.fb.item.index = i, c.FooBox.items.array[i] = k.fb.item
            }
            c.preload(), c.loaderTimeout.start(function () {
               c.element.addClass("fbx-loading")
            }, c.FooBox.options.loaderTimeout), setTimeout(function () {
               c.checkForLoop(f), f.handler.load(f, h, function (a) {
                  return 1 == c._closed ? void(c._busy = !1) : void c.transitionOut(g, function () {
                     return 1 == c._closed ? void(c._busy = !1) : void c.resize(a, h, function () {
                        return 1 == c._closed ? void(c._busy = !1) : (c.loaderTimeout.stop(), h.show(), void c.transitionIn(h, function () {
                           return 1 == c._closed ? void(c._busy = !1) : (h.add(g).toggleClass("fbx-item-next fbx-item-current"), g.empty(), void(c.element.hasClass("fbx-show") ? (c.element.removeClass("fbx-loading"), c.FooBox.raise("foobox.afterLoad", {
                              item: f
                           }), c._busy = !1) : c.FooBox.raise("foobox.beforeShow", {
                              item : f
                           }).isDefaultPrevented() || (c.element.removeClass("fbx-loading").addClass("fbx-show"), c.FooBox.raise("foobox.afterShow", {
                              item: f
                           }), c.FooBox.raise("foobox.afterLoad", {
                              item: f
                           }), c._busy = !1)))
                        }, e))
                     }, e)
                  }, e)
               }, e)
            }, c.FooBox.options.loadDelay)
         }, this.checkForLoop = function (a) {
            1 != c.FooBox.options.loop && (c.element.find(".fbx-prev, .fbx-next").removeClass("fbx-disabled"), c.FooBox.items.is.first(a) && c.element.find(".fbx-prev").addClass("fbx-disabled"), c.FooBox.items.is.last(a) && c.element.find(".fbx-next").addClass("fbx-disabled"))
         }, this.resize = function (b, d, e, f) {
            try {
               if (0 === b.width || 0 === b.height)
                  return void(a.isFunction(f) && f(FooBox.format("Invalid size supplied. Width = {0}, Height = {1}", b.width, b.height)));
               var g = c.FooBox.items.current(),
                       h = new FooBox.Size(b.width, b.height),
                       i = c.element.find(".fbx-inner"),
                       j = c.element.find(".fbx-inner-spacer"),
                       k = parseInt(j.css("padding-top"), 0),
                       l = parseInt(j.css("padding-bottom"), 0),
                       m = parseInt(j.css("padding-left"), 0),
                       n = parseInt(j.css("padding-right"), 0),
                       o = parseInt(i.css("border-top-width"), 0),
                       p = parseInt(i.css("border-bottom-width"), 0),
                       q = parseInt(i.css("border-left-width"), 0),
                       r = parseInt(i.css("border-right-width"), 0),
                       s = parseInt(i.css("padding-left"), 0),
                       t = k + l + 2 * s + o + p,
                       u = m + n + 2 * s + q + r,
                       v = new FooBox.Size(parseInt(i.css("width"), 0), parseInt(i.css("height"), 0)),
                       w = new FooBox.Size(c.element.width() - u, c.element.height() - t),
                       x = w.width / b.width;
               b.height * x > w.height && (x = w.height / b.height), c.FooBox.options.fitToScreen === !0 || 1 == g.proportion && (b.height > w.height || b.width > w.width) ? (b.height = Math.floor(b.height * x), b.width = Math.floor(b.width * x)) : 0 == g.proportion && (b.height > w.height && (b.height = w.height), b.width > w.width && (b.width = w.width)), b.height < 100 && (b.height = 100), b.width < 100 && (b.width = 100);
               var y = -(b.height / 2 + s + (l - k / 2) / 2) + (q + r) / 2,
                       z = -(b.width / 2 + s + (q + r) / 2);
               if (v.equalTo(b))
                  i.css({
                     height: b.height,
                     width: b.width,
                     "margin-top": y,
                     "margin-left": z
                  }), c.overflow(g, h, b, d), c.FooBox.raise("foobox.afterResize", {
                     item: g,
                     size: b
                  }), a.isFunction(e) && e();
               else if (!c.FooBox.raise("foobox.beforeResize", {
                  item: g,
                  size: b,
                  offset: {
                     top: y,
                     left: z
                  },
                  error: f,
                  success: e
               }).isDefaultPrevented())
                  if (y = -(b.height / 2 + s + (l - k / 2) / 2) + (q + r) / 2, z = -(b.width / 2 + s + (q + r) / 2), c.element.hasClass("fbx-show"))
                     if (FooBox.browser.supportsTransitions()) {
                        var A = c.FooBox.options.resizeSpeed / 1e3,
                                B = "all " + A + "s ease-in-out";
                        i.css({
                           WebkitTransition: B,
                           MozTransition: B,
                           MsTransition: B,
                           OTransition: B,
                           transition: B
                        }), i.css({
                           height: b.height,
                           width: b.width,
                           "margin-top": y,
                           "margin-left": z
                        }), setTimeout(function () {
                           i.css({
                              WebkitTransition: "",
                              MozTransition: "",
                              MsTransition: "",
                              OTransition: "",
                              transition: ""
                           }), c.overflow(g, h, b, d), c.FooBox.raise("foobox.afterResize", {
                              item: g,
                              size: b
                           }), a.isFunction(e) && e(b)
                        }, c.FooBox.options.resizeSpeed)
                     } else
                        i.animate({
                           height: b.height,
                           width: b.width,
                           "margin-top": y,
                           "margin-left": z
                        }, c.FooBox.options.resizeSpeed, function () {
                           c.overflow(g, h, b, d), c.FooBox.raise("foobox.afterResize", {
                              item: g,
                              size: b
                           }), a.isFunction(e) && e(b)
                        });
                  else
                     i.css({
                        height: b.height,
                        width: b.width,
                        "margin-top": y,
                        "margin-left": z
                     }), c.overflow(g, h, b, d), c.FooBox.raise("foobox.afterResize", {
                        item: g,
                        size: b
                     }), a.isFunction(e) && e()
            } catch (C) {
               a.isFunction(f) && f(C)
            }
         }, this.overflow = function (a, b, d, e) {
            var f = e.find(".fbx-item");
            1 == a.overflow && (d.width < .8 * b.width || d.height < .8 * b.height) || 1 == a.overflow && 0 == a.proportion && (d.width < b.width || d.height < b.height) || 1 == a.overflow && "html" == a.type ? ("html" == a.type ? (f.css({
               width: "100%",
               height: "auto",
               overflow: ""
            }), e.css("overflow", "auto")) : (f.css({
               width: b.width,
               height: b.height,
               overflow: ""
            }), e.css({
               "overflow-x": b.width <= d.width ? "hidden" : "",
               "overflow-y": b.height <= d.height ? "hidden" : ""
            })), c.FooBox.raise("foobox.showOverflow", {
               item: a,
               container: e
            })) : (f.css({
               width: "",
               height: "",
               overflow: "hidden"
            }), e.css({
               "overflow-x": "",
               "overflow-y": "",
               overflow: "hidden"
            }), c.FooBox.raise("foobox.hideOverflow", {
               item: a,
               container: e
            }))
         }, this.transitionOut = function (b, d, e) {
            try {
               if (!c.element.hasClass("fbx-show"))
                  return void(a.isFunction(d) && d());
               b.animate({
                  opacity: 0
               }, b.is(":visible") ? c.FooBox.options.transitionOutSpeed : 0, function () {
                  a.isFunction(d) && d()
               })
            } catch (f) {
               a.isFunction(e) && e(f)
            }
         }, this.transitionIn = function (b, d, e) {
            try {
               if (!c.element.hasClass("fbx-show"))
                  return b.css({
                     opacity: 1
                  }), void(a.isFunction(d) && d());
               b.animate({
                  opacity: 1
               }, c.FooBox.options.transitionInSpeed, function () {
                  a.isFunction(d) && d()
               })
            } catch (f) {
               a.isFunction(e) && e(f)
            }
         }, this.close = function () {
            c.FooBox.raise("foobox.beforeClose").isDefaultPrevented() || (c._closed = !0, c._busy = !1, c.element.removeClass("fbx-loading fbx-show"), a("body").removeClass("fbx-active"), c.FooBox.raise("foobox.close"), c.element.find(".fbx-item-current, .fbx-item-next").empty(), c.FooBox.options.hideScrollbars && a("html").css("overflow", ""), c.FooBox.raise("foobox.afterClose"))
         }, this.prev = function (a) {
            if (1 != c._busy) {
               if (c.FooBox.items.indexes.set(c.FooBox.items.indexes.prev), "string" == typeof a)
                  for (var b = c.FooBox.items.current(); b.type != a; )
                     c.FooBox.items.indexes.set(c.FooBox.items.indexes.prev), b = c.FooBox.items.current();
               c.show(!1), c.FooBox.raise("foobox.previous")
            }
         }, this.next = function (a) {
            if (1 != c._busy) {
               if (c.FooBox.items.indexes.set(c.FooBox.items.indexes.next), "string" == typeof a)
                  for (var b = c.FooBox.items.current(); b.type != a; )
                     c.FooBox.items.indexes.set(c.FooBox.items.indexes.next), b = c.FooBox.items.current();
               c.show(!1), c.FooBox.raise("foobox.next")
            }
         }, this
      }, FooBox.Instance = function (b) {
         this.id = null, "number" == typeof b ? (this.id = b, FooBox.instances[b - 1] = this) : this.id = FooBox.instances.push(this), this.element = null, this.options = a.extend(!0, {}, FooBox.defaults), this.modal = new FooBox.Modal(this), this.objects = {}, FooBox.addons.load(this), FooBox.handlers.load(this);
         var c = this;
         return this.raise = function (a, b) {
            return FooBox.raise(c, a, b)
         }, this.init = function (b, d) {
            c.element = FooBox.isjQuery(b) ? b : a(b), c.options = FooBox.options.merge(c.options, d || {}), FooBox.addons.call(c, "preinit", c.element, c.options), c.items.init(), c.items.array.length > 0 ? (c.element.data("fbx_instance", c), c.options.containerCssClass && c.element.addClass(c.options.containerCssClass), c.setup.bind(), c.modal.init(b, c.options), FooBox.handlers.call(c, "init", c.element, c.options), c.raise("foobox.initialized"), a.isFunction(c.options.initCallback) && c.options.initCallback.call(c)) : c.destroy()
         }, this.reinit = function (a) {
            c.options = FooBox.options.merge(c.options, a || {}), c.items.init(!0), c.items.array.length > 0 ? (c.setup.bind(), c.modal.reinit(c.options), FooBox.handlers.call(c, "reinit", c.options), c.raise("foobox.reinitialized")) : c.destroy()
         }, this.destroy = function () {
            FooBox.addons.call(c, "destroy"), FooBox.handlers.call(c, "destroy"), c.items.destroy(), c.modal.destroy(), c.element.removeClass("fbx-instance fbx-item").data({
               fbx_instance: null,
               fbx_p_instance: null
            }), c.id == FooBox.instances.length ? FooBox.instances.splice(c.id - 1, 1) : FooBox.instances[c.id - 1] = null, c.raise("foobox.destroy")
         }, this.setup = {
            bind: function () {
               a(c.options.externalSelector).unbind("click.fooboxExternal").bind("click.fooboxExternal", function (b) {
                  b.preventDefault();
                  var c = a(this).data("foobox"),
                          d = a(c),
                          e = d.data("fbx_instance") || d.data("fbx_p_instance");
                  return d.length > 0 && e instanceof FooBox.Instance && e.modal instanceof FooBox.Modal && e.modal.show(!0), !1
               })
            }
         }, this.items = {
            array: [],
            indexes: {
               prev: -1,
               current: 0,
               next: 1,
               direction: "*",
               set: function (a) {
                  var b = c.items.indexes.current;
                  a = a || 0, a = a > c.items.array.length - 1 ? 0 : 0 > a ? c.items.array.length - 1 : a;
                  var d = a - 1,
                          e = a + 1;
                  c.items.indexes.current = a, c.items.indexes.prev = 0 > d ? c.items.array.length - 1 : d, c.items.indexes.next = e > c.items.array.length - 1 ? 0 : e, c.items.indexes.direction = c.items.indexes._direction(b, a, c.items.array.length - 1)
               },
               _direction: function (a, b, c) {
                  return 0 == b && a == c ? ">" : b == c && 0 == a ? "<" : b > a ? ">" : a > b ? "<" : "*"
               }
            },
            new_array: function (b) {
               b = b || !1;
               var d, e, f, g = 0;
               if (1 == b) {
                  if (c.items.array.length > 0) {
                     for (var h = 0; h < c.items.array.length; h++)
                        d = c.items.array[h], FooBox.isjQuery(d.element) ? 0 == d.element.parents(":first").length && (c.items.array.splice(h, 1), h -= 1) : d.option || (c.items.array.splice(h, 1), h -= 1);
                     for (var i = 0; i < c.items.array.length; i++)
                        d = c.items.array[i], FooBox.isjQuery(d.element) ? (f = d.element.get(0), f.index = d.index = i) : d.index = i
                  }
               } else
                  c.items.array = [];
               if (a.isArray(c.options.items))
                  for (var j = 0; j < c.options.items.length; j++)
                     if (d = c.options.items[j], -1 == c.items.indexOf(d))
                        for (var k = 0; k < c.objects.handlers.length; k++)
                           if (c.objects.handlers[k].type == d.type) {
                              d.index = g, d.option = !0, d.handler = c.objects.handlers[k], d.handler.defaults(d), e = c.raise("foobox.parseItem", {
                                 element: null,
                                 item: d
                              }), c.items.array.push(e.fb.item), g++;
                              break
                           }
            },
            init: function (a) {
               a = a || !1, c.items.new_array(a), c.element.is(c.options.selector) && !c.element.is(c.options.excludes) && c.items.add(c.element) ? c.element.unbind("click.item").bind("click.item", c.items.clicked) : c.element.find(c.options.selector).not(c.options.excludes).unbind("click.item").filter(function () {
                  return c.items.add(this)
               }).bind("click.item", c.items.clicked), c.items.rel()
            },
            destroy: function () {
               var b, d;
               for (d = 0; d < c.items.array.length; d++)
                  b = c.items.array[d], a.isFunction(b.destroy) && b.destroy(), FooBox.isjQuery(b.element) && b.element.unbind("click.item").removeClass("fbx-link").data("fbx_p_instance", null);
               c.items.array = []
            },
            rel: function () {
               var b = c.options.rel || c.element.attr("rel") || (c.items.first(function (a) {
                  return FooBox.isjQuery(a.element) ? "string" == typeof a.element.attr("rel") : !1
               }) || {
                  element: a()
               }).element.attr("rel");
               "string" == typeof b && a('[rel="' + b + '"]').not(c.options.excludes).not(c.element).unbind("click.item").filter(function () {
                  return c.items.add(this)
               }).bind("click.item", c.items.clicked)
            },
            indexOf: function (a, b) {
               if (!a)
                  return -1;
               b = b || "url";
               var d;
               for (d = 0; d < c.items.array.length; d++)
                  if (c.items.array[d][b] == a[b])
                     return d;
               return -1
            },
            is: {
               first: function (a) {
                  return c.items.array && 0 != c.items.array.length ? c.items.array[0].index == a.index : !1
               },
               last: function (a) {
                  return c.items.array && 0 != c.items.array.length ? c.items.array[c.items.array.length - 1].index == a.index : !1
               }
            },
            add: function (b) {
               b = FooBox.isjQuery(b) ? b : a(b);
               var d = c.items.parse(b, c.items.array.length);
               if (null === d)
                  return !1;
               var e = b.get(0),
                       f = c.items.indexOf(d);
               -1 != f ? (d = c.items.array[f], e.index = d.index) : e.index = d.index = c.items.array.push(d) - 1;
               var g = b.addClass("fbx-link").data("fbx_p_instance");
               return g instanceof FooBox.Instance || b.data("fbx_p_instance", c), !0
            },
            get: function (b) {
               b = FooBox.isjQuery(b) ? b : a(b);
               var d = null,
                       e = b.get(0).index;
               return e && e > 0 && e <= c.items.array.length - 1 && (d = c.items.array[e]), d
            },
            parse: function (b, d) {
               b = FooBox.isjQuery(b) ? b : a(b);
               for (var e, f, g = 0; g < c.objects.handlers.length; g++)
                  if (c.objects.handlers[g].handles(b, c.element)) {
                     e = c.objects.handlers[g].parse(b), isNaN(d) || (e.index = d), f = c.raise("foobox.parseItem", {
                        element: b,
                        item: e
                     });
                     break
                  }
               return "undefined" != typeof f && f.fb.item ? f.fb.item : null
            },
            error: function (b) {
               function d(b) {
                  var c = this;
                  return c.FooBox = b, c.type = "error", c.handles = function () {
                     return !1
                  }, c.hasChanged = function () {
                     return !1
                  }, c.defaults = function () {}, c.parse = function () {}, c.load = function (b, d, e, f) {
                     try {
                        d.empty().append(b.content), a.isFunction(e) && e(c.getSize(b))
                     } catch (g) {
                        a.isFunction(f) && f(g)
                     }
                  }, c.getSize = function (a) {
                     return new FooBox.Size(a.width, a.height)
                  }, c
               }
               if (c.items.array.length > b && 1 == c.items.array[b].error)
                  return c.items.array[b];
               var e, f, g = FooBox.handlers.get(c, "html"),
                       h = !1;
               if (null == g && (g = new d(c)), null !== c.options.error.match(/^#/i) && a(c.options.error).length > 0)
                  e = a(c.options.error), h = !0;
               else {
                  var i = FooBox.format('<div class="fbx-error-msg" data-width="240" data-height="240"><span></span><p>{0}</p></div>', c.options.error);
                  e = a(i)
               }
               return f = new FooBox.Item(g.type, e.get(0), g), f.selector = 1 == h ? c.options.error : null, f.index = b, f.error = !0, f.title = e.data("title") || null, f.description = e.data("description") || null, f.width = e.data("width") || 240 || null, f.height = e.data("height") || 240 || null, f.content = 1 == h ? null : e, f.fullscreen = !0, f.handler = g, c.items.array[b] = f, f
            },
            first: function (a) {
               for (var b = null, d = 0; d < c.items.array.length; d++)
                  if (a(c.items.array[d])) {
                     b = c.items.array[d];
                     break
                  }
               return b
            },
            current: function () {
               return c.items.array[c.items.indexes.current]
            },
            prev: function () {
               return c.items.array[c.items.indexes.prev]
            },
            next: function () {
               return c.items.array[c.items.indexes.next]
            },
            multiple: function () {
               return c.items.array.length > 1
            },
            clicked: function (a) {
               return a.preventDefault(), c.items.indexes.set(this.index), c.modal.show(!0), !1
            }
         }, this
      }, FooBox.open = function (b) {
         if (1 == FooBox.isDeepLink)
            return null;
         var c, d = null;
         if ("object" == typeof b) {
            var e = document.createElement("a");
            a(e).foobox(b), d = a(e).data("fbx_instance")
         } else
            "number" == typeof b ? c = b : (c = parseInt(b || 0), c = isNaN(c) ? 0 : c), c = c > FooBox.instances.length - 1 ? FooBox.instances.length - 1 : 0 > c ? 0 : c, d = FooBox.instances[c];
         return null != d && d.modal instanceof FooBox.Modal ? (d.modal.show(!0), d) : null
      }, FooBox.close = function () {
         var a, b = [],
                 c = null;
         for (a = 0; a < FooBox.instances.length; a++)
            c = FooBox.instances[a], null != c && c.modal instanceof FooBox.Modal && FooBox.isjQuery(c.modal.element) && c.modal.element.hasClass("fbx-show") && b.push(c);
         for (a = 0; a < b.length; a++)
            c = b[a], c.modal.close()
      }, FooBox.resize = function (c, d) {
         if (c || d) {
            var e, f, g, h;
            for (e = 0; e < FooBox.instances.length; e++)
               f = FooBox.instances[e], null != f && f.modal instanceof FooBox.Modal && FooBox.isjQuery(f.modal.element) && f.modal.element.hasClass("fbx-show") && (g = f.items.current(), h = new FooBox.Size(c || g.width || 0, d || g.height || 0), g.width = h.width, g.height = h.height, f.modal.resize(h, f.modal.element.find(".fbx-item-current")))
         } else
            a(b).trigger("resize.foobox")
      }, FooBox.lateBind = function (c, d) {
         var e = a.extend(!0, {}, FooBox.defaults, d || b.FOOBOX && FOOBOX.o || {}),
                 f = a(c);
         f.on("click.foobox", e.selector, function (a) {
            a.preventDefault();
            var b = f.data("fbx_instance");
            b || (b = f.foobox(e).data("fbx_instance")), b instanceof FooBox.Instance && "number" == typeof this.index && (b.items.indexes.set(this.index), b.modal.show(!0))
         })
      }
   }
}(jQuery, window, window.console),
        function (a, b) {
           var c = {
              images: {
                 noRightClick: !1,
                 attr: "href",
                 overflow: !1,
                 fullscreen: !0,
                 showCaptions: !0,
                 regex: /https?:\/\/.*?\/.*?\.(jpg|jpeg|png|gif|bmp)/i,
                 maxWidth: -1,
                 maxHeight: -1,
                 findUrl: function (a, c) {
                    if (!c)
                       return "";
                    if (c.data("image"))
                       return c.data("image");
                    var d = c.attr(a.options.images.attr);
                    return "string" == typeof d ? b.qualifiedURL(c.attr(a.options.images.attr)) : ""
                 }
              }
           };
           b.Item.prototype.image = null, b.Item.prototype.maxWidth = null, b.Item.prototype.maxHeight = null, b.ImageHandler = function (c) {
              this.FooBox = c, this.type = "image";
              var d = this;
              this.handles = function (a) {
                 var b = d.FooBox.options.images.findUrl(d.FooBox, a),
                         c = "string" == typeof b && null != b.match(d.FooBox.options.images.regex),
                         e = d.FooBox.raise("foobox.handlesImage", {
                            element: a,
                            handle: c
                         });
                 return e.fb.handle
              }, this.defaults = function (a) {
                 a.fullscreen = a.fullscreen || d.FooBox.options.images.fullscreen, a.captions = a.captions || d.FooBox.options.images.showCaptions, a.social = a.social || !0, a.overflow = a.overflow || d.FooBox.options.images.overflow, a.proportion = a.proportion || !0, a.maxWidth = a.maxWidth || d.FooBox.options.images.maxWidth, a.maxHeight = a.maxHeight || d.FooBox.options.images.maxHeight
              }, this.parse = function (a) {
                 var c = new b.Item(d.type, a, this);
                 return d.defaults(c), c.url = d.FooBox.options.images.findUrl(d.FooBox, a) || null, c.width = b.Size.check(a.data("width") || c.width || null), c.height = b.Size.check(a.data("height") || c.height || null), c.fullscreen = "boolean" == typeof a.data("fullscreen") ? a.data("fullscreen") : c.fullscreen, c.overflow = "boolean" == typeof a.data("overflow") ? a.data("overflow") : c.overflow, c.proportion = "boolean" == typeof a.data("proportion") ? a.data("proportion") : c.proportion, c.maxWidth = "number" == typeof a.data("maxWidth") ? a.data("maxWidth") : c.maxWidth, c.maxHeight = "number" == typeof a.data("maxHeight") ? a.data("maxHeight") : c.maxHeight, c.image = null, c.image_url = c.url, c
              }, this.load = function (b, c, e, f) {
                 try {
                    var g = function () {
                       var f = a(b.image).addClass("fbx-item fbx-item-image");
                       d.FooBox.options.images.noRightClick && f.bind("contextmenu", function (a) {
                          return a.preventDefault(), !1
                       }), c.empty().append(f), a.isFunction(e) && e(d.getSize(b))
                    };
                    b.image && null !== b.image ? g() : (b.image = new Image, b.image.onload = function () {
                       b.image.onload = b.image.onerror = null, b.height = b.image.height, b.width = b.image.width, g()
                    }, b.image.onerror = function () {
                       b.image.onload = b.image.onerror = null, b.image = null, a.isFunction(f) && f("An error occurred attempting to load the image.")
                    }, b.image.src = b.url)
                 } catch (h) {
                    a.isFunction(f) && f(h)
                 }
              }, this.preload = function (a) {
                 if (1 != a.preloaded) {
                    var b = new Image;
                    b.src = a.url, a.preloaded = !0
                 }
              }, this.getSize = function (a) {
                 if (null != a.width && null != a.height) {
                    if (a.maxWidth > 0 && a.maxHeight > 0 && (a.width > a.maxWidth || a.height > a.maxHeight)) {
                       var c = a.width > a.height ? a.maxWidth / a.width : a.maxHeight / a.height;
                       a.width *= c, a.height *= c
                    }
                    return new b.Size(a.width, a.height)
                 }
                 return new b.Size(0, 0)
              }, this.hasChanged = function (a) {
                 if (b.isjQuery(a.element)) {
                    var c = d.FooBox.options.images.findUrl(d.FooBox, a.element);
                    return a.url != c
                 }
                 return !1
              }
           }, b.handlers.register(b.ImageHandler, c)
        }(jQuery, window.FooBox),
        function (a, b) {
           var c = {
              keyboard: {
                 enabled: !0,
                 preventDefault: !1,
                 stopPropagation: !1
              }
           };
           b.Keyboard = function (a) {
              this.FooBox = a;
              var c = this;
              this.preinit = function (a) {
                 c.handlers.unbind(!0),
                         a.bind({
                            "foobox.initialized foobox.reinitialized": c.handlers.initialized,
                            "foobox.setupHtml": c.handlers.setupHtml
                         })
              }, this.destroy = function () {
                 c.handlers.unbind(!0)
              }, this.handlers = {
                 unbind: function (a) {
                    a = a || !1, a && c.FooBox.element.unbind({
                       "foobox.initialized foobox.reinitialized": c.handlers.initialized,
                       "foobox.setupHtml": c.handlers.setupHtml
                    }), c.FooBox.element.unbind("foobox.afterLoad", c.handlers.afterLoad), b.isjQuery(c.FooBox.modal.element) && c.FooBox.modal.element.unbind("keydown.foobox", c.handlers.onKeydown)
                 },
                 initialized: function () {
                    c.handlers.unbind(), 1 == c.FooBox.options.keyboard.enabled && (c.FooBox.element.bind("foobox.afterLoad", c.handlers.afterLoad), b.isjQuery(c.FooBox.modal.element) && c.FooBox.modal.element.bind("keydown.foobox", c.handlers.onKeydown))
                 },
                 setupHtml: function (a) {
                    a.fb.modal.attr("tabindex", 0)
                 },
                 afterLoad: function (a) {
                    a.fb.modal.focus()
                 },
                 onKeydown: function (a) {
                    var b = c.FooBox.modal,
                            d = c.FooBox.options.keyboard;
                    b.element.hasClass("fbx-show") && (b.element.hasClass("fbx-fullscreen-mode") || 27 !== a.which ? c.FooBox.items.multiple() && 37 === a.which ? b.prev() : c.FooBox.items.multiple() && 39 === a.which && b.next() : b.close(), 1 == d.preventDefault && a.preventDefault(), 1 == d.stopPropagation && a.stopPropagation(), c.FooBox.raise("foobox.keydown", {
                       keyCode: a.which
                    }))
                 }
              }
           }, b.addons.register(b.Keyboard, c)
        }(jQuery, window.FooBox),
        function (a, b) {
           var c = {
              hideNavOnMobile: !1,
              resizeTimeout: 300,
              breakpoints: {
                 phone: 640,
                 tablet: 1024
              },
              iosInterval: 200
           };
           b.BPInfo = function (c) {
              var d = "undefined" != typeof window.devicePixelRatio && b.browser.isMobile ? window.devicePixelRatio : 1;
              this.width = (window.innerWidth || document.documentElement.clientWidth || (document.body ? document.body.offsetWidth : 0)) / d, this.height = (window.innerHeight || document.documentElement.clientHeight || (document.body ? document.body.offsetHeight : 0)) / d, this.orientation = this.width > this.height ? "fbx-landscape" : "fbx-portrait";
              var e, f = null;
              if (a.isArray(c))
                 for (var g = 0; g < c.length; g++)
                    if (e = c[g], e && e.width && this.width <= e.width) {
                       f = e;
                       break
                    }
              this.breakpoint = null == f ? "fbx-desktop" : f.name
           }, b.Responsive = function (c) {
              this.FooBox = c, this.breakpoint = {
                 values: [],
                 names: ""
              }, this.timers = {
                 resize: new b.Timer,
                 ios: new b.Timer
              };
              var d = this,
                      e = null;
              this.preinit = function (a) {
                 d.handlers.unbind(!0), a.bind("foobox.initialized foobox.reinitialized", d.handlers.initialized)
              }, this.destroy = function () {
                 d.handlers.unbind(!0)
              }, this.handlers = {
                 unbind: function (b) {
                    b = b || !1, b && d.FooBox.element.unbind("foobox.initialized foobox.reinitialized", d.handlers.initialized), a(window).unbind("resize.foobox", d.handlers.resize), d.FooBox.element.unbind({
                       "foobox.beforeShow": d.handlers.iosBeforeShow,
                       "foobox.close": d.handlers.iosClose
                    })
                 },
                 initialized: function () {
                    d.handlers.unbind(), d.setup.breakpoints(), d.style(), a(window).bind("resize.foobox", d.handlers.resize), b.browser.iOS && (b.browser.isSafari || b.browser.isChrome) && d.FooBox.element.bind({
                       "foobox.beforeShow": d.handlers.iosBeforeShow,
                       "foobox.close": d.handlers.iosClose
                    })
                 },
                 resize: function () {
                    d.timers.resize.start(function () {
                       d.style();
                       var a = d.FooBox.items.current();
                       if (d.FooBox.modal.element.has("fbx-show") && null != a) {
                          var b = a.handler.getSize(a);
                          d.FooBox.modal.resize(b, d.FooBox.modal.element.find(".fbx-item-current"))
                       }
                    }, d.FooBox.options.resizeTimeout)
                 },
                 iosBeforeShow: function () {
                    d.timers.ios.start(d.handlers.ios, d.FooBox.options.iosInterval)
                 },
                 iosClose: function () {
                    d.timers.ios.stop()
                 },
                 ios: function () {
                    if (!d.FooBox.modal.element.hasClass("fbx-show"))
                       return void d.timers.ios.start(d.handlers.ios, d.FooBox.options.iosInterval);
                    var a = window.orientation || 0,
                            c = window.innerHeight,
                            f = 90 == a || -90 == a,
                            g = 0,
                            h = 0,
                            i = f ? screen.availWidth : screen.availHeight;
                    b.browser.isChrome ? (g = i - (f ? 76 : 56), h = i - (f ? 0 : 20)) : b.browser.isSafari && (g = i - 88, h = i - (f ? 0 : 19)), (null == e || 0 == e) && g >= c ? (e = !0, d.iosRedraw()) : (null == e || 1 == e) && c >= h && (e = !1, d.iosRedraw()), d.timers.ios.start(d.handlers.ios, d.FooBox.options.iosInterval)
                 }
              }, this.setup = {
                 breakpoints: function () {
                    d.breakpoint.values = [], d.breakpoint.names = "";
                    for (var a in d.FooBox.options.breakpoints)
                       d.FooBox.options.breakpoints.hasOwnProperty(a) && (d.breakpoint.values.push({
                          name: d.fixName(a),
                          width: d.FooBox.options.breakpoints[a]
                       }), d.breakpoint.names += d.fixName(a) + " ");
                    d.breakpoint.values.sort(function (a, b) {
                       return a.width - b.width
                    })
                 }
              }, this.iosRedraw = function () {
                 window.scrollTo(0, document.body.scrollTop), a(window).trigger("resize")
              }, this.fixName = function (a) {
                 return /^fbx-[a-zA-Z0-9]/.test(a) ? a : "fbx-" + a
              }, this.style = function () {
                 var a = new b.BPInfo(d.breakpoint.values),
                         c = d.FooBox.modal.element;
                 c.removeClass(d.breakpoint.names).removeClass("fbx-desktop fbx-landscape fbx-portrait").addClass(a.breakpoint).addClass(a.orientation), d.FooBox.options.hideNavOnMobile === !0 ? c.addClass("fbx-no-nav") : c.removeClass("fbx-no-nav")
              }
           }, b.Responsive.metaCheck = function () {
              var b = a("meta[name=viewport]"),
                      c = b.attr("content");
              if (b.length > 0 && "string" == typeof c) {
                 for (var d = c.split(","), e = !1, f = !1, g = 0; g < d.length; g++) {
                    var h = a.trim(d[g]);
                    "width" == h.substring(0, 5) && -1 !== h.indexOf("device-width") ? e = !0 : "initial-scale" == h.substring(0, 13) && (f = !0)
                 }
                 e && !f && (d.push("initial-scale=1"), c = d.join(","), b.attr("content", c))
              }
           }, b.addons.register(b.Responsive, c), b.Responsive.metaCheck()
        }(jQuery, window.FooBox),
        function (a, b) {
           var c = {
              captions: {
                 animation: "slide",
                 enabled: !0,
                 descSource: "find",
                 hoverDelay: 300,
                 maxHeight: .4,
                 onlyShowOnHover: !1,
                 onlyShowOnClick: !1,
                 overrideDesc: !1,
                 overrideTitle: !1,
                 prettify: !1,
                 titleSource: "image_find"
              }
           };
           b.Item.prototype.captions = !1, b.Item.prototype.title = null, b.Item.prototype.description = null, b.Item.prototype.caption = null, b.Captions = function (c) {
              this.FooBox = c, this.timers = {
                 hover: new b.Timer
              };
              var d = this;
              this.preinit = function (a) {
                 d.handlers.unbind(!0), a.bind({
                    "foobox.initialized foobox.reinitialized": d.handlers.initialized,
                    "foobox.setupHtml": d.handlers.setupHtml,
                    "foobox.setupOptions": d.handlers.setupOptions,
                    "foobox.parseItem": d.handlers.parseItem,
                    "foobox.onError": d.handlers.onError
                 })
              }, this.destroy = function () {
                 d.handlers.unbind(!0)
              }, this.handlers = {
                 unbind: function (a) {
                    a = a || !1, a && d.FooBox.element.unbind({
                       "foobox.initialized foobox.reinitialized": d.handlers.initialized,
                       "foobox.setupHtml": d.handlers.setupHtml,
                       "foobox.setupOptions": d.handlers.setupOptions,
                       "foobox.parseItem": d.handlers.parseItem,
                       "foobox.onError": d.handlers.onError,
                       "foobox.close": d.handlers.close
                    }), d.FooBox.element.unbind({
                       "foobox.beforeLoad": d.handlers.beforeLoad,
                       "foobox.afterLoad": d.handlers.afterLoad
                    }), d.FooBox.modal instanceof b.Modal && b.isjQuery(d.FooBox.modal.element) && d.FooBox.modal.element.undelegate("mouseenter.captions mouseleave.captions").find(".fbx-item-current, .fbx-item-next").unbind("click.captions")
                 },
                 initialized: function (a) {
                    d.handlers.unbind(), a.fb.options.captions.enabled === !0 && (a.fb.instance.element.bind({
                       "foobox.beforeLoad": d.handlers.beforeLoad,
                       "foobox.afterLoad": d.handlers.afterLoad,
                       "foobox.close": d.handlers.close
                    }), -1 === a.fb.options.modalClass.indexOf("fbx-caption-toggle-only") && a.fb.modal.find(".fbx-item-current, .fbx-item-next").bind("click.captions", d.handlers.toggleCaptions), a.fb.options.captions.onlyShowOnHover === !0 && a.fb.modal.delegate(".fbx-inner:not(:has(.fbx-item-error))", "mouseenter.captions", d.handlers.mouseenter).delegate(".fbx-inner:not(:has(.fbx-item-error))", "mouseleave.captions", d.handlers.mouseleave))
                 },
                 toggleCaptions: function (b) {
                    if (a(b.target).is("img") || a(b.target).is(".fbx-close-caption") || a(b.target).is(".fbx-open-caption")) {
                       var c = d.FooBox.items.current(),
                               e = d.FooBox.modal.element;
                       "image" !== c.type || e.hasClass("fbx-error") || (b.preventDefault(), e.find(".fbx-caption").is(".fbx-fade-caption, .fbx-slide-caption, .fbx-hide-caption") ? (e.removeClass("fbx-captions-hidden"), d.show()) : (e.addClass("fbx-captions-hidden"), d.hide()))
                    }
                 },
                 mouseenter: function () {
                    d.timers.hover.start(function () {
                       d.show()
                    }, d.FooBox.options.captions.hoverDelay)
                 },
                 mouseleave: function () {
                    d.timers.hover.start(function () {
                       d.hide()
                    }, d.FooBox.options.captions.hoverDelay)
                 },
                 setupHtml: function (b) {
                    var c = a("<div/>", {
                       "class": "fbx-caption"
                    }),
                            e = a("<a/>", {
                               "class": "fbx-open-caption",
                               html: "&hellip;"
                            }).bind("click.captions", d.handlers.toggleCaptions);
                    "string" == typeof b.fb.options.modalClass && -1 != b.fb.options.modalClass.indexOf("fbx-sticky-caption") ? b.fb.modal.append(c, e) : (b.fb.modal.find(".fbx-stage").append(c), b.fb.modal.find(".fbx-inner").append(e))
                 },
                 setupOptions: function (a) {
                    a.fb.modal.find(".fbx-caption").addClass(d.animation())
                 },
                 close: function (a) {
                    1 != a.fb.options.captions.onlyShowOnHover && a.fb.modal.find(".fbx-caption").addClass(d.animation())
                 },
                 beforeLoad: function (a) {
                    1 != a.fb.options.captions.onlyShowOnHover && a.fb.modal.find(".fbx-caption").addClass(d.animation())
                 },
                 afterLoad: function (a) {
                    var b = a.fb.item;
                    return !b || b.error || b.captionLoaded || (a.fb.instance.raise("foobox.alterCaption", {
                       element: a.fb.element,
                       item: b
                    }), b.captionLoaded = !0), 1 == a.fb.options.captions.onlyShowOnHover ? void d.update() : void(0 == a.fb.options.captions.onlyShowOnClick && d.show())
                 },
                 onError: function (a) {
                    a.fb.modal.find(".fbx-caption").addClass(d.animation())
                 },
                 parseItem: function (c) {
                    var e = c.fb.options.captions;
                    if (c.fb.item.captions && 0 != e.enabled) {
                       var f, g, h = "";
                       if (null != c.fb.element) {
                          var i = a(c.fb.element).data("titleSource") || a(c.fb.instance.element).data("titleSource") || e.titleSource,
                                  j = a(c.fb.element).data("descSource") || a(c.fb.instance.element).data("descSource") || e.descSource;
                          f = c.fb.element.data("captionTitle") || c.fb.element.data("title") || d.text(c.fb.element, i), g = c.fb.element.data("captionDesc") || c.fb.element.data("description") || d.text(c.fb.element, j)
                       } else
                          f = c.fb.item.title, g = c.fb.item.description;
                       f = null == f || "undefined" == typeof f ? "" : f + "", g = null == g || "undefined" == typeof g ? "" : g + "", f && f == g && (g = null), h = "string" == typeof f && f.length > 0 ? b.format('<div class="fbx-caption-title">{0}</div>', f) : h, h = "string" == typeof g && g.length > 0 ? h + b.format('<div class="fbx-caption-desc">{0}</div>', g) : h, c.fb.item.title = f, c.fb.item.description = g, c.fb.item.caption = h, c.fb.instance.raise("foobox.createCaption", {
                          element: c.fb.element,
                          item: c.fb.item
                       })
                    }
                 }
              }, this.text = function (b, c) {
                 var e;
                 switch (c) {
                    case "find":
                       e = a.trim(b.data("enviraCaption") || b.data("title") || b.attr("title") || b.find("img:first").data("title") || b.find("img:first").data("alt") || b.find("img:first").attr("title") || b.find("img:first").attr("alt"));
                       break;
                    case "image_find":
                       e = a.trim(b.find("img:first").data("title") || b.find("img:first").data("alt") || b.find("img:first").attr("title") || b.find("img:first").attr("alt"));
                       break;
                    case "image":
                       e = a.trim(b.find("img:first").data("title") || b.find("img:first").attr("title"));
                       break;
                    case "image_alt":
                       e = a.trim(b.find("img:first").data("alt") || b.find("img:first").attr("alt"));
                       break;
                    case "anchor":
                       e = a.trim(b.data("enviraCaption") || b.data("title") || b.attr("title"));
                       break;
                    default:
                       e = null
                 }
                 return d.FooBox.options.captions.prettify && (e = d.prettifier(e)), e
              }, this.animation = function () {
                 switch (d.FooBox.options.captions.animation) {
                    case "fade":
                       return "fbx-fade-caption";
                    case "slide":
                       return "fbx-slide-caption";
                    default:
                       return "fbx-hide-caption"
                 }
              }, this.hide = function () {
                 var a = d.FooBox.items.current(),
                         b = d.FooBox.modal.element.find(".fbx-caption");
                 return d.FooBox.options.captions.enabled && a.captions && "string" == typeof a.caption && 0 != a.caption.length ? (b.addClass(d.animation()), void d.FooBox.raise("foobox.captionsHide", {
                    item: a
                 })) : void b.addClass("fbx-hide-caption")
              }, this.show = function () {
                 var a = d.FooBox,
                         c = a.items.current(),
                         e = a.modal.element.find(".fbx-caption");
                 return !a.options.captions.enabled || !c.captions || "string" != typeof c.caption || 0 == c.caption.length || a.modal.element.hasClass("fbx-captions-hidden") || b.isjQuery(c.element) && c.element.hasClass("no-captions") ? void e.addClass("fbx-hide-caption") : (d.update(), e.removeClass("fbx-fade-caption fbx-slide-caption fbx-hide-caption"), void d.FooBox.raise("foobox.captionsShow", {
                    item: c
                 }))
              }, this.update = function () {
                 var c = d.FooBox.items.current(),
                         e = d.FooBox.modal.element.find(".fbx-caption");
                 e.html(c.caption).find('a[href^="#"]').filter(function () {
                    var c = a(this).attr("href"),
                            d = a(c),
                            e = d.data("fbx_instance") || d.data("fbx_p_instance");
                    return d.length > 0 && e instanceof b.Instance ? (a(this).data("hrefTarget", d.get(0)), !0) : !1
                 }).unbind("click.captions").bind("click.captions", function (c) {
                    c.preventDefault();
                    var e = a(this).data("hrefTarget"),
                            f = a(e).data("fbx_instance") || a(e).data("fbx_p_instance");
                    return f instanceof b.Instance && (d.FooBox.modal.close(), f.items.indexes.set(e.index), f.modal.show()), !1
                 }), a("<a/>", {
                    "class": "fbx-close-caption",
                    html: "&times;"
                 }).bind("click.captions", d.handlers.toggleCaptions).prependTo(e)
              }, this.prettifier = function (a) {
                 return "string" != typeof a ? null : (a = a.replace(/\s*-\d+/g, "").replace(/\s*_\d+/g, "").replace(/-/g, " ").replace(/_/g, " "), a = a.replace(/\w\S*/g, function (a) {
                    return -1 != a.indexOf("#") ? a : a.charAt(0).toUpperCase() + a.substr(1).toLowerCase()
                 }))
              }
           }, b.addons.register(b.Captions, c)
        }(jQuery, window.FooBox),
        function (a, b) {
           var c = {
              wordpress: {
                 enabled: !1
              }
           };
           b.Wordpress = function (c) {
              this.FooBox = c;
              var d = this;
              this.preinit = function (a) {
                 d.handlers.unbind(!0), a.bind("foobox.createCaption", d.handlers.onCreateCaption)
              }, this.destroy = function () {
                 d.handlers.unbind(!0)
              }, this.handlers = {
                 unbind: function (a) {
                    a = a || !1, a && d.FooBox.element.unbind("foobox.createCaption", d.handlers.onCreateCaption)
                 },
                 onCreateCaption: function (c) {
                    var d = c.fb.options,
                            e = c.fb.instance.element,
                            f = c.fb.item.element,
                            g = "",
                            h = c.fb.item.title,
                            i = c.fb.item.description;
                    if (1 == d.wordpress.enabled && b.isjQuery(f)) {
                       var j = f.data("captionTitle") || f.data("title"),
                               k = f.data("captionDesc") || f.data("description");
                       if (e.hasClass("gallery"))
                          d.captions.overrideTitle === !1 && (h = j || f.parents(".gallery-item:first").find(".wp-caption-text:first").html() || f.parents(".gallery-item:first").find(".gallery-caption:first").html() || h || ""), d.captions.overrideDesc === !1 && (i = k || f.find("img").attr("alt") || i || "");
                       else if (e.hasClass("wp-caption") || f.hasClass("wp-caption"))
                          d.captions.overrideTitle === !1 && (h = j || f.find("img").attr("title") || f.parents(".wp-caption:first").find(".wp-caption-text:first").html() || h || ""), d.captions.overrideDesc === !1 && (i = k || f.find("img").attr("alt") || i || "");
                       else if (f.parents(".wp-caption:first").length > 0)
                          d.captions.overrideTitle === !1 && (h = j || f.parents(".wp-caption:first").find("img").attr("title") || f.parents(".wp-caption:first").find(".wp-caption-text:first").html() || h || ""), d.captions.overrideDesc === !1 && (i = k || f.parents(".wp-caption:first").find("img").attr("alt") || i || "");
                       else {
                          if (!e.hasClass("tiled-gallery"))
                             return;
                          d.captions.overrideTitle === !1 && (h = j || f.parents(".tiled-gallery-item:first").find(".tiled-gallery-caption").html() || f.find("img").data("image-title") || f.find("img").attr("title") || h || ""), d.captions.overrideDesc === !1 && (i = k || a.trim(f.find("img").data("image-description")).replace(/(^<p>)|(<\/p>$)/gi, "") || i || "")
                       }
                       h += "", i += "", h = h || "", i = i || "";
                       var l = a("<div/>"),
                               m = l.html(h).text(),
                               n = l.html(i).text();
                       (a.trim(h) == a.trim(i) || m == n) && (i = null), g = "string" == typeof h && h.length > 0 ? b.format('<div class="fbx-caption-title">{0}</div>', h) : g, g = "string" == typeof i && i.length > 0 ? g + b.format('<div class="fbx-caption-desc">{0}</div>', i) : g, c.fb.item.title = h, c.fb.item.description = i, c.fb.item.caption = g
                    }
                 }
              }
           }, b.addons.register(b.Wordpress, c)
        }(jQuery, window.FooBox),
        function (a, b) {
           var c = {
              pan: {
                 enabled: !0,
                 showOverview: !0,
                 position: "fbx-top-right"
              }
           };
           b.Pan = function (c) {
              this.FooBox = c;
              var d, e, f, g, h = this,
                      i = !1,
                      j = !1,
                      k = null,
                      l = null,
                      m = null,
                      n = null,
                      o = null,
                      p = 0;
              this.preinit = function (a) {
                 h.handlers.unbind(!0), a.on({
                    "foobox.initialized foobox.reinitialized": h.handlers.initialized
                 })
              }, this.destroy = function () {
                 h.handlers.unbind(!0)
              }, this.setOverview = function () {
                 var a = parseInt(n.css("max-width")),
                         b = parseInt(n.css("max-height")),
                         c = a / k.width,
                         d = b / k.height;
                 p = c > d ? d : c;
                 var e = k.width * p,
                         f = k.height * p;
                 n.width(e).height(f).css("background-image", "url(" + k.url + ")")
              }, this.setViewport = function () {
                 var a = m.width(),
                         b = m.height(),
                         c = a * p,
                         d = b * p;
                 o.width(c).height(d)
              }, this.disableCaptionImageClick = function () {
                 var a = h.FooBox.modal.element,
                         c = b.objects.get("addons", h.FooBox, function (a) {
                            return a instanceof b.Captions
                         });
                 c && a.find(".fbx-item-current, .fbx-item-next").unbind("click.captions", c.handlers.toggleCaptions)
              }, this.enableCaptionImageClick = function () {
                 var a = h.FooBox.modal.element,
                         c = b.objects.get("addons", h.FooBox, function (a) {
                            return a instanceof b.Captions
                         });
                 c && a.find(".fbx-item-current, .fbx-item-next").bind("click.captions", c.handlers.toggleCaptions)
              }, this.handlers = {
                 unbind: function (a) {
                    a = a || !1, a && h.FooBox.element.off({
                       "foobox.initialized foobox.reinitialized": h.handlers.initialized
                    }), h.FooBox.element.off({
                       "foobox.afterLoad": h.handlers.onAfterLoad,
                       "foobox.showOverflow": h.handlers.onShowOverflow,
                       "foobox.hideOverflow foobox.beforeLoad": h.handlers.onHideOverflow
                    }), h.FooBox.modal instanceof b.Modal && b.isjQuery(h.FooBox.modal.element) && h.FooBox.modal.element.find(".fbx-stage").off({
                       mousedown: h.handlers.onMouseDown,
                       mousemove: h.handlers.onMouseMove,
                       mouseup: h.handlers.onMouseUp
                    }).removeClass("fbx-pannable fbx-panning")
                 },
                 initialized: function (a) {
                    h.handlers.unbind(), a.fb.options.pan.enabled === !0 && h.FooBox.element.on({
                       "foobox.close": h.handlers.onMouseUp,
                       "foobox.afterLoad": h.handlers.onAfterLoad,
                       "foobox.showOverflow": h.handlers.onShowOverflow,
                       "foobox.hideOverflow foobox.beforeLoad": h.handlers.onHideOverflow
                    })
                 },
                 onAfterLoad: function (a) {
                    i === !0 && "image" == a.fb.item.handler.type && (h.setOverview(), h.setViewport())
                 },
                 onShowOverflow: function (b) {
                    "image" == b.fb.item.handler.type && (i === !0 ? (h.setOverview(), h.setViewport()) : (i = !0, h.disableCaptionImageClick(), k = b.fb.item, m = h.FooBox.modal.element.addClass("fbx-pannable-item").find(".fbx-stage").on({
                       mousedown: h.handlers.onMouseDown,
                       mousemove: h.handlers.onMouseMove,
                       "mouseup mouseleave": h.handlers.onMouseUp
                    }).addClass("fbx-pannable"), l = b.fb.container, b.fb.options.pan.showOverview === !0 && (n = a("<div/>", {
                       "class": "fbx-pan-overview"
                    }).addClass(b.fb.options.pan.position).on("click", h.handlers.onOverviewClick).appendTo(m), o = a("<div/>", {
                       "class": "fbx-pan-viewport"
                    }).appendTo(n), l.on("scroll", h.handlers.onScroll), h.setOverview(), h.setViewport())))
                 },
                 onHideOverflow: function (a) {
                    i === !0 && (i = !1, h.enableCaptionImageClick(), a.fb.options.pan.showOverview === !0 && n.remove(), l.off("scroll", h.handlers.onScroll), m.off({
                       mousedown: h.handlers.onMouseDown,
                       mousemove: h.handlers.onMouseMove,
                       "mouseup mouseleave": h.handlers.onMouseUp
                    }).removeClass("fbx-pannable fbx-panning"), h.FooBox.modal.element.removeClass("fbx-pannable-item"))
                 },
                 onMouseDown: function (a) {
                    if (i === !0) {
                       a.preventDefault(), m.addClass("fbx-panning");
                       var b = l.get(0);
                       j = !0, d = a.pageX, e = a.pageY, f = b.scrollLeft, g = b.scrollTop
                    }
                 },
                 onMouseMove: function (a) {
                    if (j === !0 && i === !0) {
                       var b = l.get(0);
                       b.scrollLeft = f - (a.pageX - d), b.scrollTop = g - (a.pageY - e)
                    }
                 },
                 onMouseUp: function () {
                    i === !0 && (j = !1, m.removeClass("fbx-panning"), d = 0, e = 0, f = 0, g = 0)
                 },
                 onScroll: function () {
                    var a = l.get(0),
                            b = a.scrollTop / k.height * 100,
                            c = a.scrollLeft / k.width * 100;
                    o.css({
                       top: b + "%",
                       left: c + "%"
                    })
                 },
                 onOverviewClick: function (b) {
                    var c = a(this).offset(),
                            d = (b.pageX - c.left) / p,
                            e = (b.pageY - c.top) / p,
                            f = d - l.width() / 2,
                            g = e - l.height() / 2;
                    l.animate({
                       scrollTop: g,
                       scrollLeft: f
                    }, 300)
                 }
              }
           }, b.addons.register(b.Pan, c)
        }(jQuery, window.FooBox),
        function (a, b) {
           var c = {
              swipe: {
                 enabled: !0,
                 min: 80
              }
           };
           b.Swipe = function (a) {
              this.FooBox = a, this.isMoving = !1;
              var c, d = this;
              this.preinit = function (a) {
                 d.handlers.unbind(!0), a.bind("foobox.initialized foobox.reinitialized", d.handlers.initialized)
              }, this.destroy = function () {
                 d.handlers.unbind(!0)
              }, this.handlers = {
                 unbind: function (a) {
                    a = a || !1, a && d.FooBox.element.unbind("foobox.initialized foobox.reinitialized", d.handlers.initialized), d.FooBox.modal instanceof b.Modal && b.isjQuery(d.FooBox.modal.element) && d.FooBox.modal.element.unbind({
                       touchstart: d.handlers.onTouchStart,
                       touchmove: d.handlers.onTouchMove
                    })
                 },
                 initialized: function (a) {
                    d.handlers.unbind(), a.fb.options.swipe.enabled === !0 && a.fb.modal.bind("touchstart", d.handlers.onTouchStart)
                 },
                 onTouchStart: function (a) {
                    var b = a.originalEvent.touches || a.touches;
                    1 == b.length && d.FooBox.items.multiple() && (c = b[0].pageX, d.isMoving = !0, d.FooBox.modal.element.bind("touchmove", d.handlers.onTouchMove))
                 },
                 onTouchMove: function (a) {
                    if (d.isMoving) {
                       var b = a.originalEvent.touches || a.touches,
                               e = b[0].pageX,
                               f = c - e;
                       Math.abs(f) >= d.FooBox.options.swipe.min && (d.cancelTouch(), f > 0 ? (d.FooBox.raise("foobox.swipeRight"), d.FooBox.modal.next()) : (d.FooBox.raise("foobox.swipeLeft"), d.FooBox.modal.prev()))
                    }
                 }
              }, this.cancelTouch = function () {
                 d.FooBox.modal.element.unbind("touchmove", d.handlers.onTouchMove), c = null, d.isMoving = !1
              }
           }, b.addons.register(b.Swipe, c)
        }(jQuery, window.FooBox);