<?php
class Socials_Ignited_Fontawesome_Convert_4_to_5 {
	public static $fa5_prefixes = array(
		'fas', // Solid
		'far', // Regular
		'fal', // Light
		'fab', // Brands
	);

	public static function convert( $icon_4, $return = 'string' ) {
		if ( self::is_fa5( $icon_4 ) ) {
			return $icon_4;
		}

		$icons = explode( ' ', $icon_4 );

		// Remove 'fa' classes.
		$fa_found = array_keys( $icons, 'fa', true );
		foreach ( $fa_found as $key ) {
			unset( $icons[ $key ] );
		}

		$new_icons = array();

		foreach ( $icons as $icon ) {
			if ( array_key_exists( $icon, self::$icons_4_5 ) ) {
				$new_icons[] = self::$icons_4_5[ $icon ];
			}
		}

		if ( 'string' === $return ) {
			return implode( ' ', $new_icons );
		}

		return $new_icons;
	}

	public static function is_fa5( $icon ) {
		$icon_parts = explode( ' ', $icon );

		foreach ( self::$fa5_prefixes as $prefix ) {
			if ( in_array( $prefix, $icon_parts, true ) ) {
				return true;
			}
		}

		return false;
	}

	public static $icons_4_5 = array(
		'fa-500px'                               => 'fab fa-500px',
		'fa-wheelchair-alt'                      => 'fab fa-accessible-icon',
		'fa-adn'                                 => 'fab fa-adn',
		'fa-amazon'                              => 'fab fa-amazon',
		'fa-android'                             => 'fab fa-android',
		'fa-angellist'                           => 'fab fa-angellist',
		'fa-apple'                               => 'fab fa-apple',
		'fa-bandcamp'                            => 'fab fa-bandcamp',
		'fa-behance'                             => 'fab fa-behance',
		'fa-behance-square'                      => 'fab fa-behance-square',
		'fa-bitbucket-square'                    => 'fab fa-bitbucket',
		'fa-bitbucket'                           => 'fab fa-bitbucket',
		'fa-black-tie'                           => 'fab fa-black-tie',
		'fa-bluetooth'                           => 'fab fa-bluetooth',
		'fa-bluetooth-b'                         => 'fab fa-bluetooth-b',
		'fa-bitcoin'                             => 'fab fa-btc',
		'fa-btc'                                 => 'fab fa-btc',
		'fa-buysellads'                          => 'fab fa-buysellads',
		'fa-cc-amex'                             => 'fab fa-cc-amex',
		'fa-cc-diners-club'                      => 'fab fa-cc-diners-club',
		'fa-cc-discover'                         => 'fab fa-cc-discover',
		'fa-cc-jcb'                              => 'fab fa-cc-jcb',
		'fa-cc-mastercard'                       => 'fab fa-cc-mastercard',
		'fa-cc-paypal'                           => 'fab fa-cc-paypal',
		'fa-cc-stripe'                           => 'fab fa-cc-stripe',
		'fa-cc-visa'                             => 'fab fa-cc-visa',
		'fa-chrome'                              => 'fab fa-chrome',
		'fa-codepen'                             => 'fab fa-codepen',
		'fa-codiepie'                            => 'fab fa-codiepie',
		'fa-connectdevelop'                      => 'fab fa-connectdevelop',
		'fa-contao'                              => 'fab fa-contao',
		'fa-creative-commons'                    => 'fab fa-creative-commons',
		'fa-css3'                                => 'fab fa-css3',
		'fa-dashcube'                            => 'fab fa-dashcube',
		'fa-delicious'                           => 'fab fa-delicious',
		'fa-deviantart'                          => 'fab fa-deviantart',
		'fa-digg'                                => 'fab fa-digg',
		'fa-dribbble'                            => 'fab fa-dribbble',
		'fa-dropbox'                             => 'fab fa-dropbox',
		'fa-drupal'                              => 'fab fa-drupal',
		'fa-edge'                                => 'fab fa-edge',
		'fa-empire'                              => 'fab fa-empire',
		'fa-ge'                                  => 'fab fa-empire',
		'fa-envira'                              => 'fab fa-envira',
		'fa-etsy'                                => 'fab fa-etsy',
		'fa-expeditedssl'                        => 'fab fa-expeditedssl',
		'fa-facebook-official'                   => 'fab fa-facebook',
		'fa-facebook'                            => 'fab fa-facebook-f',
		'fa-facebook-f'                          => 'fab fa-facebook-f',
		'fa-facebook-square'                     => 'fab fa-facebook-square',
		'fa-firefox'                             => 'fab fa-firefox',
		'fa-first-order'                         => 'fab fa-first-order',
		'fa-flickr'                              => 'fab fa-flickr',
		'fa-fa'                                  => 'fab fa-font-awesome',
		'fa-meanpath'                            => 'fab fa-font-awesome',
		'fa-font-awesome'                        => 'fab fa-font-awesome',
		'fa-fonticons'                           => 'fab fa-fonticons',
		'fa-fort-awesome'                        => 'fab fa-fort-awesome',
		'fa-forumbee'                            => 'fab fa-forumbee',
		'fa-foursquare'                          => 'fab fa-foursquare',
		'fa-free-code-camp'                      => 'fab fa-free-code-camp',
		'fa-get-pocket'                          => 'fab fa-get-pocket',
		'fa-gg'                                  => 'fab fa-gg',
		'fa-gg-circle'                           => 'fab fa-gg-circle',
		'fa-git'                                 => 'fab fa-git',
		'fa-git-square'                          => 'fab fa-git-square',
		'fa-github'                              => 'fab fa-github',
		'fa-github-alt'                          => 'fab fa-github-alt',
		'fa-github-square'                       => 'fab fa-github-square',
		'fa-gitlab'                              => 'fab fa-gitlab',
		'fa-glide'                               => 'fab fa-glide',
		'fa-glide-g'                             => 'fab fa-glide-g',
		'fa-google'                              => 'fab fa-google',
		'fa-google-plus-circle'                  => 'fab fa-google-plus',
		'fa-google-plus-official'                => 'fab fa-google-plus',
		'fa-google-plus'                         => 'fab fa-google-plus-g',
		'fa-google-plus-square'                  => 'fab fa-google-plus-square',
		'fa-google-wallet'                       => 'fab fa-google-wallet',
		'fa-gratipay'                            => 'fab fa-gratipay',
		'fa-gittip'                              => 'fab fa-gratipay',
		'fa-grav'                                => 'fab fa-grav',
		'fa-yc-square'                           => 'fab fa-hacker-news',
		'fa-hacker-news'                         => 'fab fa-hacker-news',
		'fa-y-combinator-square'                 => 'fab fa-hacker-news',
		'fa-houzz'                               => 'fab fa-houzz',
		'fa-html5'                               => 'fab fa-html5',
		'fa-imdb'                                => 'fab fa-imdb',
		'fa-instagram'                           => 'fab fa-instagram',
		'fa-internet-explorer'                   => 'fab fa-internet-explorer',
		'fa-ioxhost'                             => 'fab fa-ioxhost',
		'fa-joomla'                              => 'fab fa-joomla',
		'fa-jsfiddle'                            => 'fab fa-jsfiddle',
		'fa-lastfm'                              => 'fab fa-lastfm',
		'fa-lastfm-square'                       => 'fab fa-lastfm-square',
		'fa-leanpub'                             => 'fab fa-leanpub',
		'fa-linkedin-square'                     => 'fab fa-linkedin',
		'fa-linkedin'                            => 'fab fa-linkedin-in',
		'fa-linode'                              => 'fab fa-linode',
		'fa-linux'                               => 'fab fa-linux',
		'fa-maxcdn'                              => 'fab fa-maxcdn',
		'fa-medium'                              => 'fab fa-medium',
		'fa-meetup'                              => 'fab fa-meetup',
		'fa-mixcloud'                            => 'fab fa-mixcloud',
		'fa-modx'                                => 'fab fa-modx',
		'fa-odnoklassniki'                       => 'fab fa-odnoklassniki',
		'fa-odnoklassniki-square'                => 'fab fa-odnoklassniki-square',
		'fa-opencart'                            => 'fab fa-opencart',
		'fa-openid'                              => 'fab fa-openid',
		'fa-opera'                               => 'fab fa-opera',
		'fa-optin-monster'                       => 'fab fa-optin-monster',
		'fa-pagelines'                           => 'fab fa-pagelines',
		'fa-paypal'                              => 'fab fa-paypal',
		'fa-pied-piper'                          => 'fab fa-pied-piper',
		'fa-pied-piper-alt'                      => 'fab fa-pied-piper-alt',
		'fa-pied-piper-pp'                       => 'fab fa-pied-piper-pp',
		'fa-pinterest'                           => 'fab fa-pinterest',
		'fa-pinterest-p'                         => 'fab fa-pinterest-p',
		'fa-pinterest-square'                    => 'fab fa-pinterest-square',
		'fa-product-hunt'                        => 'fab fa-product-hunt',
		'fa-qq'                                  => 'fab fa-qq',
		'fa-quora'                               => 'fab fa-quora',
		'fa-ravelry'                             => 'fab fa-ravelry',
		'fa-rebel'                               => 'fab fa-rebel',
		'fa-resistance'                          => 'fab fa-rebel',
		'fa-ra'                                  => 'fab fa-rebel',
		'fa-reddit'                              => 'fab fa-reddit',
		'fa-reddit-alien'                        => 'fab fa-reddit-alien',
		'fa-reddit-square'                       => 'fab fa-reddit-square',
		'fa-renren'                              => 'fab fa-renren',
		'fa-safari'                              => 'fab fa-safari',
		'fa-scribd'                              => 'fab fa-scribd',
		'fa-eercast'                             => 'fab fa-sellcast',
		'fa-sellsy'                              => 'fab fa-sellsy',
		'fa-shirtsinbulk'                        => 'fab fa-shirtsinbulk',
		'fa-simplybuilt'                         => 'fab fa-simplybuilt',
		'fa-skyatlas'                            => 'fab fa-skyatlas',
		'fa-skype'                               => 'fab fa-skype',
		'fa-slack'                               => 'fab fa-slack',
		'fa-slideshare'                          => 'fab fa-slideshare',
		'fa-snapchat'                            => 'fab fa-snapchat',
		'fa-snapchat-ghost'                      => 'fab fa-snapchat-ghost',
		'fa-snapchat-square'                     => 'fab fa-snapchat-square',
		'fa-soundcloud'                          => 'fab fa-soundcloud',
		'fa-spotify'                             => 'fab fa-spotify',
		'fa-stack-exchange'                      => 'fab fa-stack-exchange',
		'fa-stack-overflow'                      => 'fab fa-stack-overflow',
		'fa-steam'                               => 'fab fa-steam',
		'fa-steam-square'                        => 'fab fa-steam-square',
		'fa-stumbleupon'                         => 'fab fa-stumbleupon',
		'fa-stumbleupon-circle'                  => 'fab fa-stumbleupon-circle',
		'fa-superpowers'                         => 'fab fa-superpowers',
		'fa-telegram'                            => 'fab fa-telegram',
		'fa-tencent-weibo'                       => 'fab fa-tencent-weibo',
		'fa-themeisle'                           => 'fab fa-themeisle',
		'fa-trello'                              => 'fab fa-trello',
		'fa-tripadvisor'                         => 'fab fa-tripadvisor',
		'fa-tumblr'                              => 'fab fa-tumblr',
		'fa-tumblr-square'                       => 'fab fa-tumblr-square',
		'fa-twitch'                              => 'fab fa-twitch',
		'fa-twitter'                             => 'fab fa-twitter',
		'fa-twitter-square'                      => 'fab fa-twitter-square',
		'fa-usb'                                 => 'fab fa-usb',
		'fa-viacoin'                             => 'fab fa-viacoin',
		'fa-viadeo'                              => 'fab fa-viadeo',
		'fa-viadeo-square'                       => 'fab fa-viadeo-square',
		'fa-vimeo-square'                        => 'fab fa-vimeo-square',
		'fa-vimeo'                               => 'fab fa-vimeo-v',
		'fa-vine'                                => 'fab fa-vine',
		'fa-vk'                                  => 'fab fa-vk',
		'fa-weibo'                               => 'fab fa-weibo',
		'fa-weixin'                              => 'fab fa-weixin',
		'fa-wechat'                              => 'fab fa-weixin',
		'fa-whatsapp'                            => 'fab fa-whatsapp',
		'fa-wikipedia-w'                         => 'fab fa-wikipedia-w',
		'fa-windows'                             => 'fab fa-windows',
		'fa-wordpress'                           => 'fab fa-wordpress',
		'fa-wpbeginner'                          => 'fab fa-wpbeginner',
		'fa-wpexplorer'                          => 'fab fa-wpexplorer',
		'fa-wpforms'                             => 'fab fa-wpforms',
		'fa-xing'                                => 'fab fa-xing',
		'fa-xing-square'                         => 'fab fa-xing-square',
		'fa-yc'                                  => 'fab fa-y-combinator',
		'fa-y-combinator'                        => 'fab fa-y-combinator',
		'fa-yahoo'                               => 'fab fa-yahoo',
		'fa-yelp'                                => 'fab fa-yelp',
		'fa-yoast'                               => 'fab fa-yoast',
		'fa-youtube-play'                        => 'fab fa-youtube',
		'fa-youtube'                             => 'fab fa-youtube',
		'fa-youtube-square'                      => 'fab fa-youtube-square',
		'fa-address-book-o'                      => 'far fa-address-book',
		'fa-vcard-o'                             => 'far fa-address-card',
		'fa-address-card-o'                      => 'far fa-address-card',
		'fa-arrow-circle-o-down'                 => 'far fa-arrow-alt-circle-down',
		'fa-arrow-circle-o-left'                 => 'far fa-arrow-alt-circle-left',
		'fa-arrow-circle-o-right'                => 'far fa-arrow-alt-circle-right',
		'fa-arrow-circle-o-up'                   => 'far fa-arrow-alt-circle-up',
		'fa-bell-o'                              => 'far fa-bell',
		'fa-bell-slash-o'                        => 'far fa-bell-slash',
		'fa-bookmark-o'                          => 'far fa-bookmark',
		'fa-building-o'                          => 'far fa-building',
		'fa-calendar-o'                          => 'far fa-calendar',
		'fa-calendar-check-o'                    => 'far fa-calendar-check',
		'fa-calendar-minus-o'                    => 'far fa-calendar-minus',
		'fa-calendar-plus-o'                     => 'far fa-calendar-plus',
		'fa-calendar-times-o'                    => 'far fa-calendar-times',
		'fa-caret-square-o-down'                 => 'far fa-caret-square-down',
		'fa-toggle-down'                         => 'far fa-caret-square-down',
		'fa-caret-square-o-left'                 => 'far fa-caret-square-left',
		'fa-toggle-left'                         => 'far fa-caret-square-left',
		'fa-toggle-right'                        => 'far fa-caret-square-right',
		'fa-caret-square-o-right'                => 'far fa-caret-square-right',
		'fa-caret-square-o-up'                   => 'far fa-caret-square-up',
		'fa-toggle-up'                           => 'far fa-caret-square-up',
		'fa-bar-chart'                           => 'far fa-chart-bar',
		'fa-bar-chart-o'                         => 'far fa-chart-bar',
		'fa-check-circle-o'                      => 'far fa-check-circle',
		'fa-check-square-o'                      => 'far fa-check-square',
		'fa-circle-thin'                         => 'far fa-circle',
		'fa-circle-o'                            => 'far fa-circle',
		'fa-paste'                               => 'far fa-clipboard',
		'fa-clipboard'                           => 'far fa-clipboard',
		'fa-clock-o'                             => 'far fa-clock',
		'fa-clone'                               => 'far fa-clone',
		'fa-cc'                                  => 'far fa-closed-captioning',
		'fa-comment-o'                           => 'far fa-comment',
		'fa-commenting-o'                        => 'far fa-comment-dots',
		'fa-comments-o'                          => 'far fa-comments',
		'fa-compass'                             => 'far fa-compass',
		'fa-files-o'                             => 'far fa-copy',
		'fa-copyright'                           => 'far fa-copyright',
		'fa-credit-card'                         => 'far fa-credit-card',
		'fa-dot-circle-o'                        => 'far fa-dot-circle',
		'fa-pencil-square-o'                     => 'far fa-edit',
		'fa-envelope-o'                          => 'far fa-envelope',
		'fa-envelope-open-o'                     => 'far fa-envelope-open',
		'fa-eye'                                 => 'far fa-eye',
		'fa-eye-slash'                           => 'far fa-eye-slash',
		'fa-file-o'                              => 'far fa-file',
		'fa-file-text-o'                         => 'far fa-file-alt',
		'fa-file-zip-o'                          => 'far fa-file-archive',
		'fa-file-archive-o'                      => 'far fa-file-archive',
		'fa-file-sound-o'                        => 'far fa-file-audio',
		'fa-file-audio-o'                        => 'far fa-file-audio',
		'fa-file-code-o'                         => 'far fa-file-code',
		'fa-file-excel-o'                        => 'far fa-file-excel',
		'fa-file-image-o'                        => 'far fa-file-image',
		'fa-file-photo-o'                        => 'far fa-file-image',
		'fa-file-picture-o'                      => 'far fa-file-image',
		'fa-file-pdf-o'                          => 'far fa-file-pdf',
		'fa-file-powerpoint-o'                   => 'far fa-file-powerpoint',
		'fa-file-movie-o'                        => 'far fa-file-video',
		'fa-file-video-o'                        => 'far fa-file-video',
		'fa-file-word-o'                         => 'far fa-file-word',
		'fa-flag-o'                              => 'far fa-flag',
		'fa-folder-o'                            => 'far fa-folder',
		'fa-folder-open-o'                       => 'far fa-folder-open',
		'fa-frown-o'                             => 'far fa-frown',
		'fa-soccer-ball-o'                       => 'far fa-futbol',
		'fa-futbol-o'                            => 'far fa-futbol',
		'fa-diamond'                             => 'far fa-gem',
		'fa-hand-lizard-o'                       => 'far fa-hand-lizard',
		'fa-hand-stop-o'                         => 'far fa-hand-paper',
		'fa-hand-paper-o'                        => 'far fa-hand-paper',
		'fa-hand-peace-o'                        => 'far fa-hand-peace',
		'fa-hand-o-down'                         => 'far fa-hand-point-down',
		'fa-hand-o-left'                         => 'far fa-hand-point-left',
		'fa-hand-o-right'                        => 'far fa-hand-point-right',
		'fa-hand-o-up'                           => 'far fa-hand-point-up',
		'fa-hand-pointer-o'                      => 'far fa-hand-pointer',
		'fa-hand-grab-o'                         => 'far fa-hand-rock',
		'fa-hand-rock-o'                         => 'far fa-hand-rock',
		'fa-hand-scissors-o'                     => 'far fa-hand-scissors',
		'fa-hand-spock-o'                        => 'far fa-hand-spock',
		'fa-handshake-o'                         => 'far fa-handshake',
		'fa-hdd-o'                               => 'far fa-hdd',
		'fa-heart-o'                             => 'far fa-heart',
		'fa-hospital-o'                          => 'far fa-hospital',
		'fa-hourglass-o'                         => 'far fa-hourglass',
		'fa-id-badge'                            => 'far fa-id-badge',
		'fa-drivers-license-o'                   => 'far fa-id-card',
		'fa-id-card-o'                           => 'far fa-id-card',
		'fa-photo'                               => 'far fa-image',
		'fa-image'                               => 'far fa-image',
		'fa-picture-o'                           => 'far fa-image',
		'fa-keyboard-o'                          => 'far fa-keyboard',
		'fa-lemon-o'                             => 'far fa-lemon',
		'fa-life-saver'                          => 'far fa-life-ring',
		'fa-support'                             => 'far fa-life-ring',
		'fa-life-ring'                           => 'far fa-life-ring',
		'fa-life-buoy'                           => 'far fa-life-ring',
		'fa-life-bouy'                           => 'far fa-life-ring',
		'fa-lightbulb-o'                         => 'far fa-lightbulb',
		'fa-list-alt'                            => 'far fa-list-alt',
		'fa-map-o'                               => 'far fa-map',
		'fa-meh-o'                               => 'far fa-meh',
		'fa-minus-square-o'                      => 'far fa-minus-square',
		'fa-money'                               => 'far fa-money-bill-alt',
		'fa-moon-o'                              => 'far fa-moon',
		'fa-newspaper-o'                         => 'far fa-newspaper',
		'fa-object-group'                        => 'far fa-object-group',
		'fa-object-ungroup'                      => 'far fa-object-ungroup',
		'fa-send-o'                              => 'far fa-paper-plane',
		'fa-paper-plane-o'                       => 'far fa-paper-plane',
		'fa-pause-circle-o'                      => 'far fa-pause-circle',
		'fa-play-circle-o'                       => 'far fa-play-circle',
		'fa-plus-square-o'                       => 'far fa-plus-square',
		'fa-question-circle-o'                   => 'far fa-question-circle',
		'fa-registered'                          => 'far fa-registered',
		'fa-floppy-o'                            => 'far fa-save',
		'fa-share-square-o'                      => 'far fa-share-square',
		'fa-smile-o'                             => 'far fa-smile',
		'fa-snowflake-o'                         => 'far fa-snowflake',
		'fa-square-o'                            => 'far fa-square',
		'fa-star-o'                              => 'far fa-star',
		'fa-star-half-o'                         => 'far fa-star-half',
		'fa-star-half-full'                      => 'far fa-star-half',
		'fa-star-half-empty'                     => 'far fa-star-half',
		'fa-sticky-note-o'                       => 'far fa-sticky-note',
		'fa-stop-circle-o'                       => 'far fa-stop-circle',
		'fa-sun-o'                               => 'far fa-sun',
		'fa-thumbs-o-down'                       => 'far fa-thumbs-down',
		'fa-thumbs-o-up'                         => 'far fa-thumbs-up',
		'fa-times-circle-o'                      => 'far fa-times-circle',
		'fa-trash-o'                             => 'far fa-trash-alt',
		'fa-user-o'                              => 'far fa-user',
		'fa-user-circle-o'                       => 'far fa-user-circle',
		'fa-window-close-o'                      => 'far fa-window-close',
		'fa-times-rectangle-o'                   => 'far fa-window-close',
		'fa-window-maximize'                     => 'far fa-window-maximize',
		'fa-window-restore'                      => 'far fa-window-restore',
		'fa-address-book'                        => 'fas fa-address-book',
		'fa-vcard'                               => 'fas fa-address-card',
		'fa-address-card'                        => 'fas fa-address-card',
		'fa-adjust'                              => 'fas fa-adjust',
		'fa-align-center'                        => 'fas fa-align-center',
		'fa-align-justify'                       => 'fas fa-align-justify',
		'fa-align-left'                          => 'fas fa-align-left',
		'fa-align-right'                         => 'fas fa-align-right',
		'fa-ambulance'                           => 'fas fa-ambulance',
		'fa-asl-interpreting'                    => 'fas fa-american-sign-language-interpreting',
		'fa-american-sign-language-interpreting' => 'fas fa-american-sign-language-interpreting',
		'fa-anchor'                              => 'fas fa-anchor',
		'fa-angle-double-down'                   => 'fas fa-angle-double-down',
		'fa-angle-double-left'                   => 'fas fa-angle-double-left',
		'fa-angle-double-right'                  => 'fas fa-angle-double-right',
		'fa-angle-double-up'                     => 'fas fa-angle-double-up',
		'fa-angle-down'                          => 'fas fa-angle-down',
		'fa-angle-left'                          => 'fas fa-angle-left',
		'fa-angle-right'                         => 'fas fa-angle-right',
		'fa-angle-up'                            => 'fas fa-angle-up',
		'fa-archive'                             => 'fas fa-archive',
		'fa-arrow-circle-down'                   => 'fas fa-arrow-circle-down',
		'fa-arrow-circle-left'                   => 'fas fa-arrow-circle-left',
		'fa-arrow-circle-right'                  => 'fas fa-arrow-circle-right',
		'fa-arrow-circle-up'                     => 'fas fa-arrow-circle-up',
		'fa-arrow-down'                          => 'fas fa-arrow-down',
		'fa-arrow-left'                          => 'fas fa-arrow-left',
		'fa-arrow-right'                         => 'fas fa-arrow-right',
		'fa-arrow-up'                            => 'fas fa-arrow-up',
		'fa-arrows'                              => 'fas fa-arrows-alt',
		'fa-arrows-h'                            => 'fas fa-arrows-alt-h',
		'fa-arrows-v'                            => 'fas fa-arrows-alt-v',
		'fa-assistive-listening-systems'         => 'fas fa-assistive-listening-systems',
		'fa-asterisk'                            => 'fas fa-asterisk',
		'fa-at'                                  => 'fas fa-at',
		'fa-audio-description'                   => 'fas fa-audio-description',
		'fa-backward'                            => 'fas fa-backward',
		'fa-balance-scale'                       => 'fas fa-balance-scale',
		'fa-ban'                                 => 'fas fa-ban',
		'fa-barcode'                             => 'fas fa-barcode',
		'fa-bars'                                => 'fas fa-bars',
		'fa-reorder'                             => 'fas fa-bars',
		'fa-navicon'                             => 'fas fa-bars',
		'fa-bath'                                => 'fas fa-bath',
		'fa-bathtub'                             => 'fas fa-bath',
		'fa-s15'                                 => 'fas fa-bath',
		'fa-battery-empty'                       => 'fas fa-battery-empty',
		'fa-battery-0'                           => 'fas fa-battery-empty',
		'fa-battery'                             => 'fas fa-battery-full',
		'fa-battery-full'                        => 'fas fa-battery-full',
		'fa-battery-4'                           => 'fas fa-battery-full',
		'fa-battery-half'                        => 'fas fa-battery-half',
		'fa-battery-2'                           => 'fas fa-battery-half',
		'fa-battery-1'                           => 'fas fa-battery-quarter',
		'fa-battery-quarter'                     => 'fas fa-battery-quarter',
		'fa-battery-3'                           => 'fas fa-battery-three-quarters',
		'fa-battery-three-quarters'              => 'fas fa-battery-three-quarters',
		'fa-hotel'                               => 'fas fa-bed',
		'fa-bed'                                 => 'fas fa-bed',
		'fa-beer'                                => 'fas fa-beer',
		'fa-bell'                                => 'fas fa-bell',
		'fa-bell-slash'                          => 'fas fa-bell-slash',
		'fa-bicycle'                             => 'fas fa-bicycle',
		'fa-binoculars'                          => 'fas fa-binoculars',
		'fa-birthday-cake'                       => 'fas fa-birthday-cake',
		'fa-blind'                               => 'fas fa-blind',
		'fa-bold'                                => 'fas fa-bold',
		'fa-bolt'                                => 'fas fa-bolt',
		'fa-flash'                               => 'fas fa-bolt',
		'fa-bomb'                                => 'fas fa-bomb',
		'fa-book'                                => 'fas fa-book',
		'fa-bookmark'                            => 'fas fa-bookmark',
		'fa-braille'                             => 'fas fa-braille',
		'fa-briefcase'                           => 'fas fa-briefcase',
		'fa-bug'                                 => 'fas fa-bug',
		'fa-building'                            => 'fas fa-building',
		'fa-bullhorn'                            => 'fas fa-bullhorn',
		'fa-bullseye'                            => 'fas fa-bullseye',
		'fa-bus'                                 => 'fas fa-bus',
		'fa-calculator'                          => 'fas fa-calculator',
		'fa-calendar'                            => 'fas fa-calendar-alt',
		'fa-camera'                              => 'fas fa-camera',
		'fa-camera-retro'                        => 'fas fa-camera-retro',
		'fa-automobile'                          => 'fas fa-car',
		'fa-car'                                 => 'fas fa-car',
		'fa-caret-down'                          => 'fas fa-caret-down',
		'fa-caret-left'                          => 'fas fa-caret-left',
		'fa-caret-right'                         => 'fas fa-caret-right',
		'fa-caret-up'                            => 'fas fa-caret-up',
		'fa-cart-arrow-down'                     => 'fas fa-cart-arrow-down',
		'fa-cart-plus'                           => 'fas fa-cart-plus',
		'fa-certificate'                         => 'fas fa-certificate',
		'fa-area-chart'                          => 'fas fa-chart-area',
		'fa-line-chart'                          => 'fas fa-chart-line',
		'fa-pie-chart'                           => 'fas fa-chart-pie',
		'fa-check'                               => 'fas fa-check',
		'fa-check-circle'                        => 'fas fa-check-circle',
		'fa-check-square'                        => 'fas fa-check-square',
		'fa-chevron-circle-down'                 => 'fas fa-chevron-circle-down',
		'fa-chevron-circle-left'                 => 'fas fa-chevron-circle-left',
		'fa-chevron-circle-right'                => 'fas fa-chevron-circle-right',
		'fa-chevron-circle-up'                   => 'fas fa-chevron-circle-up',
		'fa-chevron-down'                        => 'fas fa-chevron-down',
		'fa-chevron-left'                        => 'fas fa-chevron-left',
		'fa-chevron-right'                       => 'fas fa-chevron-right',
		'fa-chevron-up'                          => 'fas fa-chevron-up',
		'fa-child'                               => 'fas fa-child',
		'fa-circle'                              => 'fas fa-circle',
		'fa-circle-o-notch'                      => 'fas fa-circle-notch',
		'fa-cloud'                               => 'fas fa-cloud',
		'fa-cloud-download'                      => 'fas fa-cloud-download-alt',
		'fa-cloud-upload'                        => 'fas fa-cloud-upload-alt',
		'fa-code'                                => 'fas fa-code',
		'fa-code-fork'                           => 'fas fa-code-branch',
		'fa-coffee'                              => 'fas fa-coffee',
		'fa-gear'                                => 'fas fa-cog',
		'fa-cog'                                 => 'fas fa-cog',
		'fa-gears'                               => 'fas fa-cogs',
		'fa-cogs'                                => 'fas fa-cogs',
		'fa-columns'                             => 'fas fa-columns',
		'fa-comment'                             => 'fas fa-comment',
		'fa-commenting'                          => 'fas fa-comment-dots',
		'fa-comments'                            => 'fas fa-comments',
		'fa-compress'                            => 'fas fa-compress',
		'fa-copy'                                => 'fas fa-copy',
		'fa-credit-card-alt'                     => 'fas fa-credit-card',
		'fa-crop'                                => 'fas fa-crop',
		'fa-crosshairs'                          => 'fas fa-crosshairs',
		'fa-cube'                                => 'fas fa-cube',
		'fa-cubes'                               => 'fas fa-cubes',
		'fa-scissors'                            => 'fas fa-cut',
		'fa-cut'                                 => 'fas fa-cut',
		'fa-database'                            => 'fas fa-database',
		'fa-hard-of-hearing'                     => 'fas fa-deaf',
		'fa-deafness'                            => 'fas fa-deaf',
		'fa-deaf'                                => 'fas fa-deaf',
		'fa-desktop'                             => 'fas fa-desktop',
		'fa-usd'                                 => 'fas fa-dollar-sign',
		'fa-dollar'                              => 'fas fa-dollar-sign',
		'fa-download'                            => 'fas fa-download',
		'fa-edit'                                => 'fas fa-edit',
		'fa-eject'                               => 'fas fa-eject',
		'fa-ellipsis-h'                          => 'fas fa-ellipsis-h',
		'fa-ellipsis-v'                          => 'fas fa-ellipsis-v',
		'fa-envelope'                            => 'fas fa-envelope',
		'fa-envelope-open'                       => 'fas fa-envelope-open',
		'fa-envelope-square'                     => 'fas fa-envelope-square',
		'fa-eraser'                              => 'fas fa-eraser',
		'fa-euro'                                => 'fas fa-euro-sign',
		'fa-eur'                                 => 'fas fa-euro-sign',
		'fa-exchange'                            => 'fas fa-exchange-alt',
		'fa-exclamation'                         => 'fas fa-exclamation',
		'fa-exclamation-circle'                  => 'fas fa-exclamation-circle',
		'fa-warning'                             => 'fas fa-exclamation-triangle',
		'fa-exclamation-triangle'                => 'fas fa-exclamation-triangle',
		'fa-expand'                              => 'fas fa-expand',
		'fa-arrows-alt'                          => 'fas fa-expand-arrows-alt',
		'fa-external-link'                       => 'fas fa-external-link-alt',
		'fa-external-link-square'                => 'fas fa-external-link-square-alt',
		'fa-eyedropper'                          => 'fas fa-eye-dropper',
		'fa-fast-backward'                       => 'fas fa-fast-backward',
		'fa-fast-forward'                        => 'fas fa-fast-forward',
		'fa-fax'                                 => 'fas fa-fax',
		'fa-female'                              => 'fas fa-female',
		'fa-fighter-jet'                         => 'fas fa-fighter-jet',
		'fa-file'                                => 'fas fa-file',
		'fa-file-text'                           => 'fas fa-file-alt',
		'fa-film'                                => 'fas fa-film',
		'fa-filter'                              => 'fas fa-filter',
		'fa-fire'                                => 'fas fa-fire',
		'fa-fire-extinguisher'                   => 'fas fa-fire-extinguisher',
		'fa-flag'                                => 'fas fa-flag',
		'fa-flag-checkered'                      => 'fas fa-flag-checkered',
		'fa-flask'                               => 'fas fa-flask',
		'fa-folder'                              => 'fas fa-folder',
		'fa-folder-open'                         => 'fas fa-folder-open',
		'fa-font'                                => 'fas fa-font',
		'fa-forward'                             => 'fas fa-forward',
		'fa-gamepad'                             => 'fas fa-gamepad',
		'fa-legal'                               => 'fas fa-gavel',
		'fa-gavel'                               => 'fas fa-gavel',
		'fa-genderless'                          => 'fas fa-genderless',
		'fa-gift'                                => 'fas fa-gift',
		'fa-glass'                               => 'fas fa-glass-martini',
		'fa-globe'                               => 'fas fa-globe',
		'fa-graduation-cap'                      => 'fas fa-graduation-cap',
		'fa-mortar-board'                        => 'fas fa-graduation-cap',
		'fa-h-square'                            => 'fas fa-h-square',
		'fa-hashtag'                             => 'fas fa-hashtag',
		'fa-header'                              => 'fas fa-heading',
		'fa-headphones'                          => 'fas fa-headphones',
		'fa-heart'                               => 'fas fa-heart',
		'fa-heartbeat'                           => 'fas fa-heartbeat',
		'fa-history'                             => 'fas fa-history',
		'fa-home'                                => 'fas fa-home',
		'fa-hourglass'                           => 'fas fa-hourglass',
		'fa-hourglass-3'                         => 'fas fa-hourglass-end',
		'fa-hourglass-end'                       => 'fas fa-hourglass-end',
		'fa-hourglass-half'                      => 'fas fa-hourglass-half',
		'fa-hourglass-2'                         => 'fas fa-hourglass-half',
		'fa-hourglass-start'                     => 'fas fa-hourglass-start',
		'fa-hourglass-1'                         => 'fas fa-hourglass-start',
		'fa-i-cursor'                            => 'fas fa-i-cursor',
		'fa-id-card'                             => 'fas fa-id-card',
		'fa-drivers-license'                     => 'fas fa-id-card',
		'fa-inbox'                               => 'fas fa-inbox',
		'fa-indent'                              => 'fas fa-indent',
		'fa-industry'                            => 'fas fa-industry',
		'fa-info'                                => 'fas fa-info',
		'fa-info-circle'                         => 'fas fa-info-circle',
		'fa-italic'                              => 'fas fa-italic',
		'fa-key'                                 => 'fas fa-key',
		'fa-language'                            => 'fas fa-language',
		'fa-laptop'                              => 'fas fa-laptop',
		'fa-leaf'                                => 'fas fa-leaf',
		'fa-level-down'                          => 'fas fa-level-down-alt',
		'fa-level-up'                            => 'fas fa-level-up-alt',
		'fa-link'                                => 'fas fa-link',
		'fa-chain'                               => 'fas fa-link',
		'fa-turkish-lira'                        => 'fas fa-lira-sign',
		'fa-try'                                 => 'fas fa-lira-sign',
		'fa-list'                                => 'fas fa-list',
		'fa-list-ol'                             => 'fas fa-list-ol',
		'fa-list-ul'                             => 'fas fa-list-ul',
		'fa-location-arrow'                      => 'fas fa-location-arrow',
		'fa-lock'                                => 'fas fa-lock',
		'fa-long-arrow-down'                     => 'fas fa-long-arrow-alt-down',
		'fa-long-arrow-left'                     => 'fas fa-long-arrow-alt-left',
		'fa-long-arrow-right'                    => 'fas fa-long-arrow-alt-right',
		'fa-long-arrow-up'                       => 'fas fa-long-arrow-alt-up',
		'fa-low-vision'                          => 'fas fa-low-vision',
		'fa-magic'                               => 'fas fa-magic',
		'fa-magnet'                              => 'fas fa-magnet',
		'fa-male'                                => 'fas fa-male',
		'fa-map'                                 => 'fas fa-map',
		'fa-map-marker'                          => 'fas fa-map-marker-alt',
		'fa-map-pin'                             => 'fas fa-map-pin',
		'fa-map-signs'                           => 'fas fa-map-signs',
		'fa-mars'                                => 'fas fa-mars',
		'fa-mars-double'                         => 'fas fa-mars-double',
		'fa-mars-stroke'                         => 'fas fa-mars-stroke',
		'fa-mars-stroke-h'                       => 'fas fa-mars-stroke-h',
		'fa-mars-stroke-v'                       => 'fas fa-mars-stroke-v',
		'fa-medkit'                              => 'fas fa-medkit',
		'fa-mercury'                             => 'fas fa-mercury',
		'fa-microchip'                           => 'fas fa-microchip',
		'fa-microphone'                          => 'fas fa-microphone',
		'fa-microphone-slash'                    => 'fas fa-microphone-slash',
		'fa-minus'                               => 'fas fa-minus',
		'fa-minus-circle'                        => 'fas fa-minus-circle',
		'fa-minus-square'                        => 'fas fa-minus-square',
		'fa-mobile'                              => 'fas fa-mobile-alt',
		'fa-mobile-phone'                        => 'fas fa-mobile-alt',
		'fa-motorcycle'                          => 'fas fa-motorcycle',
		'fa-mouse-pointer'                       => 'fas fa-mouse-pointer',
		'fa-music'                               => 'fas fa-music',
		'fa-neuter'                              => 'fas fa-neuter',
		'fa-dedent'                              => 'fas fa-outdent',
		'fa-outdent'                             => 'fas fa-outdent',
		'fa-paint-brush'                         => 'fas fa-paint-brush',
		'fa-paper-plane'                         => 'fas fa-paper-plane',
		'fa-send'                                => 'fas fa-paper-plane',
		'fa-paperclip'                           => 'fas fa-paperclip',
		'fa-paragraph'                           => 'fas fa-paragraph',
		'fa-pause'                               => 'fas fa-pause',
		'fa-pause-circle'                        => 'fas fa-pause-circle',
		'fa-paw'                                 => 'fas fa-paw',
		'fa-pencil-square'                       => 'fas fa-pen-square',
		'fa-pencil'                              => 'fas fa-pencil-alt',
		'fa-percent'                             => 'fas fa-percent',
		'fa-phone'                               => 'fas fa-phone',
		'fa-phone-square'                        => 'fas fa-phone-square',
		'fa-volume-control-phone'                => 'fas fa-phone-volume',
		'fa-plane'                               => 'fas fa-plane',
		'fa-play'                                => 'fas fa-play',
		'fa-play-circle'                         => 'fas fa-play-circle',
		'fa-plug'                                => 'fas fa-plug',
		'fa-plus'                                => 'fas fa-plus',
		'fa-plus-circle'                         => 'fas fa-plus-circle',
		'fa-plus-square'                         => 'fas fa-plus-square',
		'fa-podcast'                             => 'fas fa-podcast',
		'fa-gbp'                                 => 'fas fa-pound-sign',
		'fa-power-off'                           => 'fas fa-power-off',
		'fa-print'                               => 'fas fa-print',
		'fa-puzzle-piece'                        => 'fas fa-puzzle-piece',
		'fa-qrcode'                              => 'fas fa-qrcode',
		'fa-question'                            => 'fas fa-question',
		'fa-question-circle'                     => 'fas fa-question-circle',
		'fa-quote-left'                          => 'fas fa-quote-left',
		'fa-quote-right'                         => 'fas fa-quote-right',
		'fa-random'                              => 'fas fa-random',
		'fa-recycle'                             => 'fas fa-recycle',
		'fa-repeat'                              => 'fas fa-redo',
		'fa-rotate-right'                        => 'fas fa-redo',
		'fa-mail-reply'                          => 'fas fa-reply',
		'fa-reply'                               => 'fas fa-reply',
		'fa-mail-reply-all'                      => 'fas fa-reply-all',
		'fa-reply-all'                           => 'fas fa-reply-all',
		'fa-retweet'                             => 'fas fa-retweet',
		'fa-road'                                => 'fas fa-road',
		'fa-rocket'                              => 'fas fa-rocket',
		'fa-feed'                                => 'fas fa-rss',
		'fa-rss'                                 => 'fas fa-rss',
		'fa-rss-square'                          => 'fas fa-rss-square',
		'fa-ruble'                               => 'fas fa-ruble-sign',
		'fa-rub'                                 => 'fas fa-ruble-sign',
		'fa-rouble'                              => 'fas fa-ruble-sign',
		'fa-rupee'                               => 'fas fa-rupee-sign',
		'fa-inr'                                 => 'fas fa-rupee-sign',
		'fa-save'                                => 'fas fa-save',
		'fa-search'                              => 'fas fa-search',
		'fa-search-minus'                        => 'fas fa-search-minus',
		'fa-search-plus'                         => 'fas fa-search-plus',
		'fa-server'                              => 'fas fa-server',
		'fa-share'                               => 'fas fa-share',
		'fa-mail-forward'                        => 'fas fa-share',
		'fa-share-alt'                           => 'fas fa-share-alt',
		'fa-share-alt-square'                    => 'fas fa-share-alt-square',
		'fa-share-square'                        => 'fas fa-share-square',
		'fa-shekel'                              => 'fas fa-shekel-sign',
		'fa-sheqel'                              => 'fas fa-shekel-sign',
		'fa-ils'                                 => 'fas fa-shekel-sign',
		'fa-shield'                              => 'fas fa-shield-alt',
		'fa-ship'                                => 'fas fa-ship',
		'fa-shopping-bag'                        => 'fas fa-shopping-bag',
		'fa-shopping-basket'                     => 'fas fa-shopping-basket',
		'fa-shopping-cart'                       => 'fas fa-shopping-cart',
		'fa-shower'                              => 'fas fa-shower',
		'fa-sign-in'                             => 'fas fa-sign-in-alt',
		'fa-signing'                             => 'fas fa-sign-language',
		'fa-sign-language'                       => 'fas fa-sign-language',
		'fa-sign-out'                            => 'fas fa-sign-out-alt',
		'fa-signal'                              => 'fas fa-signal',
		'fa-sitemap'                             => 'fas fa-sitemap',
		'fa-sliders'                             => 'fas fa-sliders-h',
		'fa-unsorted'                            => 'fas fa-sort',
		'fa-sort'                                => 'fas fa-sort',
		'fa-sort-alpha-asc'                      => 'fas fa-sort-alpha-down',
		'fa-sort-alpha-desc'                     => 'fas fa-sort-alpha-up',
		'fa-sort-amount-asc'                     => 'fas fa-sort-amount-down',
		'fa-sort-amount-desc'                    => 'fas fa-sort-amount-up',
		'fa-sort-desc'                           => 'fas fa-sort-down',
		'fa-sort-down'                           => 'fas fa-sort-down',
		'fa-sort-numeric-asc'                    => 'fas fa-sort-numeric-down',
		'fa-sort-numeric-desc'                   => 'fas fa-sort-numeric-up',
		'fa-sort-up'                             => 'fas fa-sort-up',
		'fa-sort-asc'                            => 'fas fa-sort-up',
		'fa-space-shuttle'                       => 'fas fa-space-shuttle',
		'fa-spinner'                             => 'fas fa-spinner',
		'fa-square'                              => 'fas fa-square',
		'fa-star'                                => 'fas fa-star',
		'fa-star-half'                           => 'fas fa-star-half',
		'fa-step-backward'                       => 'fas fa-step-backward',
		'fa-step-forward'                        => 'fas fa-step-forward',
		'fa-stethoscope'                         => 'fas fa-stethoscope',
		'fa-sticky-note'                         => 'fas fa-sticky-note',
		'fa-stop'                                => 'fas fa-stop',
		'fa-stop-circle'                         => 'fas fa-stop-circle',
		'fa-street-view'                         => 'fas fa-street-view',
		'fa-strikethrough'                       => 'fas fa-strikethrough',
		'fa-subscript'                           => 'fas fa-subscript',
		'fa-subway'                              => 'fas fa-subway',
		'fa-suitcase'                            => 'fas fa-suitcase',
		'fa-superscript'                         => 'fas fa-superscript',
		'fa-refresh'                             => 'fas fa-sync',
		'fa-table'                               => 'fas fa-table',
		'fa-tablet'                              => 'fas fa-tablet-alt',
		'fa-dashboard'                           => 'fas fa-tachometer-alt',
		'fa-tachometer'                          => 'fas fa-tachometer-alt',
		'fa-tag'                                 => 'fas fa-tag',
		'fa-tags'                                => 'fas fa-tags',
		'fa-tasks'                               => 'fas fa-tasks',
		'fa-taxi'                                => 'fas fa-taxi',
		'fa-cab'                                 => 'fas fa-taxi',
		'fa-terminal'                            => 'fas fa-terminal',
		'fa-text-height'                         => 'fas fa-text-height',
		'fa-text-width'                          => 'fas fa-text-width',
		'fa-th'                                  => 'fas fa-th',
		'fa-th-large'                            => 'fas fa-th-large',
		'fa-th-list'                             => 'fas fa-th-list',
		'fa-thermometer-0'                       => 'fas fa-thermometer-empty',
		'fa-thermometer-empty'                   => 'fas fa-thermometer-empty',
		'fa-thermometer-full'                    => 'fas fa-thermometer-full',
		'fa-thermometer-4'                       => 'fas fa-thermometer-full',
		'fa-thermometer'                         => 'fas fa-thermometer-full',
		'fa-thermometer-half'                    => 'fas fa-thermometer-half',
		'fa-thermometer-2'                       => 'fas fa-thermometer-half',
		'fa-thermometer-1'                       => 'fas fa-thermometer-quarter',
		'fa-thermometer-quarter'                 => 'fas fa-thermometer-quarter',
		'fa-thermometer-three-quarters'          => 'fas fa-thermometer-three-quarters',
		'fa-thermometer-3'                       => 'fas fa-thermometer-three-quarters',
		'fa-thumbs-down'                         => 'fas fa-thumbs-down',
		'fa-thumbs-up'                           => 'fas fa-thumbs-up',
		'fa-thumb-tack'                          => 'fas fa-thumbtack',
		'fa-ticket'                              => 'fas fa-ticket-alt',
		'fa-times'                               => 'fas fa-times',
		'fa-close'                               => 'fas fa-times',
		'fa-remove'                              => 'fas fa-times',
		'fa-times-circle'                        => 'fas fa-times-circle',
		'fa-tint'                                => 'fas fa-tint',
		'fa-toggle-off'                          => 'fas fa-toggle-off',
		'fa-toggle-on'                           => 'fas fa-toggle-on',
		'fa-trademark'                           => 'fas fa-trademark',
		'fa-train'                               => 'fas fa-train',
		'fa-transgender'                         => 'fas fa-transgender',
		'fa-intersex'                            => 'fas fa-transgender',
		'fa-transgender-alt'                     => 'fas fa-transgender-alt',
		'fa-trash'                               => 'fas fa-trash-alt',
		'fa-tree'                                => 'fas fa-tree',
		'fa-trophy'                              => 'fas fa-trophy',
		'fa-truck'                               => 'fas fa-truck',
		'fa-tty'                                 => 'fas fa-tty',
		'fa-television'                          => 'fas fa-tv',
		'fa-tv'                                  => 'fas fa-tv',
		'fa-umbrella'                            => 'fas fa-umbrella',
		'fa-underline'                           => 'fas fa-underline',
		'fa-rotate-left'                         => 'fas fa-undo',
		'fa-undo'                                => 'fas fa-undo',
		'fa-universal-access'                    => 'fas fa-universal-access',
		'fa-bank'                                => 'fas fa-university',
		'fa-university'                          => 'fas fa-university',
		'fa-institution'                         => 'fas fa-university',
		'fa-unlink'                              => 'fas fa-unlink',
		'fa-chain-broken'                        => 'fas fa-unlink',
		'fa-unlock'                              => 'fas fa-unlock',
		'fa-unlock-alt'                          => 'fas fa-unlock-alt',
		'fa-upload'                              => 'fas fa-upload',
		'fa-user'                                => 'fas fa-user',
		'fa-user-circle'                         => 'fas fa-user-circle',
		'fa-user-md'                             => 'fas fa-user-md',
		'fa-user-plus'                           => 'fas fa-user-plus',
		'fa-user-secret'                         => 'fas fa-user-secret',
		'fa-user-times'                          => 'fas fa-user-times',
		'fa-group'                               => 'fas fa-users',
		'fa-users'                               => 'fas fa-users',
		'fa-spoon'                               => 'fas fa-utensil-spoon',
		'fa-cutlery'                             => 'fas fa-utensils',
		'fa-venus'                               => 'fas fa-venus',
		'fa-venus-double'                        => 'fas fa-venus-double',
		'fa-venus-mars'                          => 'fas fa-venus-mars',
		'fa-video-camera'                        => 'fas fa-video',
		'fa-volume-down'                         => 'fas fa-volume-down',
		'fa-volume-off'                          => 'fas fa-volume-off',
		'fa-volume-up'                           => 'fas fa-volume-up',
		'fa-wheelchair'                          => 'fas fa-wheelchair',
		'fa-wifi'                                => 'fas fa-wifi',
		'fa-window-close'                        => 'fas fa-window-close',
		'fa-times-rectangle'                     => 'fas fa-window-close',
		'fa-window-minimize'                     => 'fas fa-window-minimize',
		'fa-krw'                                 => 'fas fa-won-sign',
		'fa-won'                                 => 'fas fa-won-sign',
		'fa-wrench'                              => 'fas fa-wrench',
		'fa-jpy'                                 => 'fas fa-yen-sign',
		'fa-cny'                                 => 'fas fa-yen-sign',
		'fa-rmb'                                 => 'fas fa-yen-sign',
		'fa-yen'                                 => 'fas fa-yen-sign',
	);
}
