<?php
add_action( 'after_setup_theme', 'zermatt_child_before_setup', 5 );
function zermatt_child_before_setup() {

	/*
	 * Loads the language files of the child theme (if any).
	 * If you use any of the WordPress localization functions, you will need to provide the same text domain
	 * exactly as the one mentioned below, i.e. 'zermatt-child'
	 * If you change this value, then you'll need to modify your function calls accordingly.
	 * Localization functions reference: https://codex.wordpress.org/L10n
	 */
	load_child_theme_textdomain( 'zermatt-child', get_stylesheet_directory() . '/languages' );

	/*
	 * Code added here will execute BEFORE the respective zermatt_setup function of the parent theme.
	 */


} //zermatt_child_before_setup


add_action( 'after_setup_theme', 'zermatt_child_after_setup', 15 );
function zermatt_child_after_setup() {

	/*
	 * Code added here will execute AFTER the respective zermatt_setup function of the parent theme.
	 */


} //zermatt_child_after_setup


add_action( 'wp_enqueue_scripts', 'zermatt_child_enqueue_scripts', 15 );
function zermatt_child_enqueue_scripts() {

	/*
	 * The parent theme's stylesheet, as well as this child's stylesheet, are loaded by default by the
	 * parent theme itself. This means you can easily add you CSS customizations by just adding them
	 * inside this child's style.css file.
	 */

	/*
	 * If you DON'T want the parent stylesheet to load, then uncomment the following line.
	 */
	//wp_dequeue_style( 'zermatt-style' );

	/*
	 * Note that the wp_dequeue_style() call above, also dequeues all (or most) related stylesheets.
	 * If you need the rest of the stylesheets to load, then open the parent theme's functions.php
	 * and locate the lines similar to:
	 *  wp_enqueue_style( 'zermatt-style', get_template_directory_uri() . '/style.css', array(
	 *      'zermatt-google-font',
	 *      'zermatt-base',
	 *      'font-awesome',
	 *      'zermatt-mmenu',
	 *      ...
	 *  ), $theme->get( 'Version' ) );
	 *
	 * For each indented line, add below a call like this:
	 *  wp_enqueue_style( 'zermatt-google-font' );
	 */


}
