<?php

if ( ! function_exists( 'zermatt_get_part_customizer_css' ) ):
function zermatt_get_part_customizer_css() {
	ob_start();

	//
	// Header Colors
	//
	if ( get_theme_mod( 'header_nav_color') ) {
		?>
		.navigation > li ul a,
		.header .ci-dropdown-menu ul li a {
			color: <?php echo get_theme_mod( 'header_nav_color' ); ?>;
		}
		<?php
	}

	if ( get_theme_mod( 'header_text_color') ) {
		?>
		.header,
		.header a,
		.header .ci-dropdown-toggle,
		.header .btn,
		.page-title {
			color: <?php echo get_theme_mod( 'header_text_color' ); ?>;
		}

		.header .ci-dropdown-toggle,
		.header .btn,
		.header .ci-dropdown-menu ul,
		.navigation ul {
			border-color: <?php echo get_theme_mod( 'header_text_color' ); ?>;
		}

		.header .ci-dropdown-toggle:hover,
		.header .btn:hover,
		.header .btn:active,
		.header .btn:focus,
		.header .ci-dropdown-menu ul li a:hover,
		.header .ci-dropdown .sfHover > a,
		.header .ci-dropdown .sfHover > button,
		.header .ci-dropdown .current_page_item > a,
		.header .ci-dropdown .current-menu-item > a,
		.header .ci-dropdown .current-menu-ancestor > a,
		.header .ci-dropdown .current-menu-parent > a,
		.navigation > li ul a:hover,
		.navigation > li ul .sfHover > a {
			background-color: <?php echo get_theme_mod( 'header_text_color' ); ?>;
		}

		.header .ci-dropdown-menu ul li a,
		.navigation ul li a {
			background-color: <?php echo zermatt_hex2rgba( get_theme_mod( 'header_text_color' ), 0.5 ); ?>;
		}
		<?php
	}

	if ( get_theme_mod( 'header_hover_color') ) {
		?>
		.header .ci-dropdown-toggle:hover,
		.header .btn:hover,
		.header .btn:active,
		.header .btn:focus,
		.header .ci-dropdown-menu ul li a:hover,
		.header .ci-dropdown .sfHover > a,
		.header .ci-dropdown .sfHover > button,
		.header .ci-dropdown .current_page_item > a,
		.header .ci-dropdown .current-menu-item > a,
		.header .ci-dropdown .current-menu-ancestor > a,
		.header .ci-dropdown .current-menu-parent > a,
		.navigation > li ul a:hover,
		.navigation > li ul .sfHover > a {
			color: <?php echo get_theme_mod( 'header_hover_color' ); ?>;
		}
		<?php
	}


	//
	// Global Colors
	//
	if ( get_theme_mod( 'global_primary_color' ) ) {
		?>
		a, a:hover,
		.item-title a:hover,
		.btn-white.btn-transparent:hover,
		.mobile-trigger:hover {
			color: <?php echo get_theme_mod( 'global_primary_color' ); ?>;
		}

		.ui-datepicker .ui-datepicker-header,
		.ui-datepicker .ui-datepicker-header .ui-state-hover,
		.ui-datepicker thead,
		.ui-datepicker td .ui-state-hover,
		.ui-datepicker td .ui-state-active,
		#paging .current,
		#paging a:hover,
		.room-slide-controls a:hover span,
		.booking-cta-inner,
		.item-tag {
			background-color: <?php echo get_theme_mod( 'global_primary_color' ); ?>;
		}

		.booking-form-inline input:focus,
		.room-slide-controls a:hover span {
			border-color: <?php echo get_theme_mod( 'global_primary_color' ); ?>;
		}
		<?php
	}

	if ( get_theme_mod( 'global_text_color' ) ) {
		?>
		body,
		option,
		.text-emphasiss a:hover,
		.room-slide-controls a span,
		#paging a:hover,
		#paging .current,
		.social-icon,
		.social-icon:hover,
		.widget-title,
		.entry-meta ,
		h1, h2, h3, h4, h5, h6{
			color: <?php echo get_theme_mod( 'global_text_color' ); ?>;
		}

		#paging a,
		#paging > span,
		#paging li span {
			background-color: <?php echo get_theme_mod( 'global_text_color' ); ?>;
		}

		input:focus,
		textarea:focus,
		.text-emphasis a,
		.entry-content blockquote:after,
		.social-icon {
			border-color: <?php echo get_theme_mod( 'global_text_color' ); ?>;
		}
		<?php
	}

	if ( get_theme_mod( 'global_link_color' ) ) {
		?>
		.entry-content a,
		.entry-content a:hover {
			color: <?php echo get_theme_mod( 'global_link_color' ); ?>;
		}
		<?php
	}

	if ( get_theme_mod( 'global_link_hover_color' ) ) {
		?>
		.entry-content a:hover {
			color: <?php echo get_theme_mod( 'global_link_hover_color' ); ?>;
		}
		<?php
	}

	if ( get_theme_mod( 'global_btn_text_color' ) ) {
		?>
		.btn,
		input[type="button"],
		input[type="submit"],
		input[type="reset"],
		button,
		.comment-reply-link {
			color: <?php echo get_theme_mod( 'global_btn_text_color' ); ?>;
		}
		<?php
	}

	if ( get_theme_mod( 'global_btn_bg_color' ) ) {
		?>
		.btn,
		input[type="button"],
		input[type="submit"],
		input[type="reset"],
		button,
		.comment-reply-link {
			background-color: <?php echo get_theme_mod( 'global_btn_bg_color' ); ?>;
		}
		<?php
	}

	if ( get_theme_mod( 'global_btn_hover_bg_color' ) ) {
		?>
		.btn:hover,
		input[type="button"]:hover,
		input[type="submit"]:hover,
		input[type="reset"]:hover,
		button:hover,
		.comment-reply-link:hover{
			background-color: <?php echo get_theme_mod( 'global_btn_hover_bg_color' ); ?>;

			<?php if ( get_theme_mod( 'global_btn_text_color' ) ) { ?>
				color: <?php echo get_theme_mod( 'global_btn_text_color' ); ?>
			<?php } ?>
		}
		<?php
	}

	if ( get_theme_mod( 'global_border_color' ) ) {
		?>
		.widget select,
		.room-slide-controls a span,
		.item-inset:hover:after,
		.justified-gallery > div:hover:after,
		.entry-thumb,
		main .ci-dropdown-menu > li ul,
		.ci-map-wrap,
		.booking-cta,
		.offer-cta {
			border-color: <?php echo get_theme_mod( 'global_border_color' ); ?>;
		}

		.page-title,
		.entry-navigation,
		.entry-rating {
			border-top-color: <?php echo get_theme_mod( 'global_border_color' ); ?>;
		}

		.widget_meta ul li a,
		.widget_pages ul li a,
		.widget_categories ul li a,
		.widget_archive ul li a,
		.widget_nav_menu ul li a,
		.widget_recent_entries ul li a,
		.widget_recent_comments ul li {
			border-bottom-color: <?php echo get_theme_mod( 'global_border_color' ); ?>;
		}
		<?php
	}

	//
	// Sidebar
	//
	if ( get_theme_mod( 'sidebar_bg_color' ) ) {
		?>
		.sidebar {
			padding: 15px;
			background-color: <?php echo get_theme_mod( 'sidebar_bg_color' ); ?>;
		}
		<?php
	}

	if ( get_theme_mod( 'sidebar_text_color' ) ) {
		?>
		.sidebar {
			color: <?php echo get_theme_mod( 'sidebar_text_color' ); ?>;
		}
		<?php
	}

	if ( get_theme_mod( 'sidebar_link_color' ) ) {
		?>
		.sidebar a,
		.sidebar a:hover {
			color: <?php echo get_theme_mod( 'sidebar_link_color' ); ?>;
		}
		<?php
	}

	if ( get_theme_mod( 'sidebar_hover_color' ) ) {
		?>
		.sidebar a:hover {
			color: <?php echo get_theme_mod( 'sidebar_hover_color' ); ?>;
		}
		<?php
	}

	if ( get_theme_mod( 'sidebar_title_color' ) ) {
		?>
		.sidebar .widget-title {
			color: <?php echo get_theme_mod( 'sidebar_title_color' ); ?>;
		}
		<?php
	}

	if ( get_theme_mod( 'sidebar_border_color' ) ) {
		?>
		.widget_meta ul li a,
		.widget_pages ul li a,
		.widget_categories ul li a,
		.widget_archive ul li a,
		.widget_nav_menu ul li a,
		.widget_recent_entries ul li a,
		.widget_recent_comments ul li {
			border-bottom-color: <?php echo get_theme_mod( 'sidebar_border_color' ); ?>;
		}
		<?php
	}

	//
	// Typography
	//
	if ( get_theme_mod( 'lowercase_content_headings' ) ) {
		?>
		.entry-content h1,
		.entry-content h2,
		.entry-content h3,
		.entry-content h4,
		.entry-content h5,
		.entry-content h6 {
			text-transform: none;
		}
		<?php
	}

	// TODO: Remove this after two versions from when the option was removed.
	if ( get_theme_mod( 'custom_css' ) ) {
		echo get_theme_mod( 'custom_css' );
	}

	$css = ob_get_clean();
	return apply_filters( 'zermatt_part_customizer_css', $css );
}
endif;