<?php
add_action( 'customize_register', 'zermatt_customize_register', 100 );
/**
 * Registers all theme-related options to the Customizer.
 *
 * @param WP_Customize_Manager $wpc Reference to the customizer's manager object.
 */
function zermatt_customize_register( $wpc ) {

	// Partial for various settings that affect the customizer styles, but can't have a dedicated icon, e.g. 'limit_logo_size'
	$wpc->selective_refresh->add_partial( 'theme_style', array(
		'selector'            => '#zermatt-style-inline-css',
		'render_callback'     => 'zermatt_get_all_customizer_css',
		'settings'            => array_keys( zermatt_get_registered_typography_controls() ),
		'container_inclusive' => false,
	) );

	$wpc->selective_refresh->add_partial( 'theme_gfonts', array(
		'selector'            => '#zermatt-user-google-fonts-css',
		'render_callback'     => 'zermatt_customize_preview_google_fonts',
		'settings'            => array_keys( zermatt_get_registered_typography_controls() ),
		'container_inclusive' => true,
	) );

	$wpc->add_section( 'header', array(
		'title'    => esc_html_x( 'Header', 'customizer section title', 'zermatt' ),
		'priority' => 1
	) );

	// The following line doesn't work in a some PHP versions. Apparently, get_panel( 'nav_menus' ) returns an array,
	// therefore a cast to object is needed. http://wordpress.stackexchange.com/questions/160987/warning-creating-default-object-when-altering-customize-panels
	//$wpc->get_panel( 'nav_menus' )->priority = 2;
	$panel_menus = (object) $wpc->get_panel( 'nav_menus' );
	$panel_menus->priority = 2;

	$wpc->add_section( 'layout', array(
		'title'    => esc_html_x( 'Layout Options', 'customizer section title', 'zermatt' ),
		'priority' => 20
	) );

	$wpc->add_section( 'homepage', array(
		'title'    => esc_html_x( 'Front Page Carousel', 'customizer section title', 'zermatt' ),
		'priority' => 30
	) );

	$wpc->add_section( 'typography', array(
		'title'    => _x( 'Typography Options', 'customizer section title', 'zermatt' ),
		'priority' => 40
	) );

	$wpc->get_section( 'colors' )->title    = esc_html__( 'Content Colors', 'zermatt' );
	$wpc->get_section( 'colors' )->priority = 50;

	$wpc->add_section( 'sidebar_colors', array(
		'title'    => _x( 'Sidebar Colors', 'customizer section title', 'zermatt' ),
		'priority' => 60
	) );

	// The following line doesn't work in a some PHP versions. Apparently, get_panel( 'widgets' ) returns an array,
	// therefore a cast to object is needed. http://wordpress.stackexchange.com/questions/160987/warning-creating-default-object-when-altering-customize-panels
	//$wpc->get_panel( 'widgets' )->priority = 70;
	$panel_widgets = (object) $wpc->get_panel( 'widgets' );
	$panel_widgets->priority = 70;

	$wpc->add_section( 'social', array(
		'title'       => esc_html_x( 'Social Networks', 'customizer section title', 'zermatt' ),
		'description' => esc_html__( 'Enter your social network URLs. Leaving a URL empty will hide its respective icon.', 'zermatt' ),
		'priority'    => 80
	) );

	$wpc->add_section( 'rooms', array(
		'title'       => esc_html_x( 'Rooms Options', 'customizer section title', 'zermatt' ),
		'priority'    => 90
	) );

	$wpc->add_section( 'booking', array(
		'title'       => esc_html_x( 'Booking - Contact Options', 'customizer section title', 'zermatt' ),
		'description' => esc_html__( 'Global options affecting your booking forms.', 'zermatt' ),
		'priority'    => 100
	) );

	$wpc->add_section( 'footer', array(
		'title'    => esc_html_x( 'Footer', 'customizer section title', 'zermatt' ),
		'priority' => 110
	) );

	// Section 'static_front_page' is not defined when there are no pages.
	if ( get_pages() ) {
		$wpc->get_section( 'static_front_page' )->priority = 120;
	}

	if ( class_exists( 'null_instagram_widget' ) ) {
		$wpc->add_section( 'instagram_widget', array(
			'title'       => esc_html_x( 'Instagram widget', 'customizer section title', 'zermatt' ),
			'description' => esc_html__( 'Options affecting the WP Instagram widget.', 'zermatt' ),
			'priority'    => 130
		) );
	}

	$wpc->add_section( 'other', array(
		'title'       => esc_html_x( 'Other', 'customizer section title', 'zermatt' ),
		'description' => esc_html__( 'Other options affecting the whole site.', 'zermatt' ),
		'priority'    => 140
	) );


	//
	// Group options by registering the setting first, and the control right after.
	//

	//
	// Homepage
	//
	$wpc->add_control( new Zermatt_Customize_Flexslider_Control( $wpc, 'home_slider', array(
		'section'     => 'homepage',
		'label'       => esc_html__( 'Home Carousel', 'zermatt' ),
		'description' => esc_html__( 'Fine-tune the homepage carousel.', 'zermatt' ),
	) ) );


	//
	// Layout
	//
	$wpc->add_setting( 'excerpt_length', array(
		'default'           => 55,
		'sanitize_callback' => 'absint',
	) );
	$wpc->add_control( 'excerpt_length', array(
		'type'        => 'number',
		'input_attrs' => array(
			'min'  => 10,
			'step' => 1,
		),
		'section'     => 'layout',
		'label'       => esc_html__( 'Automatically generated excerpt length (in words)', 'zermatt' ),
	) );

	$wpc->add_setting( 'pagination_method', array(
		'default'           => 'numbers',
		'sanitize_callback' => 'zermatt_sanitize_pagination_method',
	) );
	$wpc->add_control( 'pagination_method', array(
		'type'    => 'select',
		'section' => 'layout',
		'label'   => esc_html__( 'Pagination method', 'zermatt' ),
		'choices' => array(
			'numbers' => esc_html_x( 'Numbered links', 'pagination method', 'zermatt' ),
			'text'    => esc_html_x( '"Previous - Next" links', 'pagination method', 'zermatt' ),
		),
	) );


	//
	// Header Bar
	//
	$wpc->get_control( 'header_image' )->section = 'header';

	$wpc->add_setting( 'header_bg_color', array(
		'default'           => '#252525',
		'sanitize_callback' => 'zermatt_sanitize_hex_color',
	) );
	$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'header_bg_color', array(
		'section' => 'header',
		'label'   => esc_html__( 'Background Color', 'zermatt' ),
	) ) );

	$wpc->add_setting( 'header_text_color', array(
		'default'           => '',
		'sanitize_callback' => 'zermatt_sanitize_hex_color',
	) );
	$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'header_text_color', array(
		'section' => 'header',
		'label'   => esc_html__( 'Main Color', 'zermatt' ),
	) ) );

	$wpc->add_setting( 'header_nav_color', array(
		'default'           => '',
		'sanitize_callback' => 'zermatt_sanitize_hex_color',
	) );
	$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'header_nav_color', array(
		'section' => 'header',
		'label'   => esc_html__( 'Subnav text color', 'zermatt' ),
	) ) );

	$wpc->add_setting( 'header_hover_color', array(
		'default'           => '',
		'sanitize_callback' => 'zermatt_sanitize_hex_color',
	) );
	$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'header_hover_color', array(
		'section' => 'header',
		'label'   => esc_html__( 'Hover/Active Color', 'zermatt' ),
	) ) );

	$wpc->add_setting( 'header_tagline', array(
		'default'           => 1,
		'sanitize_callback' => 'zermatt_sanitize_checkbox',
	) );
	$wpc->add_control( 'header_tagline', array(
		'type'    => 'checkbox',
		'section' => 'header',
		'label'   => esc_html__( 'Show tagline.', 'zermatt' ),
	) );

	$wpc->add_setting( 'header_alt_menu', array(
		'default'           => 1,
		'sanitize_callback' => 'zermatt_sanitize_checkbox',
	) );
	$wpc->add_control( 'header_alt_menu', array(
		'type'    => 'checkbox',
		'section' => 'header',
		'label'   => esc_html__( 'Menu always appears mobile-like.', 'zermatt' ),
	) );

	$wpc->add_setting( 'header_booking_button', array(
		'default'           => 1,
		'sanitize_callback' => 'zermatt_sanitize_checkbox',
	) );
	$wpc->add_control( 'header_booking_button', array(
		'type'    => 'checkbox',
		'section' => 'header',
		'label'   => esc_html__( 'Show Booking button.', 'zermatt' ),
	) );

	$wpc->add_setting( 'header_weather', array(
		'default'           => 1,
		'sanitize_callback' => 'zermatt_sanitize_checkbox',
	) );
	$wpc->add_control( 'header_weather', array(
		'type'        => 'checkbox',
		'section'     => 'header',
		'label'       => esc_html__( 'Show weather widget.', 'zermatt' ),
		'description' => wp_kses( sprintf( __( 'In order for the weather widget to work, you need to provide more information in the <a href="%s">Weather Section</a>.', 'zermatt' ), esc_url( admin_url( 'customize.php?autofocus[section]=theme_openweathermap' ) ) ), array( 'a' => array( 'href' => true ) ) ),
	) );



	//
	// Typography
	//
	require_once get_theme_file_path( 'inc/customizer/sections/global/typography.php' );

	$wpc->add_setting( 'lowercase_content_headings', array(
		'default'           => '',
		'sanitize_callback' => 'zermatt_sanitize_checkbox',
	) );
	$wpc->add_control( 'lowercase_content_headings', array(
		'type'        => 'checkbox',
		'section'     => 'typography',
		'label'       => esc_html__( 'Lowercase content headings', 'zermatt' )
	) );


	//
	// Content colors
	//
	$wpc->get_control( 'background_image' )->section      = 'colors';
	$wpc->get_control( 'background_repeat' )->section     = 'colors';
	$wpc->get_control( 'background_attachment' )->section = 'colors';
	if ( ! is_null( $wpc->get_control( 'background_position_x' ) ) ) {
		$wpc->get_control( 'background_position_x' )->section = 'colors';
	} else {
		$wpc->get_control( 'background_position' )->section = 'colors';
		$wpc->get_control( 'background_preset' )->section   = 'colors';
		$wpc->get_control( 'background_size' )->section     = 'colors';
	}

	$wpc->add_setting( 'global_body_bg_color', array(
		'default'           => '',
		'sanitize_callback' => 'zermatt_sanitize_hex_color',
	) );
	$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'global_body_bg_color', array(
		'section'     => 'colors',
		'label'       => esc_html__( 'Body Background Color', 'zermatt' )
	) ) );

	$wpc->add_setting( 'global_primary_color', array(
		'default'           => '',
		'sanitize_callback' => 'zermatt_sanitize_hex_color',
	) );
	$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'global_primary_color', array(
		'section'     => 'colors',
		'label'       => esc_html__( 'Primary color', 'zermatt' )
	) ) );

	$wpc->add_setting( 'global_text_color', array(
		'default'           => '',
		'sanitize_callback' => 'zermatt_sanitize_hex_color',
	) );
	$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'global_text_color', array(
		'section'     => 'colors',
		'label'       => esc_html__( 'Text Color', 'zermatt' )
	) ) );

	$wpc->add_setting( 'global_link_color', array(
		'default'           => '',
		'sanitize_callback' => 'zermatt_sanitize_hex_color',
	) );
	$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'global_link_color', array(
		'section'     => 'colors',
		'label'       => esc_html__( 'Content Link Color', 'zermatt' )
	) ) );

	$wpc->add_setting( 'global_link_hover_color', array(
		'default'           => '',
		'sanitize_callback' => 'zermatt_sanitize_hex_color',
	) );
	$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'global_link_hover_color', array(
		'section'     => 'colors',
		'label'       => esc_html__( 'Content Link Hover Color', 'zermatt' )
	) ) );

	$wpc->add_setting( 'global_btn_text_color', array(
		'default'           => '',
		'sanitize_callback' => 'zermatt_sanitize_hex_color',
	) );
	$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'global_btn_text_color', array(
		'section'     => 'colors',
		'label'       => esc_html__( 'Button Text Color', 'zermatt' )
	) ) );

	$wpc->add_setting( 'global_btn_bg_color', array(
		'default'           => '',
		'sanitize_callback' => 'zermatt_sanitize_hex_color',
	) );
	$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'global_btn_bg_color', array(
		'section'     => 'colors',
		'label'       => esc_html__( 'Button Background Color', 'zermatt' )
	) ) );

	$wpc->add_setting( 'global_btn_hover_bg_color', array(
		'default'           => '',
		'sanitize_callback' => 'zermatt_sanitize_hex_color',
	) );
	$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'global_btn_hover_bg_color', array(
		'section'     => 'colors',
		'label'       => esc_html__( 'Button Hover Background Color', 'zermatt' )
	) ) );

	$wpc->add_setting( 'global_border_color', array(
		'default'           => '',
		'sanitize_callback' => 'zermatt_sanitize_hex_color',
	) );
	$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'global_border_color', array(
		'section'     => 'colors',
		'label'       => esc_html__( 'Global Border Color', 'zermatt' )
	) ) );


	//
	// Sidebar colors
	//
	$wpc->add_setting( 'sidebar_bg_color', array(
		'default'           => '',
		'sanitize_callback' => 'zermatt_sanitize_hex_color',
	) );
	$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'sidebar_bg_color', array(
		'section'     => 'sidebar_colors',
		'label'       => esc_html__( 'Background color', 'zermatt' ),
	) ) );

	$wpc->add_setting( 'sidebar_text_color', array(
		'default'           => '',
		'sanitize_callback' => 'zermatt_sanitize_hex_color',
	) );
	$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'sidebar_text_color', array(
		'section'     => 'sidebar_colors',
		'label'       => esc_html__( 'Text color', 'zermatt' ),
	) ) );

	$wpc->add_setting( 'sidebar_link_color', array(
		'default'           => '',
		'sanitize_callback' => 'zermatt_sanitize_hex_color',
	) );
	$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'sidebar_link_color', array(
		'section'     => 'sidebar_colors',
		'label'       => esc_html__( 'Link color', 'zermatt' ),
	) ) );

	$wpc->add_setting( 'sidebar_hover_color', array(
		'default'           => '',
		'sanitize_callback' => 'zermatt_sanitize_hex_color',
	) );
	$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'sidebar_hover_color', array(
		'section'     => 'sidebar_colors',
		'label'       => esc_html__( 'Link Hover color', 'zermatt' ),
	) ) );

	$wpc->add_setting( 'sidebar_title_color', array(
		'default'           => '',
		'sanitize_callback' => 'zermatt_sanitize_hex_color',
	) );
	$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'sidebar_title_color', array(
		'section'     => 'sidebar_colors',
		'label'       => esc_html__( 'Widget titles color', 'zermatt' ),
	) ) );

	$wpc->add_setting( 'sidebar_border_color', array(
		'default'           => '',
		'sanitize_callback' => 'zermatt_sanitize_hex_color',
	) );
	$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'sidebar_border_color', array(
		'section'     => 'sidebar_colors',
		'label'       => esc_html__( 'Border color', 'zermatt' ),
	) ) );

	//
	// Social
	//
	$networks = zermatt_get_social_networks();

	foreach ( $networks as $network ) {
		$wpc->add_setting( 'social_' . $network['name'], array(
			'default'           => '',
			'sanitize_callback' => 'esc_url_raw',
		) );
		$wpc->add_control( 'social_' . $network['name'], array(
			'type'    => 'url',
			'section' => 'social',
			'label'   => sprintf( _x( '%s URL', 'social network url', 'zermatt' ), $network['label'] ),
		) );
	}

	$wpc->add_setting( 'rss_feed', array(
		'default'           => get_bloginfo( 'rss2_url' ),
		'sanitize_callback' => 'esc_url_raw',
	) );
	$wpc->add_control( 'rss_feed', array(
		'type'    => 'url',
		'section' => 'social',
		'label'   => esc_html__( 'RSS Feed', 'zermatt' ),
	) );



	//
	// Rooms
	//
	$wpc->add_setting( 'single_room_testimonial_title', array(
		'default'           => esc_html__( 'What they say about us', 'zermatt' ),
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wpc->add_control( 'single_room_testimonial_title', array(
		'type'        => 'text',
		'section'     => 'rooms',
		'label'       => esc_html__( 'Random testimonial title', 'zermatt' ),
		'description' => esc_html__( 'Title for the random testimonial that appears on room pages. Leave empty to disable.', 'zermatt' ),
	) );

	$wpc->add_setting( 'single_room_random_testimonial', array(
		'default'           => 1,
		'sanitize_callback' => 'zermatt_sanitize_checkbox',
	) );
	$wpc->add_control( 'single_room_random_testimonial', array(
		'type'    => 'checkbox',
		'section' => 'rooms',
		'label'   => esc_html__( "Show a random testimonial after the room's title.", 'zermatt' ),
	) );

	$wpc->add_setting( 'room_price_text', array(
		/* translators: :price: is a placeholder. Do not translate into your language.  */
		'default'           => esc_html__( 'From :price: / Night', 'zermatt' ),
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wpc->add_control( 'room_price_text', array(
		'type'        => 'text',
		'section'     => 'rooms',
		'label'       => esc_html__( 'Price text', 'zermatt' ),
		'description' => __( "The text that appears wherever the room price is shown. Use <code>:price:</code> to substitute with the actuall room's price being shown.", 'zermatt' ),
	) );


	//
	// Booking
	//
	$wpc->add_setting( 'booking_page', array(
		'default'           => '',
		'sanitize_callback' => 'zermatt_sanitize_intval_or_empty',
	) );
	$wpc->add_control( 'booking_page', array(
		'type'        => 'dropdown-pages',
		'section'     => 'booking',
		'label'       => esc_html__( 'Booking page', 'zermatt' ),
		'description' => __( 'Select the page that you have assigned the <strong>Booking Page</strong> template. This is required for the booking widget and header button to function properly.', 'zermatt' ),
	) );

	$wpc->add_setting( 'booking_email', array(
		'default'           => get_option( 'admin_email' ),
		'sanitize_callback' => 'sanitize_email',
	) );
	$wpc->add_control( 'booking_email', array(
		'type'        => 'email',
		'section'     => 'booking',
		'label'       => esc_html__( 'Booking email address', 'zermatt' ),
		'description' => esc_html__( 'The email address that booking requests will be delivered to. This is required for the booking form to function properly.', 'zermatt' ),
	) );

	$wpc->add_setting( 'contact_email', array(
		'default'           => get_option( 'admin_email' ),
		'sanitize_callback' => 'sanitize_email',
	) );
	$wpc->add_control( 'contact_email', array(
		'type'        => 'email',
		'section'     => 'booking',
		'label'       => esc_html__( 'Contact email address', 'zermatt' ),
		'description' => esc_html__( 'The email address that contact form messages will be delivered to. This is required for the contact form to function properly.', 'zermatt' ),
	) );


	//
	// Footer
	//
	$wpc->add_setting( 'footer_text', array(
		'default'           => zermatt_get_default_footer_text(),
		'sanitize_callback' => 'zermatt_sanitize_footer_text',
	) );
	$wpc->add_control( 'footer_text', array(
		'type'        => 'text',
		'section'     => 'footer',
		'label'       => esc_html__( 'Footer text left', 'zermatt' ),
		'description' => esc_html__( 'Allowed tags: a, abbr, acronym, b, br, code, em, i, img, li, ol, pre, span, strong, ul.', 'zermatt' ),
	) );

	$wpc->add_setting( 'footer_text_right', array(
		'default'           => zermatt_get_default_footer_text_right(),
		'sanitize_callback' => 'zermatt_sanitize_footer_text',
	) );
	$wpc->add_control( 'footer_text_right', array(
		'type'        => 'text',
		'section'     => 'footer',
		'label'       => esc_html__( 'Footer text right', 'zermatt' ),
		'description' => esc_html__( 'Allowed tags: a, abbr, acronym, b, br, code, em, i, img, li, ol, pre, span, strong, ul.', 'zermatt' ),
	) );



	//
	// Instagram Widget
	//
	if ( class_exists( 'null_instagram_widget' ) ) {
		$wpc->add_setting( 'instagram_auto', array(
			'default'           => 1,
			'sanitize_callback' => 'zermatt_sanitize_checkbox',
		) );
		$wpc->add_control( 'instagram_auto', array(
			'type'    => 'checkbox',
			'section' => 'instagram_widget',
			'label'   => esc_html__( 'WP Instagram: Slideshow.', 'zermatt' ),
		) );

		$wpc->add_setting( 'instagram_speed', array(
			'default'           => 300,
			'sanitize_callback' => 'zermatt_sanitize_intval_or_empty',
		) );
		$wpc->add_control( 'instagram_speed', array(
			'type'    => 'number',
			'section' => 'instagram_widget',
			'label'   => esc_html__( 'WP Instagram: Slideshow Speed.', 'zermatt' ),
		) );
	}


	//
	// Other
	//
	$wpc->add_setting( 'google_anaytics_tracking_id', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wpc->add_control( 'google_anaytics_tracking_id', array(
		'type'        => 'text',
		'section'     => 'other',
		'label'       => esc_html__( 'Google Analytics Tracking ID', 'zermatt' ),
		'description' => wp_kses( sprintf( __( 'Tracking is enabled only for the non-admin portion of your website. If you need fine-grained control of the tracking code, you are strongly adviced to <a href="%s" target="_blank">use a specialty plugin</a> instead.', 'zermatt' ), 'https://wordpress.org/plugins/search.php?q=analytics' ), array( 'a' => array( 'href' => array(), 'target' => array() ) ) ),
	) );

	$wpc->add_setting( 'google_maps_api_enable', array(
		'default'           => '',
		'sanitize_callback' => 'zermatt_sanitize_checkbox',
	) );
	$wpc->add_control( 'google_maps_api_enable', array(
		'type'        => 'checkbox',
		'section'     => 'other',
		'label'       => esc_html__( 'Enable Google Maps API.', 'zermatt' ),
		'description' => esc_html__( 'The Google Maps API must only be loaded once in each page. Since many plugins may try to load it as well, you might want to disable it from the theme to avoid potential errors.', 'zermatt' ),
	) );

	$wpc->add_setting( 'google_maps_api_key', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wpc->add_control( 'google_maps_api_key', array(
		'type'        => 'text',
		'section'     => 'other',
		'label'       => esc_html__( 'Google Maps API key', 'zermatt' ),
		'description' => sprintf( __( 'Paste here your Google Maps API Key. Maps will <strong>not</strong> be displayed without an API key. You need to issue a key from <a href="%1$s" target="_blank">Google Accounts</a>, and make sure the <strong>Google Maps JavaScript API</strong> is enabled. For instructions on issuing an API key, <a href="%2$s" target="_blank">read this article</a>.', 'zermatt' ),
			'https://code.google.com/apis/console/',
			'http://www.cssigniter.com/docs/article/generate-a-google-maps-api-key/'
		),
	) );

	$wpc->add_setting( 'show_preloader', array(
		'default'           => 1,
		'sanitize_callback' => 'zermatt_sanitize_checkbox',
	) );
	$wpc->add_control( 'show_preloader', array(
		'type'        => 'checkbox',
		'section'     => 'other',
		'label'       => esc_html__( 'Show animated pre-loader.', 'zermatt' ),
		'description' => esc_html__( 'The pre-loader is shown while a page loads, reducing the perceived loading time and showing the complete rendered page at once.', 'zermatt' ),
	) );



	//
	// site_tagline Section
	//
	$wpc->add_setting( 'logo', array(
		'default'           => '',
		'sanitize_callback' => 'esc_url_raw',
	) );
	$wpc->add_control( new WP_Customize_Image_Control( $wpc, 'logo', array(
		'section'     => 'title_tagline',
		'label'       => esc_html__( 'Logo', 'zermatt' ),
		'description' => esc_html__( 'If an image is selected, it will replace the default textual logo (site name) on the header.', 'zermatt' ),
	) ) );
}

add_action( 'customize_register', 'zermatt_customize_register_custom_controls', 9 );

/**
 * Registers custom Customizer controls.
 *
 * @param WP_Customize_Manager $wpc Reference to the customizer's manager object.
 */
function zermatt_customize_register_custom_controls( $wpc ) {
	require get_template_directory() . '/inc/customizer-controls/flexslider.php';
	require get_template_directory() . '/inc/customizer-controls/static-text.php';

	require_once get_theme_file_path( '/inc/customizer-controls/typography/typography.php' );
	$wpc->register_control_type( 'Zermatt_Customize_Typography_Control' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function zermatt_customize_preview_js() {
	// Generic preview code.
	wp_enqueue_script( 'zermatt-customizer-preview', get_theme_file_uri( '/inc/customizer/preview/preview.js' ), array( 'jquery' ), zermatt_asset_version(), true );

	// Options-specific preview code.
	wp_enqueue_script( 'zermatt-customizer-preview-global', get_theme_file_uri( '/inc/customizer/preview/global.js' ), array( 'jquery' ), zermatt_asset_version(), true );
}
add_action( 'customize_preview_init', 'zermatt_customize_preview_js' );

function zermatt_customize_controls_js() {
	wp_enqueue_style( 'zermatt-customizer-controls', get_theme_file_uri( '/inc/customizer-controls/style.css' ), array(), zermatt_asset_version() );
}
add_action( 'customize_controls_enqueue_scripts', 'zermatt_customize_controls_js' );

function zermatt_typography_control_defaults_empty_breakpoints( $override_breakpoints = array() ) {
	$defaults = array(
		'desktop' => array(
			'family'     => '',
			'variant'    => '',
			'size'       => '',
			'lineHeight' => '',
			'transform'  => '',
			'spacing'    => '',
			'is_gfont'   => false,
		),
		'tablet'  => array(
			'family'     => '',
			'variant'    => '',
			'size'       => '',
			'lineHeight' => '',
			'transform'  => '',
			'spacing'    => '',
			'is_gfont'   => false,
		),
		'mobile'  => array(
			'family'     => '',
			'variant'    => '',
			'size'       => '',
			'lineHeight' => '',
			'transform'  => '',
			'spacing'    => '',
			'is_gfont'   => false,
		),
	);

	$return = array();
	foreach ( $defaults as $breakpoint => $values ) {
		if ( isset( $override_breakpoints[ $breakpoint ] ) && is_array( $override_breakpoints[ $breakpoint ] ) ) {
			$return[ $breakpoint ] = array_merge( $values, $override_breakpoints[ $breakpoint ] );
		} else {
			$return[ $breakpoint ] = $values;
		}
	}

	return $return;
}

function zermatt_sanitize_typography_control_breakpoints( $values ) {
	$defaults = zermatt_typography_control_defaults_empty_breakpoints();

	if ( ! empty( $values ) && is_string( $values ) ) {
		$values = json_decode( $values, true );
	}

	if ( ! is_array( $values ) ) {
		return $defaults;
	}

	$values = wp_parse_args( $values, $defaults );

	foreach ( $values as $breakpoint => $value ) {
		if ( ! array_key_exists( $breakpoint, $defaults ) ) {
			unset( $values[ $breakpoint ] );
		}
	}

	$new_values = array();

	foreach ( $values as $breakpoint => $breakpoint_values ) {
		if ( array_key_exists( $breakpoint, $defaults ) ) {
			$new_breakpoint_values = wp_parse_args( $breakpoint_values, $defaults[ $breakpoint ] );

			$new_breakpoint_values['family']     = sanitize_text_field( $new_breakpoint_values['family'] );
			$new_breakpoint_values['variant']    = sanitize_text_field( $new_breakpoint_values['variant'] );
			$new_breakpoint_values['size']       = zermatt_sanitize_intval_or_empty( $new_breakpoint_values['size'] );
			$new_breakpoint_values['lineHeight'] = zermatt_sanitize_floatval_or_empty( $new_breakpoint_values['lineHeight'] );
			$new_breakpoint_values['transform']  = sanitize_text_field( $new_breakpoint_values['transform'] );
			$new_breakpoint_values['spacing']    = zermatt_sanitize_floatval_or_empty( $new_breakpoint_values['spacing'] );
			$new_breakpoint_values['is_gfont']   = (bool) intval( $new_breakpoint_values['is_gfont'] );

			$new_values[ $breakpoint ] = $new_breakpoint_values;
		}
	}

	return $new_values;
}

/**
 * Customizer partial callbacks.
 */
require_once get_theme_file_path( '/inc/customizer/partial-callbacks.php' );

/**
 * CSS Generator.
 */
require_once get_theme_file_path( '/inc/customizer/class-zermatt-customizer-css-generator.php' );

/**
 * Customizer generated styles.
 */
require_once get_theme_file_path( '/inc/customizer/generated-styles.php' );
