<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Zermatt Elementor related code.
 */

add_action( 'elementor/theme/register_locations', 'Elementor\zermatt_register_elementor_locations' );
function zermatt_register_elementor_locations( $elementor_theme_manager ) {
	$elementor_theme_manager->register_location( 'header' );
	$elementor_theme_manager->register_location( 'footer' );
	$elementor_theme_manager->register_location( 'single' );
	$elementor_theme_manager->register_location( 'archive' );
}


add_action( 'elementor/init', 'Elementor\zermatt_elements_init' );
function zermatt_elements_init() {
	Plugin::instance()->elements_manager->add_category(
		'zermatt-elements',
		[
			'title' => __( 'Zermatt Elements', 'zermatt' ),
			'icon'  => 'font',
		],
		1
	);
}

add_action( 'elementor/widgets/widgets_registered', 'Elementor\add_zermatt_elements' );
function add_zermatt_elements() {
	class Widget_Post_Type extends Widget_Base {

		public function get_name() {
			return 'post_type_widget';
		}

		public function get_title() {
			return __( 'Zermatt Post Type', 'zermatt' );
		}

		public function get_icon() {
			return 'fa fa-window-maximize';
		}

		public function get_categories() {
			return [ 'zermatt-elements' ];
		}

		protected function register_controls() {
			$this->start_controls_section(
				'section_title',
				[
					'label' => __( 'Zermatt Post Type', 'zermatt' ),
				]
			);

			$this->add_control(
				'html_msg',
				[
					'type'            => Controls_Manager::RAW_HTML,
					'raw'             => __( 'Display any post type item from Zermatt by first selecting the post type, e.g. "Rooms" and then the item itself.', 'zermatt' ),
					'content_classes' => 'ci-description',
				]
			);

			$this->add_control(
				'post_types',
				[
					'label'   => __( 'Post Type', 'zermatt' ),
					'type'    => Controls_Manager::SELECT,
					'default' => '',
					'options' => zermatt_post_types(),
				]
			);

			$this->add_control(
				'selected_post',
				[
					'label'   => __( 'Post', 'zermatt' ),
					'type'    => Controls_Manager::SELECT,
					'default' => '',
					'options' => '',
				]
			);

			$this->add_control(
				'view',
				[
					'label'   => __( 'View', 'zermatt' ),
					'type'    => Controls_Manager::HIDDEN,
					'default' => 'traditional',
				]
			);

			$this->end_controls_section();

		}

		protected function render() {
			$settings = $this->get_settings();

			if ( empty( $settings['selected_post'] ) ) {
				return;
			}

			$post_id = $settings['selected_post'];

			$q = new \WP_Query( array(
				'post_type' => get_post_type( $post_id ),
				'p'         => $post_id,
			) );

			while ( $q->have_posts() ) : $q->the_post();
				get_template_part( 'item', get_post_type() );
			endwhile;

			wp_reset_postdata();

		}

	}
	Plugin::instance()->widgets_manager->register_widget_type( new Widget_Post_Type() );
}

add_action( 'elementor/editor/before_enqueue_scripts', 'Elementor\zermatt_ajax_posts' );
function zermatt_ajax_posts() {

	if ( ! defined( 'ELEMENTOR_VERSION' ) ) {
		return;
	}

	wp_enqueue_script( 'ajax-script', get_template_directory_uri() . '/js/admin/post_ajax.js' );

	$params['no_posts_found']      = __( 'No posts found.', 'zermatt' );
	$params['ajaxurl']             = admin_url( 'admin-ajax.php' );
	$params['zermatt_post_nonce'] = wp_create_nonce( 'zermatt_post_nonce' );

	wp_localize_script( 'ajax-script', 'ElementWidget', $params );
}

