<?php
// TODO: Remove when theme reaches v1.4
add_action( 'init', 'zermatt_migrate_custom_css_to_customizer' );
function zermatt_migrate_custom_css_to_customizer() {
	if ( ! is_admin() || wp_doing_ajax() || ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) ) {
		return;
	}

	$migrated = get_theme_mod( 'custom_css_migrated', false );

	if ( $migrated || ! function_exists( 'wp_update_custom_css_post' ) ) {
		return;
	}

	// Migrate any existing theme CSS to the core option added in WordPress 4.7.
	$css = get_theme_mod( 'custom_css', '' );
	if ( $css ) {
		// Preserve any CSS already added to the core option.
		$core_css = wp_get_custom_css();

		$return = wp_update_custom_css_post( $core_css .
			PHP_EOL . PHP_EOL .
			"/* Migrated CSS from the theme's old custom CSS setting. */" .
			PHP_EOL .
			html_entity_decode( $css )
		);

		if ( ! is_wp_error( $return ) ) {
			// Remove the old option, so that the CSS is stored in only one place moving forward.
			set_theme_mod( 'custom_css', '' );
			set_theme_mod( 'custom_css_migrated', true );
		}
	}
}

// TODO: Remove when theme reaches v1.4
add_action( 'after_setup_theme', 'zermatt_migrate_typography_mods' );
function zermatt_migrate_typography_mods() {
	if ( get_theme_mod( 'migrated_typography' ) ) {
		return;
	}

	$sizes = array(
		'h1_size'            => 'global_typo_h1',
		'h2_size'            => 'global_typo_h2',
		'h3_size'            => 'global_typo_h3',
		'h4_size'            => 'global_typo_h4',
		'h5_size'            => 'global_typo_h5',
		'h6_size'            => 'global_typo_h6',
		'body_text_size'     => 'global_typo_body',
		'widgets_title_size' => 'global_typo_widget_titles',
		'widgets_text_size'  => 'global_typo_widget_text',
	);

	foreach ( $sizes as $old => $new ) {
		if ( get_theme_mod( $old ) ) {
			$new_mod = zermatt_typography_control_defaults_empty_breakpoints( array(
				'desktop' => array(
					'size' => intval( get_theme_mod( $old ) ),
				),
			) );
			set_theme_mod( $new, $new_mod );
			remove_theme_mod( $old );
		}
	}

	if ( 1 === get_theme_mod( 'lowercase_widget_titles', 0 ) ) {
		$mod = get_theme_mod( 'global_typo_widget_titles', zermatt_customizer_defaults( 'global_typo_widget_titles' ) );

		$mod['desktop']['transform'] = 'none';

		set_theme_mod( 'global_typo_widget_titles', $mod );
		remove_theme_mod( 'lowercase_widget_titles' );
	}

	set_theme_mod( 'migrated_typography', true );
}

// TODO: Remove migration when theme reaches v1.6
// TODO: When we remove the migration code, make sure to also clean up the options/meta created by the migration.
if ( ! get_option( 'zermatt_migrated_typography_lineheight' ) ) {
	add_action( 'wp_loaded', 'zermatt_migrate_typography_line_height_pixels_to_unitless' );
}
function zermatt_migrate_typography_line_height_pixels_to_unitless() {
	if ( ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) ||
		( defined( 'DOING_CRON' ) && DOING_CRON ) ) {
		return;
	}

	if ( get_option( 'zermatt_migrated_typography_lineheight' ) ) {
		return;
	}

	$theme_mods = array_keys( zermatt_get_registered_typography_controls() );

	foreach ( $theme_mods as $key ) {
		$value = get_theme_mod( $key );
		if ( is_array( $value ) ) {
			$value = zermatt_convert_typography_line_height_to_unitless( $value );
			set_theme_mod( $key, $value );
		}
	}

	update_option( 'zermatt_migrated_typography_lineheight', true, true );
}

function zermatt_convert_typography_line_height_to_unitless( $typo_array ) {
	if ( ! is_array( $typo_array ) ) {
		return $typo_array;
	}

	foreach ( $typo_array as $breakpoint => $bp_values ) {
		if ( ! empty( $bp_values['size'] ) && ! empty( $bp_values['lineHeight'] ) ) {
			$typo_array[ $breakpoint ]['lineHeight'] = round( $bp_values['lineHeight'] / $bp_values['size'], 2 );
		} elseif ( empty( $bp_values['size'] ) && ! empty( $bp_values['lineHeight'] ) ) {
			$typo_array[ $breakpoint ]['lineHeight'] = '';
		}
	}

	return $typo_array;
}

// TODO: Remove when theme reaches v1.6
// Fix typography mods that don't have a font family assigned.
// These were caused by zermatt_migrate_typography_mods() in previous versions, as (at the time) default typography settings weren't outputted.
// Also, this needs to run after zermatt_migrate_typography_line_height_pixels_to_unitless(), otherwise it will re-calculate already unit-less values,
// causing extremely small new unit-less values.
add_action( 'wp_loaded', 'zermatt_fix_empty_family_typography_mods' );
function zermatt_fix_empty_family_typography_mods() {
	if ( ! get_theme_mod( 'migrated_typography' ) || ! get_option( 'zermatt_migrated_typography_lineheight' ) || get_theme_mod( 'migrated_typography_filled_defaults' ) ) {
		return;
	}

	$mods = array(
		'global_typo_h1',
		'global_typo_h2',
		'global_typo_h3',
		'global_typo_h4',
		'global_typo_h5',
		'global_typo_h6',
		'global_typo_body',
		'global_typo_widget_titles',
		'global_typo_widget_text',
	);

	foreach ( $mods as $key ) {
		$value   = get_theme_mod( $key );
		$default = zermatt_customizer_defaults( $key );

		if ( ! is_array( $value ) || ! isset( $value['desktop']['family'] ) ) {
			$value = $default;
		} else {
			// 'family' and 'is_gfont' are a pair, so make sure to copy them together.
			$family = $value['desktop']['family'];
			if ( '' === $family ) {
				$value['desktop']['family']   = $default['desktop']['family'];
				$value['desktop']['is_gfont'] = $default['desktop']['is_gfont'];
			}

			// Go through the rest.
			foreach ( $default['desktop'] as $d_key => $d_value ) {
				if ( '' === $value['desktop'][ $d_key ] ) {
					$value['desktop'][ $d_key ] = $d_value;
				}
			}
		}

		set_theme_mod( $key, $value );
	}


	set_theme_mod( 'migrated_typography_filled_defaults', true );
}
