<?php
	$location_id = get_theme_mod( 'theme_openweathermap_location_id', zermatt_openweathermap_default_location_id() );
	$units       = get_theme_mod( 'theme_openweathermap_units', zermatt_openweathermap_default_units() );
	$unit        = zermatt_openweathermap_get_temperature_unit_symbol( $units );
?>
<?php if ( ! empty( $location_id ) && ! empty( $units ) ) : ?>
	<div class="resort-info theme-weather" data-location-id="<?php echo esc_attr( $location_id ); ?>" data-units="<?php echo esc_attr( $units ); ?>" data-unit="<?php echo esc_attr( $unit ); ?>">
		<div class="resort-weather">
			<span class="resort-temperature theme-weather-temp"></span>
			<i class="wi theme-weather-icon"></i>
		</div>
		<div class="resort-location theme-weather-location">
			<span class="resort-town"></span>
			<span class="resort-country"></span>
		</div>
	</div>
<?php endif; ?>
